/*
 * Vg1pwsApplet.java
 *
 * Created on April 27, 2005, 11:02 AM
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.DasApplication;
import org.das2.graph.DasPlot;
import org.das2.graph.StackedHistogramRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.*;

/**
 * see http://www.apl.jhu.edu/~hall/java/Java-from-JavaScript.html for nice examples of
 * how javascript and java interact.
 *
 * @author Jeremy
 */
public class Vg1pwsApplet extends javax.swing.JApplet {
    
    Vg1pws app;
    JFrame appFrame;
    DatumRange timeRange;
    File localRootFile;
    URL localRootURL;
    
    boolean waiting;

 /*   alm.addOptionalPositionArgument( 0, "startTime", "", "Start Time" );
            alm.addOptionalPositionArgument( 1, "endTime", "", "End Time" );
            alm.addOptionalPositionArgument( 2, "spacecraft", "", "vg1|vg2" );
            alm.addOptionalPositionArgument( 3, "pngFilename", "", "png Filename" );
            alm.addBooleanSwitchArgument( "spectrogram", "s", "spectrogram", "use spectrogram" );
            alm.addOptionalSwitchArgument( "peaksIndicator", "pk", "peaksIndicator", "maxLines", "grayPeaks|maxLines" );
            alm.addOptionalSwitchArgument( "height", "h", "height", "600", "canvas height" );
  *
            alm.addOptionalSwitchArgument( "width", "w", "width", "800", "canvas width" );
            alm.addOptionalSwitchArgument( "batchFile", "b", "batchFile", "", "batch description file" );
            alm.addOptionalSwitchArgument( "pngFilenameTemplate", "png", "pngFilenameTemplate", "BEGIN__END.png", "filename template" );
            alm.addBooleanSwitchArgument( "dontExit", "x", "dontExit", "don't exit after running" );
            String localRoot= prefs.get( DataSetDescriptorSelector.CURRENT_DIRECTORY_KEY, ".."+File.separator+".."+File.separator );
            alm.addOptionalSwitchArgument( "localRoot", "L", "localRoot", localRoot, "set initial root of local data cache" );
            alm.addBooleanSwitchArgument( "local", "l", "local", "force use of local root" );
            alm.addBooleanSwitchArgument( "localOnly", "lo", "localOnly", "don't provide server option" );*/
    
    private JFrame debuggerHelper() {
        JFrame f= new JFrame("debuggerHelper");
        
        Box vertPanel= new Box( BoxLayout.Y_AXIS );
        
        vertPanel.add( new JButton( new AbstractAction("setTimePart") {
            public void actionPerformed(ActionEvent e) {
                setTimePart( "VG1/1999/T990101_990111.PNG", 2, 10 );
            }
        }) );
        
        vertPanel.add( new JButton( new AbstractAction("setTimePart2") {
            public void actionPerformed(ActionEvent e) {
                setTimePart( "VG2/1999/T990101_990111.PNG", 3, 10 );
            }
        }) );
        
        f.getContentPane().add( vertPanel );
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation( JFrame.HIDE_ON_CLOSE );
        return f;
    }
    
    private URL getDirectoryFromDocBaseURL( URL docBase, String localRoot ) throws MalformedURLException {
        
        //System.err.println("docBase="+docBase);
        String surl= docBase.toString();

        String string; // this will contain the filename.

        //solaris/mozilla  file:/home/jbf/VGPW_0101_1/EXTRAS/VG1_1983.HTM
        //  "http://www-pw.physics.uiowa.edu/plasma-wave/voyager/data/VGPW_0101/EXTRAS/HTML/VG1_1977.HTM"
        string= surl.toString();
        int idx;

        // docbase includes HTM file.
        if ( string.endsWith("HTM") ) {
            idx= string.lastIndexOf("/");
            string= string.substring(0,idx+1);
        }        

        URL docBaseFile= new URL( string );
        
        URL result;
        try {
            result= new URL( docBaseFile, localRoot );
            return result;
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
    
    public void init() {
        super.init();
        
        String buildTime= "???";
        java.net.URL buildURL= this.getClass().getResource("/buildTime.txt");
        if ( buildURL!=null ) {
            try {
                BufferedReader reader= new BufferedReader( new InputStreamReader( buildURL.openStream() ) );
                buildTime= reader.readLine();
                reader.close();
            } catch ( IOException ex ) {
            }
        }
        
        System.err.println( "initializing applet, buildtime="+buildTime );
        
        System.err.println( "version=3.11" );
        
        DasApplication.getDefaultApplication().setApplet( true );
        //DasApplication.getDefaultApplication().setHeadless( false );
        
        //debuggerHelper();
        
        String startTimeStr= getParameter("startTime");
        String endTimeStr= getParameter("endTime");
        
        // eg. "Jan 2004"
        String timeRangeStr= getParameter("timeRange");
        
        // eg. "VG1/1977/T770829_770908.PNG"
        String pngFileName= getParameter( "pngFileName" );
        
        // eg. "1 of 10"
        String subInterval= getParameter( "subInterval" );
        
        String localRoot= getParameter( "root" );
        if ( localRoot==null ) {
            localRoot= "../..";
        }
        
        URL docBase= getDocumentBase();
        System.err.println("docBase="+docBase);
        System.err.println("localRoot="+localRoot);
        
        //if ( !docBase.getProtocol().equals("file") ) {
        //    String msg= "docBase protocol must be file://, not "+docBase.getProtocol()+"//";
        //    JOptionPane.showConfirmDialog( this, msg );
        //    throw new RuntimeException( msg );
        //}
        
        try {
            if ( localRoot.startsWith("/") || localRoot.charAt(1)==':' ) {
                if ( localRoot.charAt(1)==':') {
                    localRootURL= new URL( "file:/"+localRoot );
                } else {
                    localRootURL= new URL( "file:"+localRoot );
                }
            } else {
                localRootURL=  getDirectoryFromDocBaseURL( docBase, localRoot );
            }
        } catch ( MalformedURLException ex ) {
            throw new RuntimeException(ex);
        }
        
        //System.err.println("localRootFile="+localRootFile);
        //System.err.println("");
        
        String spacecraft= getParameter( "spacecraft" );
        
        timeRange=null;
        
        if ( startTimeStr!=null ) {
            Datum startTime= TimeUtil.createValid(startTimeStr);
            Datum endTime= TimeUtil.createValid(endTimeStr);
            timeRange= new DatumRange( startTime, endTime );
        }
        
        if ( timeRangeStr!=null ) {
            timeRange= DatumRangeUtil.parseTimeRangeValid(timeRangeStr);
        }
        
        if ( pngFileName!=null ) {
            String yymmdd1= pngFileName.substring( 10, 16 );
            String yymmdd2= pngFileName.substring( 17, 23 );
            if ( yymmdd1.substring(0,2).compareTo("77") < 0 ) yymmdd1= "20"+yymmdd1; else yymmdd1= "19"+yymmdd1;
            if ( yymmdd2.substring(0,2).compareTo("77") < 0 ) yymmdd2= "20"+yymmdd2; else yymmdd2= "19"+yymmdd2;
            DatumRange dr1= DatumRangeUtil.parseTimeRangeValid(yymmdd1);
            DatumRange dr2= DatumRangeUtil.parseTimeRangeValid(yymmdd2);
            
            timeRange= new DatumRange( dr1.min(), dr2.min() );
            String sc= pngFileName.substring(0,3);
            if ( sc.equals("VG1") ) {
                spacecraft= "Voyager 1";
            } else if ( sc.equals("VG2") ) {
                spacecraft= "Voyager 2";
            }
        }
        
        if ( spacecraft==null ) spacecraft="Voyager 1";
        if ( !( spacecraft.equals("Voyager 1") || spacecraft.equals("Voyager 2") ) ) {
            throw new IllegalArgumentException("spacecraft must be Voyager 1 or Voyager 2");
        }
        
        if ( subInterval!=null && timeRange!=null ) {
            String[] ss= subInterval.split("of");
            int isub= Integer.parseInt(ss[0].trim());
            int nsub= Integer.parseInt(ss[1].trim());
            timeRange= timeRange.rescale( (double)isub/nsub, (double)(isub+1)/nsub );
        }
        
        app= new Vg1pws( true, true, true, null );
        
        if ( timeRange!=null ) {
            launch( timeRange, Spacecraft.getByName(spacecraft), localRootURL );
            waiting= false;
        } else {
            waiting= true;
        }
    }
        
    /**
     * drop an event on the event queue, so that it is executed by a trusted thread.
     *
     * @param pngFileName "VG1/1977/T770829_770908.PNG"
     * @param ipart
     * @param npart   ipart of npart
     */
    public void setTimePart( final String pngFileName, final int ipart, final int npart ) {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                setTimePartImmediately( pngFileName, ipart, npart );
            }
        } );
    }
    
    private void setTimePartImmediately( String pngFileName, int ipart, int npart ) {
        //System.err.println( "setTimePartImmediately( "+pngFileName+" "+ipart+" of "+ npart );
        String yymmdd1= pngFileName.substring( 10, 16 );
        String yymmdd2= pngFileName.substring( 17, 23 );
        if ( yymmdd1.substring(0,2).compareTo("77") < 0 ) yymmdd1= "20"+yymmdd1; else yymmdd1= "19"+yymmdd1;
        if ( yymmdd2.substring(0,2).compareTo("77") < 0 ) yymmdd2= "20"+yymmdd2; else yymmdd2= "19"+yymmdd2;
        DatumRange dr1= DatumRangeUtil.parseTimeRangeValid(yymmdd1);
        DatumRange dr2= DatumRangeUtil.parseTimeRangeValid(yymmdd2);
        
        timeRange= new DatumRange( dr1.min(), dr2.min() );
        String sc= pngFileName.substring(0,3);
        Spacecraft spacecraft=null;
        if ( sc.equals("VG1") ) {
            spacecraft= Spacecraft.voyager1;
        } else if ( sc.equals("VG2") ) {
            spacecraft= Spacecraft.voyager2;
        } else {
            throw new IllegalArgumentException("bad spacecraft: >>"+sc+"<<, should be VG1 or VG2");
        }
        
        timeRange= timeRange.rescale( (double)ipart/npart, (double)(ipart+1)/npart );
        
        if ( app.applicationPanel == null ) {
            launch( timeRange, spacecraft, localRootURL );
            ((StackedHistogramRenderer)app.getPlot().getRenderer(0)).setPeaksIndicator( StackedHistogramRenderer.PeaksIndicator.GrayPeaks );
            app.getOptionsPanel().setRemovePLSInterference(false);
            app.getOptionsPanel().setRemoveSCEvents(false);
        } else {
            app.getOptionsPanel().setSpacecraft( spacecraft );
            app.getOptionsPanel().update();
            app.setTimeRange(timeRange.min(),timeRange.max());
            appFrame.setVisible(true);    
        }
        
        
        waiting= false;
        repaint();
        
    }
    
    public void testPermissions() {
        System.err.println( System.getProperty("java.awt.headless") );
    }
    
    private void launch( DatumRange dr, Spacecraft spacecraft, URL localRoot ) {
        
        int width= 700;
        int height= 500;
        
        try {
            app.getOptionsPanel().setFileSystemRoot(localRoot.toString());
        } catch ( MalformedURLException ex ) {
            // should be valid
            throw new RuntimeException(ex);
        }
        app.getOptionsPanel().setSpacecraft( spacecraft );
        
        appFrame= new JFrame("Voyager Low Rate Viewer");
        app.applicationPanel= app.createApplication( dr.min(), dr.max(), width, height );
        
        app.setFrame(appFrame);
        
        appFrame.setContentPane( app.getApplicationPanel() );
        appFrame.pack();
        appFrame.setVisible(true);
        appFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
        try {
            app.getOptionsPanel().update();
        } catch ( RuntimeException e ) {
            // bad root--it'll get handled later
        }
    }
    
    public void paint( Graphics g ) {
        g.setColor( Color.DARK_GRAY );
        g.fillRect(0,0,getWidth(),getHeight());
        g.setColor( Color.white );
        if ( waiting ) {
            g.drawString( "waiting", 10, 10 );
        } else {
            g.drawString( ""+timeRange, 10, 10 );
        }
    }
    
    public void stop() {
        //appFrame.setVisible(false);
    }
    
    public void start() {
        //   if ( !waiting ) appFrame.setVisible(true);
    }
    
    public void destroy() {
        if ( appFrame!=null ) appFrame.dispose();
        super.destroy();
    }
    
    public Vg1pws getApp() {
        return this.app;
    }
    
    public DasPlot getPlot() {
        return this.app.getPlot();
    }
}
