/*
 * Test.java
 *
 * Created on September 28, 2005, 1:29 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.components.DasProgressPanel;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.util.Probe;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

/**
 *
 * @author Jeremy
 */
public class Test__jbf {
    public static void testLocalRead() throws Exception {
        Probe probe= Probe.newProbe("foo");
        Spacecraft spacecraft= Spacecraft.voyager1;
        //File root= new File( "D:/" );
        File root= new File( "C:/Documents and Settings/Jeremy/Desktop/VOYAGER/" );
        Preferences prefs= Preferences.userNodeForPackage( Vg1pws.class );
        String optionsString= "filterPLS=true&filterSpacecraftEvents=true&noiseFilter=false&removeBackground=false" ;
        String id= "class:edu.uiowa.physics.pw.apps.vgpws.Vg1pwsDataSetDescriptor?"+
                "spacecraft="+spacecraft.toInt()+"&root="+URLEncoder.encode(root.toString(),"US-ASCII")+"&"+optionsString;
        
        for ( int i=0; i<10; i++ ) {
            Vg1pwsDataSetDescriptor dsd;
            dsd= (Vg1pwsDataSetDescriptor)DataSetDescriptor.create( id );
            
            dsd.setDefaultCaching(false);
            Vg1pwsEventsDataSetDescriptor eventsDsd= new Vg1pwsEventsDataSetDescriptor( new URL("http://www-pw.physics.uiowa.edu/voyager/local1/"), spacecraft );
            
            dsd.setEventsDataSetDescriptor( eventsDsd );
            DatumRange dr= DatumRangeUtil.parseTimeRangeValid("2004 oct-dec");
            
            long t0= System.currentTimeMillis();
            
            DataSet ds= dsd.getDataSet( dr.min(), dr.max(), Units.seconds.createDatum(3600), DasProgressPanel.createFramed("loading") );
            //DataSet ds= dsd.getDataSet( dr.min(), dr.max(), null, DasProgressPanel.createFramed("loading") );
            probe.add( "new", (System.currentTimeMillis()-t0) );
        }
        //System.out.println("ds="+ds);
        //System.out.println("dataSet read in "+(System.currentTimeMillis()-t0)+" ms  from "+root );
        
    }
    
    private static Map toMap( String urlArgsString ) {
        try {
            String[] s= urlArgsString.split( "&" );
            HashMap result= new HashMap();
            for ( int i=0; i<s.length; i++ ) {
                String[] ss= s[i].split("=");
                String key= ss[0];
                String value= URLDecoder.decode(ss[1],"US_ASCII");
                result.put(key,value);
            }
            return result;
        } catch ( UnsupportedEncodingException e ) {
            throw new RuntimeException(e);
        }
    }
    public static void main( String[] args ) throws Exception {
        //vg1pws.main( new String[] { "2004-3-5", "2004-3-18", "vg1", "vg1pws.2004-3-5.png" } );
        testLocalRead();
    }
}
