package edu.uiowa.physics.pw.apps.vgpws;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;


class TCAComboBoxModel extends AbstractListModel implements ComboBoxModel {
    private final Vg1pws vg1pws;
    
    ComboBoxModel m;
    
    private Map v1tcas = new LinkedHashMap();
    private Map v2tcas = new LinkedHashMap();
    private Map tcas;

    private Object selectedItem;
    
    public TCAComboBoxModel(Vg1pws vg1pws, Spacecraft spacecraft) {
        this.vg1pws = vg1pws;
        v2tcas.put( "No Trajectory Parameters", "" );
        v2tcas.put("v2 Heliocentric Trajectory Parameters",  "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemSun");
        v2tcas.put("v2 Earth Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemE");
        v2tcas.put("v2 Jupiter Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemJ");
        v2tcas.put("v2 Saturn Trajectory Parameters",  "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemS");
        v2tcas.put("v2 Uranus Trajectory Parameters",  "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemU");
        v2tcas.put("v2 Neptune Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemN");
        
        v1tcas.put( "No Trajectory Parameters", "" );
        v1tcas.put("v1 Heliocentric Trajectory Parameters",  "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemSun");
        v1tcas.put("v1 Earth Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemE");
        v1tcas.put("v1 Jupiter Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemJ");
        v1tcas.put("v1 Saturn Trajectory Parameters",  "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemS");
        
        setSpacecraft(spacecraft);
    }
    
    public void setSpacecraft(Spacecraft spacecraft) {
        if (tcas!=null) fireIntervalRemoved( this, 0, tcas.size() );
        if (spacecraft == Spacecraft.voyager2) {
            this.tcas= this.v2tcas;
        } else {
            this.tcas= this.v1tcas;
        }
        fireIntervalAdded( this, 0, tcas.size() );
        
        Object select = tcas.keySet().iterator().next();
    }
    
    public String getTCADataSetId() {
        String result=(String) tcas.get(selectedItem);
        if ( result==null ) {
            return "";
        } else {
            return result;
        }
    }
    
    public Object getElementAt(int index) {
        Iterator i = tcas.keySet().iterator();
        for (int ii = 0; ii<index; ii++) { i.next(); }
        return i.next();
    }
    
    public int getSize() {
        return tcas.size();
    }
    
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object anItem) {
        this.selectedItem= anItem;
    }

}