/* File: Spacecraft.java
 * Copyright (C) 2002-2003 The University of Iowa
 * Created by: Jeremy Faden <jbf@space.physics.uiowa.edu>
 *             Jessica Swanner <jessica@space.physics.uiowa.edu>
 *             Edward E. West <eew@space.physics.uiowa.edu>
 *
 * This file is part of the das2 library.
 *
 * das2 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package edu.uiowa.physics.pw.apps.vgpws;

public class Spacecraft {
    
    public static final Spacecraft voyager1 = new Spacecraft("Voyager 1");
    public static final Spacecraft voyager2 = new Spacecraft("Voyager 2");
    static final Object[] objects=  new Object[] { voyager1, voyager2 };
    
    private String name;
    
    private Spacecraft(String name) {
        this.name= name;
    }
    
    public static Spacecraft getByName( String name ) {        
        Object result=null;
        Object ids;
        for ( int i=0; i<objects.length; i++ ) {
            ids= objects[i];
            String dataSourceString= ids.toString();
            if ( name.equals(dataSourceString) ) result=ids;
        }
        if ( name.equals("vg1") ) {
            result=Spacecraft.voyager1;
        } else if ( name.equals("vg2") ) {
            result=Spacecraft.voyager2;
        }
        return (Spacecraft)result;
    }
    
    public static Spacecraft getByInt( int i ) {
        if ( i==1 ) {
            return voyager1;
        } else if ( i==2 ) {
            return voyager2;
        } else {
            throw new IllegalArgumentException("");
        }
        
    }
    
    public String toString() {
        return name;
    }
    
    public int toInt() {
        if (this==voyager1) {
            return 1;
        } else if (this==voyager2) {
            return 2;
        }
        return -999;
    }
    
}

