/*
 * ScriptApp.java
 *
 * Created on November 1, 2007, 4:27 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import java.io.File;
import javax.beans.binding.BindingContext;

/**
 * Presents an API for scripting an application
 * @author jbf
 */
public class ScriptApp {
    
    Vg1pws app;
    
    public ScriptApp() {
        app= new Vg1pws();
    }
    
    public void setSpectrogram( boolean val ) {
        app.setSpectrogram(val);
    }
    
    public void initialize() {
        app.createApplication( timeRange.min(), timeRange.max(), width, height );
        BindingContext bc= new BindingContext();
        bc.addBinding( this, "${timeRange}", app.getTimeAxis(), "datumRange" );
        bc.bind();
        app.setUpdating(true);
    }
    
    public DasCanvas getCanvas() {
        return app.getCanvas();
    }
    
    public DasAxis getTimeAxis() {
        return app.getTimeAxis();
    }
    
    public DasAxis getFreqAxis() {
        return app.getFreqAxis();
    }
     
    public DasAxis getAmplitudeAxis() {
        return app.getAmplitudeAxis();
    }
    
    public void setVoyagerSpacecraft( int voyNum ) {
        app.getOptionsPanel().setSpacecraft( Spacecraft.getByInt(voyNum) );
    }
    
    public void setLocalFileSystemRoot( String root ) {
        app.getOptionsPanel().setLocalFileSystemRoot( new File( root ) );
    }

    /**
     * Holds value of property timeRange.
     */
    private DatumRange timeRange= DatumRangeUtil.parseTimeRangeValid( "1979-03-01" );

    /**
     * Utility field used by bound properties.
     */
    private java.beans.PropertyChangeSupport propertyChangeSupport =  new java.beans.PropertyChangeSupport(this);

    /**
     * Adds a PropertyChangeListener to the listener list.
     * @param l The listener to add.
     */
    public void addPropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    /**
     * Removes a PropertyChangeListener from the listener list.
     * @param l The listener to remove.
     */
    public void removePropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    /**
     * Getter for property timeRange.
     * @return Value of property timeRange.
     */
    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    /**
     * Setter for property timeRange.
     * @param timeRange New value of property timeRange.
     */
    public void setTimeRange(DatumRange timeRange) {
        DatumRange oldTimeRange = this.timeRange;
        this.timeRange = timeRange;
        propertyChangeSupport.firePropertyChange ("timeRange", oldTimeRange, timeRange);
    }

    /**
     * Holds value of property width.
     */
    private int width=800;

    /**
     * Getter for property width.
     * @return Value of property width.
     */
    public int getWidth() {
        return this.width;
    }

    /**
     * Setter for property width.
     * @param width New value of property width.
     */
    public void setWidth(int width) {
        int oldWidth = this.width;
        this.width = width;
        propertyChangeSupport.firePropertyChange ("width", new Integer (oldWidth), new Integer (width));
    }

    /**
     * Holds value of property height.
     */
    private int height=600;

    /**
     * Getter for property height.
     * @return Value of property height.
     */
    public int getHeight() {
        return this.height;
    }

    /**
     * Setter for property height.
     * @param height New value of property height.
     */
    public void setHeight(int height) {
        int oldHeight = this.height;
        this.height = height;
        propertyChangeSupport.firePropertyChange ("height", new Integer (oldHeight), new Integer (height));
    }
    
}
