/*
 * PeaksAveragerSlicer.java
 *
 * Created on October 1, 2007, 1:24 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.components.VerticalSpectrogramAverager;
import org.das2.dataset.AveragePeakTableRebinner;
import org.das2.dataset.DataSet;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.graph.SymbolLineRenderer;
import java.awt.Color;

/**
 * @author jbf
 */
public class PeaksAveragerSlicer extends VerticalSpectrogramAverager {
    
     SymbolLineRenderer peaksRenderer;
    
    /** Creates a new instance of PeaksAveragerSlicer */
    protected PeaksAveragerSlicer( DasPlot plot, DasAxis xAxis, DasAxis yAxis  )  {
        super( plot, xAxis, yAxis );
        peaksRenderer= new SymbolLineRenderer( );
        peaksRenderer.setColor( Color.GRAY );
        addRenderer(peaksRenderer);
    }
    
    public static PeaksAveragerSlicer createAverager(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(DasAxis.HORIZONTAL);
        DasAxis yAxis = dataSetConsumer.getZAxis().createAttachedAxis(DasAxis.VERTICAL);
        xAxis.setLabel( sourceYAxis.getLabel() );
        yAxis.setLabel( dataSetConsumer.getZAxis().getLabel() );
        return new PeaksAveragerSlicer(plot, xAxis, yAxis);
    }
    
    public static PeaksAveragerSlicer createAverager( DasPlot plot, DasAxis xAxis, DasAxis yAxis, TableDataSetConsumer dataSetConsumer ) {
        return new PeaksAveragerSlicer(plot, xAxis, yAxis);        
    }
    
    public void dataRangeSelected(DataRangeSelectionEvent e) {
        
        super.dataRangeSelected(e);
        
        DataSet ds = e.getDataSet();
        if (ds==null || !(ds instanceof TableDataSet))  return;
        
        TableDataSet xtys = (TableDataSet)ds;
        Datum xValue1 = e.getMinimum();
        Datum xValue2 = e.getMaximum();
        
        if ( xValue2.equals(xValue1) ) {
            return;
        }
        
        this.setTitle( new DatumRange( xValue1, xValue2 ).toString() );
        
        RebinDescriptor ddX = new RebinDescriptor(xValue1, xValue2, 1, false);
        ddX.setOutOfBoundsAction(RebinDescriptor.MINUSONE);
        
        AveragePeakTableRebinner rebinner = new AveragePeakTableRebinner();
        
        TableDataSet rebinned = (TableDataSet)rebinner.rebin( xtys, ddX, null );
        VectorDataSet ds1 = rebinned.getXSlice(0);
        peaksRenderer.setDataSet( ds1.getPlanarView( DataSet.PROPERTY_PLANE_PEAKS ) );
        getRenderer(0).setDataSet( ds1 );
        
    }
    
    
    
}
