/*
 * FileStorageModel.java
 *
 * Created on March 31, 2004, 9:52 AM
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.datum.DatumRange;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import java.io.*;
import java.text.*;
import java.util.*;
import java.util.regex.*;

/**
 *
 * @author  Jeremy
 */
public class FileStorageModel_OBHS {
    
    private Pattern pattern;
    private Pattern absPattern;
    private String regex;
    private String absRegex;
    private List fieldHandlerList;
    private int timeWidth; /* in TimeUtil enum */
    private boolean[] copyToEndTime; /* indexed by TimeUtil enum */
    private boolean useEndTime;
    FileStorageModel_OBHS parent;
    String root;
    
    public static final int StartYear4=100;
    public static final int StartYear2=101;
    public static final int StartMonth=102;
    public static final int StartDay=103;
    public static final int StartDoy=104;
    public static final int StartHour=105;
    public static final int StartMinute=106;
    public static final int StartSecond=107;
    
    public static final int EndYear4=200;
    public static final int EndYear2=201;
    public static final int EndMonth=202;
    public static final int EndDay=203;
    public static final int EndDoy=204;
    public static final int EndHour=205;
    public static final int EndMinute=206;
    public static final int EndSecond=207;
    
    public static final int Ignore=300;    
    
    /* need to map back to TimeUtil's enums, note that we have an extra for the 2 digit year */
    private int toTimeUtilEnum( int i ) {
        if ( i<100 || i > 300 ) {
            throw new IllegalArgumentException( "enumeration is not of the correct type");
        }
        i= i % 100;
        if ( i==0 ) i=1;
        return i;
    }
    
    private interface FieldHandler {
        public void handle( String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 );
    }
    
    public abstract class IntegerFieldHandler implements FieldHandler {
        public void handle( String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) {
            handleInt( Integer.parseInt(s), ts1, ts2 );
        }
        abstract void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 );
        abstract String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 );
    }
    
    NumberFormat nf4= new DecimalFormat("0000");
    NumberFormat nf3= new DecimalFormat("000");
    NumberFormat nf2= new DecimalFormat("00");
    
    public final FieldHandler StartYear4Handler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.year= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf4.format(ts1.year); }
    };
    
    public final FieldHandler StartYear2Handler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.year= i<58 ? i+2000 : i+1900;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts1.year % 100 ); }
    };
    
    public final FieldHandler StartMonthHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.month= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts1.month ); }
    };
    public final FieldHandler StartDayHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.day= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts1.day ); }
    };
    public final FieldHandler StartDoyHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.doy= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf3.format( ts1.doy ); }
    };
    public final FieldHandler StartHourHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.hour= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts1.hour ); }
    };
    public final FieldHandler StartMinuteHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.minute= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts1.minute ); }
    };
    public final FieldHandler StartSecondHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts1.seconds= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts1.seconds ); }
    };
    
    public final FieldHandler EndYear4Handler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.year= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf4.format( ts2.year ); }
    };
    public final FieldHandler EndYear2Handler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.year= i<58 ? i+2000 : i+1900;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts2.year ); }
    };
    
    public final FieldHandler EndMonthHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.month= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts2.month ); }        
    };
    public final FieldHandler EndDayHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.day= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts2.day ); }        
    };
    public final FieldHandler EndDoyHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.doy= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf3.format( ts2.doy ); }
    };
    public final FieldHandler EndHourHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.hour= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts2.hour ); }
    };
    public final FieldHandler EndMinuteHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.minute= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts2.minute ); }
    };
    public final FieldHandler EndSecondHandler= new IntegerFieldHandler() {
        public void handleInt( int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { ts2.seconds= i;  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return nf2.format( ts2.seconds ); }
    };
    
    public final FieldHandler IgnoreHandler= new FieldHandler() {
        public void handle( String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) {  }
        public String format( TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2 ) { return "*"; }
    };
    
    
    private void checkArgs( String regex, int[] digitList ) {
        int startLsd=0, endLsd=0;
        int[] startDigits= new int[7];
        int[] endDigits= new int[7];
        copyToEndTime= new boolean[8]; /* indexed by TimeUtil enum */
        int startBase=100;
        int endBase=200;
        int ignoreBase=300;
        for ( int i=0; i<digitList.length; i++ ) {
            if ( digitList[i]>=startBase && digitList[i]<endBase ) {
                startDigits[digitList[i]-startBase]= 1;
                if ( digitList[i]>startLsd ) startLsd= digitList[i];
            } else if ( digitList[i]>=endBase && digitList[i]<ignoreBase ) {
                endDigits[digitList[i]-endBase]= 1;
                if ( digitList[i]>startLsd ) endLsd= digitList[i];
            }
        }
        if ( startDigits[StartYear2-startBase]==1 ) startDigits[StartYear4-startBase]=1;
        if ( startDigits[StartDoy-startBase]==1 ) {
            startDigits[StartMonth-startBase]=1;
            startDigits[StartDay-startBase]=1;
        }
        if ( endDigits[EndYear2-endBase]==1 ) endDigits[EndYear4-endBase]=1;
        if ( endDigits[EndDoy-endBase]==1 ) {
            endDigits[EndMonth-endBase]=1;
            endDigits[EndDay-endBase]=1;
        }
        for ( int i=0; i<startDigits.length; i++ ) {
            if ( i>0 && startDigits[i]==1 && startDigits[i-1]!=1 ) {
                throw new IllegalArgumentException( "more significant digits missing in startTime");
            }
            if ( i>0 && startDigits[i]==0 && startDigits[i-1]==1 ) {
                timeWidth= toTimeUtilEnum( startLsd );
            }
        }
        
        boolean canUse= true;
        for ( int i=startLsd-startBase; i>=0; i-- ) {
            if ( endDigits[i]==0 ) canUse=false;
            if ( !canUse ) endDigits[i]= 0;
        }
        
        for ( int i=0; i<endDigits.length; i++ ) {
            copyToEndTime[toTimeUtilEnum(i+endBase)]= endDigits[i]==0;
        }
        
        if ( countGroups( regex ) != digitList.length ) {
            throw new IllegalArgumentException( "number of groups in regular expression ("+countGroups(regex)+") doesn't equal the length of digitList ("+digitList.length+")." );
        }
    }
    
    
    private void setHandlers( int [] digitList ) {
        FieldHandler[] startHandlers= new FieldHandler[] {
            StartYear4Handler, StartYear2Handler, StartMonthHandler,  StartDayHandler,
            StartDoyHandler ,
            StartHourHandler,     StartMinuteHandler,  StartSecondHandler
        };
        
        FieldHandler[] endHandlers= new FieldHandler[] {
            EndYear4Handler, EndYear2Handler, EndMonthHandler,  EndDayHandler,
            EndDoyHandler ,
            EndHourHandler,     EndMinuteHandler,  EndSecondHandler
        };
        
        fieldHandlerList= new ArrayList();
        for ( int i=0; i<digitList.length; i++ ) {
            if ( digitList[i]>=100 && digitList[i]<200 ) {
                fieldHandlerList.add(i,startHandlers[digitList[i]-100]);
            } else if (digitList[i]>=200 && digitList[i]<300 ) {
                fieldHandlerList.add(i,endHandlers[digitList[i]-200]);
            } else if ( digitList[i]==300 ) {
                fieldHandlerList.add(i,IgnoreHandler);
            } else {
                throw new IllegalArgumentException("unknown field handler: "+digitList[i]);
            }
        }
    }
    
    
    /*
     * extract time range for file or directory from its name.
     * The least significant time digit is considered to be the implicitTimeWidth,
     * and if the width is not stated explicitly, it will be used.  When
     * a set timeDigits are encountered twice, then the second occurrence
     * is considered be the end time.
     *
     * .../FULL1/T8709_12/T871118.DAT
     *'.../FULL1/T'YYMM_MM/TYYMMDD'.DAT'
     */
    private DatumRange getDatumRangeForFile( String filename ) {
        
        TimeUtil.TimeStruct ts1= new TimeUtil.TimeStruct();
        ts1.year=0;
        ts1.day=1;
        ts1.month=1;
        ts1.doy=1;
        ts1.hour=0;
        ts1.minute=0;
        ts1.seconds=0;
        
        TimeUtil.TimeStruct ts2= new TimeUtil.TimeStruct();        
        if ( File.separatorChar=='\\' ) filename= filename.replaceAll("\\\\", "/");
      
        Matcher m= absPattern.matcher(filename);
        if ( m.matches() ) {
            for ( int i=0; i<fieldHandlerList.size(); i++ ) {
                String s= m.group(i+1);
                ((FieldHandler)fieldHandlerList.get(i)).handle(s,ts1,ts2);
            }
            TimeUtil.normalize(ts1);
            if ( copyToEndTime[1] ) ts2.year= ts1.year;
            if ( copyToEndTime[2] ) ts2.month= ts1.month;
            if ( copyToEndTime[3] ) ts2.day= ts1.day;
            if ( copyToEndTime[4] ) ts2.doy= ts1.doy;
            if ( copyToEndTime[5] ) ts2.hour= ts1.hour;
            if ( copyToEndTime[6] ) ts2.minute= ts1.minute;
            if ( copyToEndTime[7] ) ts2.seconds= ts1.seconds;
            
            Datum s1= TimeUtil.toDatum(ts1);
            Datum s2= TimeUtil.next(timeWidth, TimeUtil.toDatum(ts2));
            
            DatumRange dr= new DatumRange(s1,s2);            
            return dr;
        } else {
            throw new IllegalArgumentException( "file name ("+filename+") doesn't match model specification ("+absRegex+")");
        }
    }
    
    public String getFilenameFor( Datum start, Datum end ) {
        TimeUtil.TimeStruct ts1= TimeUtil.toTimeStruct(start);
        TimeUtil.TimeStruct ts2= TimeUtil.toTimeStruct(end);
        
        // the following code does not work, but serves as a reminder of what this was going to do.
        StringBuffer result= new StringBuffer(30);
        result.append(root);
        for ( int i=0; i<fieldHandlerList.size(); i++ ) {
            //result.append( fieldHandlerList.
        }
        return null;
    }
    
    public File[] getFilesFor( Datum start, Datum end ) {
        File[] files;
        if ( parent!=null ) {
            files= parent.getFilesFor(start,end);
        } else {
            files= new File[] { new File( root ) };
        }
        
        final DatumRange targetRange= new DatumRange( start, end );
        List list= new ArrayList();
        for ( int i=0; i<files.length; i++ ) {
            File[] files1= files[i].listFiles( new FileFilter() {
                public boolean accept( File file ) {
                    String s= file.toString();
                    if ( File.separatorChar=='\\' ) s= s.replaceAll("\\\\", "/");                    
                    if ( absPattern.matcher(s).matches() ) {                  
                        return  getDatumRangeForFile(s).intersects(targetRange);
                    } else {
                        return false;
                    }
                }
            } );
            list.addAll( Arrays.asList(files1) );
        }
        return (File[])list.toArray(new File[list.size()]);
    }
    
    private static int countGroups( String regex ) {
        int result=0;
        Pattern p= Pattern.compile( regex );
        Matcher m= p.matcher("");
        return m.groupCount();
    }
    
    public static String getParentRegex( String regex ) {
        String[] s= regex.split( "/" );
        String dirRegex;
        if ( s.length>1 ) {
            dirRegex= s[0];
            for ( int i=1; i<s.length-2; i++ ) {
                dirRegex+= "/"+s[i];
            }
        } else {
            dirRegex= null;
        }
        String fileRegex= s[s.length-1];
        return dirRegex;
    }
    
    public static FileStorageModel_OBHS create( String root, String regex, int[] digitList )  {
        String parentRegex= getParentRegex( regex );
        FileStorageModel_OBHS parentModel;
        if ( parentRegex!=null ) {
            int parentGroupsCount= countGroups(parentRegex);
            int[] parentDigitList= new int[parentGroupsCount];
            for ( int i=0; i<parentGroupsCount; i++ ) {
                parentDigitList[i]= digitList[i];
            }
            parentModel= create( root, parentRegex, parentDigitList );
        } else {
            parentModel= null;
        }
        return new FileStorageModel_OBHS( parentModel, root, regex, digitList );
    }
    
    /** Creates a new instance of FileStorageModel */
    private FileStorageModel_OBHS( FileStorageModel_OBHS parent, String root, String regex, int[] digitList ) {
        checkArgs( regex, digitList );
        setHandlers(digitList);
        
        File rootFile= new File( root );
        if ( !rootFile.exists() ) {
            throw new IllegalArgumentException( "root ("+root+") does not exist" );
        }
        this.root= root;
        this.parent= parent;
        this.regex= regex;
        this.absRegex= "\\Q"+root+"\\E"+regex;
        this.pattern= Pattern.compile(regex);
        this.absPattern= Pattern.compile( absRegex );        
        
    }
    
    public static void main( String[] args ) throws Exception {
        FileStorageModel_OBHS model;
                
        model= FileStorageModel_OBHS.create( "J:/voyager/event1/", "VG1_EVENTS_(\\d{4}).TAB", new int[] { StartYear4 } );
        
        System.out.println( model.getDatumRangeForFile( "J:/voyager/event1/VG1_EVENTS_2003.TAB" ) );
      
        File[] files= model.getFilesFor( TimeUtil.createValid( "2000-360" ), TimeUtil.createValid( "2002-015" ) );
        for ( int i=0; i<files.length; i++ ) {
            System.out.println( files[i] );
        }
        
        System.out.println("");
        model= FileStorageModel_OBHS.create( "J:/voyager/DATA/FULL1/", "T(\\d{2})(\\d{2})_(\\d{2})/T(\\d{2})(\\d{2})(\\d{2})\\.DAT", new int[] { StartYear2, StartMonth, EndMonth, StartYear2, StartMonth, StartDay } );
        
        files= model.getFilesFor( TimeUtil.createValid( "2000-360" ), TimeUtil.createValid( "2002-015" ) );
        for ( int i=0; i<files.length; i++ ) {
            System.out.println( files[i] );
        }
        
        System.out.println( model.getDatumRangeForFile( "J:/voyager/DATA/FULL1/T0109_12/T011228.DAT" ) );
        
        System.out.println( model.getFilenameFor( TimeUtil.createValid("2001-12-28"), TimeUtil.createValid("2001-12-29") ) );
        
    }
}
