/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.WebFileObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;

public abstract class WebFileSystem
extends FileSystem {
    final File localRoot;

    protected WebFileSystem(URL uRL, File file) {
        super(uRL);
        this.localRoot = file;
    }

    protected static File localRoot(URL uRL) {
        File file = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        file = new File(file, ".das2/fileSystemCache/WebFileSystem/");
        file = new File(file, uRL.getProtocol());
        file = new File(file, uRL.getHost());
        file = new File(file, uRL.getFile());
        file.mkdirs();
        return file;
    }

    abstract void downloadFile(String var1, File var2, DasProgressMonitor var3) throws IOException;

    protected File getLocalRoot() {
        return this.localRoot;
    }

    public abstract boolean isDirectory(String var1);

    public abstract String[] listDirectory(String var1);

    public String[] listDirectory(String string, String string2) {
        String[] stringArray = this.listDirectory(string);
        Pattern pattern = Pattern.compile(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!pattern.matcher(stringArray[i]).matches()) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public URL getURL(String string) {
        try {
            string = FileSystem.toCanonicalFilename(string);
            return new URL(this.root + string.substring(1));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String string = file.toString().substring(this.localRoot.toString().length());
        string = string.replaceAll("\\\\", "/");
        return string;
    }

    public String getLocalName(URL uRL) {
        if (!uRL.toString().startsWith(this.root.toString())) {
            throw new IllegalArgumentException("url \"" + uRL + "\"is not of this web file system");
        }
        String string = FileSystem.toCanonicalFilename(uRL.toString().substring(this.root.toString().length()));
        return string;
    }

    public FileObject getFileObject(String string) {
        WebFileObject webFileObject = new WebFileObject(this, string, new Date(System.currentTimeMillis()));
        return webFileObject;
    }

    protected void copyStream(InputStream inputStream, OutputStream outputStream, DasProgressMonitor dasProgressMonitor) throws IOException {
        byte[] byArray = new byte[2048];
        int n = inputStream.read(byArray, 0, 2048);
        long l = n;
        while (n > -1) {
            if (dasProgressMonitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            dasProgressMonitor.setTaskProgress(l);
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray, 0, 2048);
            l += (long)n;
            logger.finest("transferring data");
        }
    }

    public String toString() {
        return "wfs " + this.root;
    }
}

