/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.WebFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.nio.channels.Channel;
import java.util.Date;

public class WebFileObject
extends FileObject {
    WebFileSystem wfs;
    String pathname;
    File localFile;
    Date modifiedDate;
    boolean isRoot;
    boolean isFolder;

    public boolean canRead() {
        return true;
    }

    public FileObject[] getChildren() {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        String[] stringArray = this.wfs.listDirectory(this.pathname);
        FileObject[] fileObjectArray = new FileObject[stringArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            fileObjectArray[i] = new WebFileObject(this.wfs, stringArray[i], new Date(System.currentTimeMillis()));
        }
        return fileObjectArray;
    }

    public InputStream getInputStream(DasProgressMonitor dasProgressMonitor) throws FileNotFoundException {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (!this.localFile.exists()) {
            try {
                this.wfs.downloadFile(this.pathname, this.localFile, dasProgressMonitor);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                this.wfs.handleException(iOException);
            }
        }
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        return new WebFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        return this.localFile.length();
    }

    public boolean isData() {
        return !this.isFolder;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Date lastModified() {
        return this.modifiedDate;
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    public boolean exists() {
        if (this.localFile.exists()) {
            return true;
        }
        try {
            DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).info("This implementation of WebFileObject.exists() is not optimal");
            this.wfs.downloadFile(this.pathname, this.localFile, DasProgressMonitor.NULL);
            return this.localFile.exists();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected WebFileObject(WebFileSystem webFileSystem, String string, Date date) {
        this.localFile = new File(webFileSystem.getLocalRoot(), string);
        this.localFile.deleteOnExit();
        this.modifiedDate = date;
        this.wfs = webFileSystem;
        this.pathname = string;
        if (!this.localFile.canRead()) {
            if (webFileSystem.isDirectory(string)) {
                this.localFile.mkdirs();
                this.isFolder = true;
                if ("".equals(string)) {
                    this.isRoot = true;
                }
            } else {
                this.isFolder = false;
            }
        } else {
            this.isFolder = this.localFile.isDirectory();
        }
    }

    public String toString() {
        return "[" + this.wfs + "]" + this.getNameExt();
    }

    public String getNameExt() {
        return this.pathname;
    }

    public Channel getChannel(DasProgressMonitor dasProgressMonitor) throws FileNotFoundException {
        return ((FileInputStream)this.getInputStream(dasProgressMonitor)).getChannel();
    }

    public File getFile(DasProgressMonitor dasProgressMonitor) throws FileNotFoundException {
        try {
            Date date;
            Serializable serializable;
            boolean bl = false;
            if (this.wfs instanceof HttpFileSystem) {
                serializable = this.wfs.getURL(this.getNameExt());
                HttpURLConnection httpURLConnection = (HttpURLConnection)serializable.openConnection();
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.connect();
                date = new Date(httpURLConnection.getLastModified());
            } else {
                date = new Date(this.localFile.lastModified());
            }
            if (this.localFile.exists()) {
                serializable = new Date(this.localFile.lastModified());
                if (date.after((Date)serializable)) {
                    FileSystem.logger.info("remote file is newer than local copy of " + this.getNameExt() + ", download.");
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.wfs.downloadFile(this.pathname, this.localFile, dasProgressMonitor);
            }
            return this.localFile;
        }
        catch (IOException iOException) {
            this.wfs.handleException(iOException);
            throw (FileNotFoundException)new FileNotFoundException(iOException.getMessage()).initCause(iOException);
        }
    }
}

