/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileObject;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Pattern;

public class LocalFileSystem
extends FileSystem {
    File localRoot;

    protected LocalFileSystem(URL uRL) throws FileSystem.FileSystemOfflineException {
        super(uRL);
        if (!"file".equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("protocol not file: " + uRL);
        }
        this.localRoot = new File(uRL.getFile());
        if (!this.localRoot.exists()) {
            File[] fileArray = File.listRoots();
            if (Arrays.asList(fileArray).contains(this.localRoot)) {
                throw new FileSystem.FileSystemOfflineException();
            }
            throw new IllegalArgumentException("root does not exist: " + uRL);
        }
    }

    public boolean isDirectory(String string) {
        return new File(this.localRoot, string).isDirectory();
    }

    String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String string = file.toString().substring(this.localRoot.toString().length());
        string = string.replaceAll("\\\\", "/");
        return string;
    }

    public String[] listDirectory(String string) {
        File file = new File(this.localRoot, string);
        File[] fileArray = file.listFiles();
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName() + (fileArray[i].isDirectory() ? "/" : "");
        }
        return stringArray;
    }

    public String[] listDirectory(String string, String string2) {
        File file = new File(this.localRoot, string);
        final Pattern pattern = Pattern.compile(string2);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return pattern.matcher(string).matches();
            }
        });
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName() + (fileArray[i].isDirectory() ? "/" : "");
        }
        return stringArray;
    }

    public String toString() {
        return "lfs " + this.localRoot;
    }

    public FileObject getFileObject(String string) {
        return new LocalFileObject(this, this.localRoot, string);
    }
}

