/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.Date;

public class LocalFileObject
extends FileObject {
    File localFile;
    File localRoot;
    LocalFileSystem lfs;

    protected LocalFileObject(LocalFileSystem localFileSystem, File file, String string) {
        this.lfs = localFileSystem;
        this.localFile = new File(file, string);
        this.localRoot = file;
    }

    public boolean canRead() {
        return this.localFile.canRead();
    }

    public FileObject[] getChildren() {
        File[] fileArray = this.localFile.listFiles();
        FileObject[] fileObjectArray = new LocalFileObject[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileObjectArray[i] = new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(fileArray[i]));
        }
        return fileObjectArray;
    }

    public InputStream getInputStream(DasProgressMonitor dasProgressMonitor) throws FileNotFoundException {
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        if (!this.localFile.equals(this.localRoot)) {
            return new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(this.localFile.getParentFile()));
        }
        return null;
    }

    public long getSize() {
        return this.localFile.length();
    }

    public boolean isData() {
        return this.localFile.isFile();
    }

    public boolean isFolder() {
        return this.localFile.isDirectory();
    }

    public boolean isReadOnly() {
        return !this.localFile.canWrite();
    }

    public boolean isRoot() {
        return this.localFile.getParentFile() == null;
    }

    public Date lastModified() {
        return new Date(this.localFile.lastModified());
    }

    public boolean exists() {
        return this.localFile.exists();
    }

    public String getNameExt() {
        return FileSystem.toCanonicalFilename(this.localFile.toString().substring(this.localRoot.toString().length()));
    }

    public String toString() {
        return "[" + this.lfs + "]" + this.getNameExt();
    }

    public Channel getChannel(DasProgressMonitor dasProgressMonitor) throws FileNotFoundException {
        return ((FileInputStream)this.getInputStream(dasProgressMonitor)).getChannel();
    }

    public File getFile() throws FileNotFoundException {
        return this.getFile(DasProgressMonitor.NULL);
    }

    public File getFile(DasProgressMonitor dasProgressMonitor) throws FileNotFoundException {
        return this.localFile;
    }
}

