/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.HtmlUtil;
import edu.uiowa.physics.pw.das.util.fileSystem.WebFileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.xerces.utils.Base64;

public class HttpFileSystem
extends WebFileSystem {
    private HashMap listings;
    private static HashMap instances = new HashMap();
    private HashMap downloads = new HashMap();
    private String userPass;

    private HttpFileSystem(URL uRL, File file) {
        super(uRL, file);
        this.listings = new HashMap();
    }

    public static synchronized HttpFileSystem createHttpFileSystem(URL uRL) throws FileSystem.FileSystemOfflineException {
        if (instances.containsKey(uRL)) {
            logger.finer("reusing " + uRL);
            return (HttpFileSystem)instances.get(uRL);
        }
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            if (uRL.getUserInfo() != null) {
                object = new String(Base64.encode(uRL.getUserInfo().getBytes()));
                httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
            }
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 200) {
                throw new FileSystem.FileSystemOfflineException("" + httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
            }
            object = HttpFileSystem.localRoot(uRL);
            logger.finer("initializing httpfs " + uRL + " at " + object);
            HttpFileSystem httpFileSystem = new HttpFileSystem(uRL, (File)object);
            instances.put(uRL, httpFileSystem);
            return httpFileSystem;
        }
        catch (FileSystem.FileSystemOfflineException fileSystemOfflineException) {
            throw fileSystemOfflineException;
        }
        catch (IOException iOException) {
            throw new FileSystem.FileSystemOfflineException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFile(String string, File file, DasProgressMonitor dasProgressMonitor) throws IOException {
        block30: {
            Object object;
            Serializable serializable = this.downloads;
            synchronized (serializable) {
                object = (DasProgressMonitor)this.downloads.get(string);
                if (object != null) {
                    dasProgressMonitor.setLabel("Waiting for file to download");
                    while (object != null) {
                        dasProgressMonitor.setTaskSize(object.getTaskSize());
                        if (dasProgressMonitor.isCancelled()) {
                            object.cancel();
                        }
                        dasProgressMonitor.setTaskProgress(object.getTaskProgress());
                        try {
                            this.downloads.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                        object = (DasProgressMonitor)this.downloads.get(string);
                        logger.finest("waiting for download");
                    }
                    if (file.exists()) {
                        return;
                    }
                    throw new FileNotFoundException("expected to find " + file);
                }
                this.downloads.put(string, dasProgressMonitor);
                boolean bl = false;
            }
            try {
                Object object2;
                logger.info("downloadFile " + string);
                serializable = new URL(this.root.toString() + string);
                object = ((URL)serializable).openConnection();
                if (this.root.getUserInfo() != null) {
                    object2 = new String(Base64.encode(this.root.getUserInfo().getBytes()));
                    ((URLConnection)object).setRequestProperty("Authorization", "Basic " + (String)object2);
                }
                if (((HttpURLConnection)(object2 = (HttpURLConnection)object)).getResponseCode() != 200) {
                    System.err.println("" + ((HttpURLConnection)object2).getResponseCode() + " URL: " + serializable);
                    throw new IOException(((HttpURLConnection)object2).getResponseMessage());
                }
                dasProgressMonitor.setTaskSize(((URLConnection)object).getContentLength());
                if (!file.getParentFile().exists()) {
                    logger.fine("make dirs " + file.getParentFile());
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    logger.fine("clobber file " + file);
                    if (!file.delete()) {
                        logger.info("Unable to clobber file " + file + ", better use it for now.");
                        return;
                    }
                }
                if (file.createNewFile()) {
                    InputStream inputStream = ((URLConnection)object).getInputStream();
                    inputStream = DasApplication.getDefaultApplication().getInputStreamMeter().meterInputStream(inputStream);
                    logger.fine("transferring bytes of " + string);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    dasProgressMonitor.setLabel("downloading file");
                    try {
                        this.copyStream(inputStream, fileOutputStream, dasProgressMonitor);
                        dasProgressMonitor.finished();
                        fileOutputStream.close();
                        inputStream.close();
                        break block30;
                    }
                    catch (IOException iOException) {
                        fileOutputStream.close();
                        inputStream.close();
                        file.delete();
                        throw iOException;
                    }
                }
                throw new IOException("couldn't create local file: " + file);
            }
            finally {
                HashMap hashMap = this.downloads;
                synchronized (hashMap) {
                    this.downloads.remove(string);
                    this.downloads.notifyAll();
                }
            }
        }
    }

    public boolean isDirectory(String string) {
        File file = new File(this.localRoot, string);
        if (file.exists()) {
            return file.isDirectory();
        }
        if (string.endsWith("/")) {
            return true;
        }
        File file2 = file.getParentFile();
        String string2 = this.getLocalName(file2);
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        String[] stringArray = this.listDirectory(string2);
        String string3 = string.startsWith("/") ? string.substring(1) + "/" : string + "/";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listDirectory(String string) {
        if (!this.isDirectory(string = HttpFileSystem.toCanonicalFilename(string))) {
            throw new IllegalArgumentException("is not a directory: " + string);
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        HashMap hashMap = this.listings;
        synchronized (hashMap) {
            if (this.listings.containsKey(string)) {
                return (String[])this.listings.get(string);
            }
            try {
                URL[] uRLArray = HtmlUtil.getDirectoryListing(this.getURL(string));
                String[] stringArray = new String[uRLArray.length];
                int n = string.length();
                for (int i = 0; i < uRLArray.length; ++i) {
                    URL uRL = uRLArray[i];
                    stringArray[i] = this.getLocalName(uRL).substring(n);
                }
                this.listings.put(string, stringArray);
                return stringArray;
            }
            catch (IOException iOException) {
                this.handleException(iOException);
                return new String[0];
            }
        }
    }

    public String[] listDirectory(String string, String string2) {
        if (!this.isDirectory(string = HttpFileSystem.toCanonicalFilename(string))) {
            throw new IllegalArgumentException("is not a directory: " + string);
        }
        String[] stringArray = this.listDirectory(string);
        Pattern pattern = Pattern.compile(string2 + "/?");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!pattern.matcher(stringArray[i]).matches()) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

