/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.fileSystem.FTPFileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileSystem;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public abstract class FileSystem {
    URL root;
    protected static Logger logger = DasLogger.getLogger(DasLogger.FILESYSTEM_LOG);

    public static FileSystem create(URL uRL) throws FileSystemOfflineException {
        logger.fine("create filesystem " + uRL);
        if ("file".equals(uRL.getProtocol())) {
            return new LocalFileSystem(uRL);
        }
        if ("http".equals(uRL.getProtocol())) {
            return HttpFileSystem.createHttpFileSystem(uRL);
        }
        if ("ftp".equals(uRL.getProtocol())) {
            return new FTPFileSystem(uRL);
        }
        throw new IllegalArgumentException("unsupported protocol: " + uRL);
    }

    protected FileSystem(URL uRL) {
        if (!uRL.toString().endsWith("/")) {
            String string = uRL.toString();
            try {
                uRL = new URL(string + "/");
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        this.root = uRL;
    }

    public URL getRootURL() {
        return this.root;
    }

    private static String getRegexFromGlob(String string) {
        String string2 = string.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        return string2;
    }

    protected void handleException(Exception exception) {
        DasExceptionHandler.handle(exception);
    }

    protected static String toCanonicalFilename(String string) {
        if ((string = string.replaceAll("\\\\", "/")).length() == 0 || string.charAt(0) != '/') {
            string = "/" + string;
        }
        return string;
    }

    protected static String toCanonicalFolderName(String string) {
        if (!(string = FileSystem.toCanonicalFilename(string)).endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    public abstract FileObject getFileObject(String var1);

    public abstract boolean isDirectory(String var1);

    public abstract String[] listDirectory(String var1);

    public abstract String[] listDirectory(String var1, String var2);

    public static class FileSystemOfflineException
    extends IOException {
        FileSystemOfflineException() {
        }

        FileSystemOfflineException(String string) {
            super(string);
        }

        FileSystemOfflineException(IOException iOException) {
            super(iOException.getMessage());
            this.initCause(iOException);
        }
    }
}

