/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.SubTaskMonitor;
import edu.uiowa.physics.pw.das.util.TimeParser;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileStorageModelNew {
    private Pattern pattern;
    private Pattern absPattern;
    private String regex;
    FileStorageModelNew parent;
    FileSystem root;
    TimeParser timeParser;
    String template;
    static Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    HashMap fileNameMap = null;

    private int toTimeUtilEnum(int n) {
        if (n < 100 || n > 300) {
            throw new IllegalArgumentException("enumeration is not of the correct type");
        }
        if ((n %= 100) == 0) {
            n = 1;
        }
        return n;
    }

    private DatumRange getDatumRangeFor(String string) {
        try {
            if (this.pattern.matcher(string).matches()) {
                this.timeParser.parse(string);
                return this.timeParser.getTimeRange();
            }
            throw new IllegalArgumentException("file name (" + string + ") doesn't match model specification (" + this.regex + ")");
        }
        catch (ParseException parseException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("file name (" + string + ") doesn't match model specification (" + this.regex + "), parse error in field", parseException);
            throw illegalArgumentException;
        }
        catch (NumberFormatException numberFormatException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("file name (" + string + ") doesn't match model specification (" + this.regex + "), parse error in field", numberFormatException);
            throw illegalArgumentException;
        }
    }

    public String getFilenameFor(Datum datum, Datum datum2) {
        return this.timeParser.format(datum, datum2);
    }

    public String[] getNamesFor(DatumRange datumRange) {
        return this.getNamesFor(datumRange, DasProgressMonitor.NULL);
    }

    public String[] getNamesFor(DatumRange datumRange, DasProgressMonitor dasProgressMonitor) {
        String string;
        Object object;
        FileSystem[] fileSystemArray;
        String[] stringArray;
        if (this.parent != null) {
            stringArray = this.parent.getNamesFor(datumRange);
            fileSystemArray = new FileSystem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    URL uRL = new URL(this.root.getRootURL(), stringArray[i]);
                    fileSystemArray[i] = FileSystem.create(uRL);
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            object = FileStorageModelNew.getParentRegex(this.regex);
            string = this.regex.substring(((String)object).length() + 1);
        } else {
            fileSystemArray = new FileSystem[]{this.root};
            stringArray = new String[]{""};
            string = this.regex;
        }
        object = new ArrayList();
        dasProgressMonitor.setTaskSize(fileSystemArray.length * 10);
        dasProgressMonitor.started();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            dasProgressMonitor.setTaskProgress(i * 10);
            String[] stringArray2 = fileSystemArray[i].listDirectory("/", string);
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2;
                String string3 = string2 = stringArray[i].equals("") ? stringArray2[j] : stringArray[i] + "/" + stringArray2[j];
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                try {
                    if (this.getDatumRangeFor(string2).intersects(datumRange)) {
                        object.add(string2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.fine("ignoring file " + string2);
                }
                dasProgressMonitor.setTaskProgress(i * 10 + j * 10 / stringArray2.length);
            }
        }
        dasProgressMonitor.finished();
        return object.toArray(new String[object.size()]);
    }

    public static CacheTag getCacheTagFor(FileStorageModelNew fileStorageModelNew, DatumRange datumRange, String[] stringArray) {
        Datum datum = datumRange.min();
        Datum datum2 = datumRange.max();
        for (int i = 0; i < stringArray.length; ++i) {
            DatumRange datumRange2 = fileStorageModelNew.getRangeFor(stringArray[i]);
            datum = datum.gt(datumRange.min()) ? datumRange2.min() : datum;
            datum2 = datum2.lt(datumRange.max()) ? datumRange2.max() : datum2;
        }
        return new CacheTag(datum, datum2, null);
    }

    public static CacheTag getCacheTagFor(FileStorageModelNew fileStorageModelNew, DatumRange datumRange, File[] fileArray) {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileStorageModelNew.getNameFor(fileArray[i]);
        }
        return FileStorageModelNew.getCacheTagFor(fileStorageModelNew, datumRange, stringArray);
    }

    public File[] getFilesFor(DatumRange datumRange) {
        return this.getFilesFor(datumRange, DasProgressMonitor.NULL);
    }

    public DatumRange getRangeFor(String string) {
        return this.getDatumRangeFor(string);
    }

    public boolean containsFile(File file) {
        if (!this.fileNameMap.containsKey(file)) {
            return false;
        }
        String string = (String)this.fileNameMap.get(file);
        String string2 = this.getNameFor(file);
        Matcher matcher = this.pattern.matcher(string2);
        return matcher.matches();
    }

    public String getNameFor(File file) {
        String string = (String)this.fileNameMap.get(file);
        if (string == null) {
            throw new IllegalArgumentException("File didn't come from this FileStorageModel");
        }
        return string;
    }

    public File[] getFilesFor(DatumRange datumRange, DasProgressMonitor dasProgressMonitor) {
        String[] stringArray = this.getNamesFor(datumRange);
        File[] fileArray = new File[stringArray.length];
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
        if (stringArray.length > 0) {
            dasProgressMonitor.setTaskSize(stringArray.length * 10);
        }
        dasProgressMonitor.started();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                FileObject fileObject = this.root.getFileObject(stringArray[i]);
                fileArray[i] = fileObject.getFile(SubTaskMonitor.create(dasProgressMonitor, i * 10, (i + 1) * 10));
                this.fileNameMap.put(fileArray[i], stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        dasProgressMonitor.finished();
        return fileArray;
    }

    private static int countGroups(String string) {
        boolean bl = false;
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher("");
        return matcher.groupCount();
    }

    public static String getParentRegex(String string) {
        String string2;
        String[] stringArray = string.split("/");
        if (stringArray.length > 1) {
            string2 = stringArray[0];
            for (int i = 1; i < stringArray.length - 2; ++i) {
                string2 = string2 + "/" + stringArray[i];
            }
        } else {
            string2 = null;
        }
        String string3 = stringArray[stringArray.length - 1];
        return string2;
    }

    public static FileStorageModelNew create(FileSystem fileSystem, String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("%", n);
        if (n2 != -1) {
            String string2 = string.substring(0, n);
            FileStorageModelNew fileStorageModelNew = FileStorageModelNew.create(fileSystem, string2);
            return new FileStorageModelNew(fileStorageModelNew, fileSystem, string);
        }
        return new FileStorageModelNew(null, fileSystem, string);
    }

    public static FileStorageModelNew create(FileSystem fileSystem, String string, String string2, TimeParser.FieldHandler fieldHandler) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("%", n);
        if (n2 != -1) {
            String string3 = string.substring(0, n);
            FileStorageModelNew fileStorageModelNew = FileStorageModelNew.create(fileSystem, string3);
            return new FileStorageModelNew(fileStorageModelNew, fileSystem, string, string2, fieldHandler);
        }
        return new FileStorageModelNew(null, fileSystem, string, string2, fieldHandler);
    }

    public FileStorageModelNew(FileStorageModelNew fileStorageModelNew, FileSystem fileSystem, String string, String string2, TimeParser.FieldHandler fieldHandler) {
        this.root = fileSystem;
        this.parent = fileStorageModelNew;
        this.template = string;
        this.timeParser = TimeParser.create(string, string2, fieldHandler);
        this.regex = this.timeParser.getRegex();
        this.pattern = Pattern.compile(this.regex);
    }

    public FileStorageModelNew(FileStorageModelNew fileStorageModelNew, FileSystem fileSystem, String string) {
        this.root = fileSystem;
        this.parent = fileStorageModelNew;
        this.template = string;
        this.timeParser = TimeParser.create(string);
        this.regex = this.timeParser.getRegex();
        this.pattern = Pattern.compile(this.regex);
    }

    public String toString() {
        return String.valueOf(this.root) + this.regex;
    }
}

