/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.WebFileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class FTPFileSystem
extends WebFileSystem {
    FTPFileSystem(URL uRL) {
        super(uRL, FTPFileSystem.localRoot(uRL));
    }

    public boolean isDirectory(String string) {
        return string.endsWith("/");
    }

    private String[] parseLsl(String string, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = bufferedReader.readLine();
        boolean bl = string2 == null;
        String string3 = "d-";
        long l = 0L;
        long l2 = 0L;
        ArrayList<String> arrayList = new ArrayList<String>(20);
        while (!bl) {
            l = l + (long)string2.length() + 1L;
            if ((string2 = string2.trim()).length() == 0) {
                bl = true;
                continue;
            }
            char c = string2.charAt(0);
            if (c != 't' || string2.indexOf("total") == 0) {
                // empty if block
            }
            if (string3.indexOf(c) != -1) {
                int n = string2.lastIndexOf(32);
                String string4 = string2.substring(n + 1);
                boolean bl2 = c == 'd';
                arrayList.add(string4 + (bl2 ? "/" : ""));
            }
            bl = (string2 = bufferedReader.readLine()) == null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] listDirectory(String string) {
        string = FTPFileSystem.toCanonicalFolderName(string);
        try {
            new File(this.localRoot, string).mkdirs();
            File file = new File(this.localRoot, string + ".listing");
            if (!file.canRead()) {
                this.downloadFile(string, file, DasProgressMonitor.NULL);
            }
            file.deleteOnExit();
            return this.parseLsl(string, file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void downloadFile(String string, File file, DasProgressMonitor dasProgressMonitor) throws IOException {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            string = FTPFileSystem.toCanonicalFilename(string);
            URL uRL = new URL(this.root + string.substring(1));
            URLConnection uRLConnection = uRL.openConnection();
            int n = uRLConnection.getContentLength();
            dasProgressMonitor.setTaskSize(n);
            fileOutputStream = new FileOutputStream(file);
            inputStream = uRLConnection.getInputStream();
            this.copyStream(inputStream, fileOutputStream, dasProgressMonitor);
            dasProgressMonitor.finished();
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            file.delete();
            throw iOException;
        }
    }
}

