/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.awt;

import edu.uiowa.physics.pw.das.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.system.DasLogger;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public final class EventQueueBlocker {
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    static MyEventQueue myEventQueue = new MyEventQueue();

    private EventQueueBlocker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearEventQueueImmediately() {
        System.err.println(Thread.currentThread().getName());
        MyEventQueue myEventQueue = EventQueueBlocker.myEventQueue;
        synchronized (myEventQueue) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(EventQueueBlocker.myEventQueue);
            try {
                EventQueueBlocker.myEventQueue.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        logger.info("no more pending events");
    }

    private static DasUpdateEvent findUpdateEvent(EventQueue eventQueue) {
        LinkedList<AWTEvent> linkedList = new LinkedList<AWTEvent>();
        AWTEvent aWTEvent = null;
        DasUpdateEvent dasUpdateEvent = null;
        while (eventQueue.peekEvent() != null) {
            try {
                aWTEvent = eventQueue.getNextEvent();
                if (aWTEvent instanceof DasUpdateEvent) {
                    dasUpdateEvent = (DasUpdateEvent)aWTEvent;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            linkedList.add(aWTEvent);
        }
        while (linkedList.size() > 0) {
            eventQueue.postEvent((AWTEvent)linkedList.remove());
        }
        return dasUpdateEvent;
    }

    public static synchronized void clearEventQueue() throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            EventQueueBlocker.clearEventQueueImmediately();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        EventQueueBlocker.clearEventQueueImmediately();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            logger.finer("waiting for lockObject to indicate eventQueue is clear");
            logger.finer("event queue task complete");
        }
    }

    static class MyEventQueue
    extends EventQueue {
        MyEventQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchEvent(AWTEvent aWTEvent) {
            super.dispatchEvent(aWTEvent);
            if (myEventQueue.peekEvent(46288) == null) {
                MyEventQueue myEventQueue = this;
                synchronized (myEventQueue) {
                    this.pop();
                    this.notifyAll();
                }
            }
        }
    }
}

