/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLBuddy {
    private static final String ALPHA = "[A-Za-z]";
    private static final String DIGIT = "[0-9]";
    private static final String HEX = "[[0-9]A-F]";
    public static final Pattern VALID_QUERY_NAME = Pattern.compile("[A-Za-z][[A-Za-z][0-9]-_:.]*");
    public static final Pattern VALID_QUERY_VALUE = Pattern.compile("(?:[[A-Za-z][0-9]\\.\\-\\*\\_\\+]|\\%([[0-9]A-F][[0-9]A-F]))*");

    public static String encodeUTF8(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String decodeUTF8(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static Map parseQueryString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("\\&");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n == -1) {
                URLBuddy.throwUnexpectedToken(stringArray[i], string, "name/value pair");
            }
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 1);
            if (!URLBuddy.validName(string2)) {
                URLBuddy.throwUnexpectedToken(string2, string, "valid name");
            }
            if (!URLBuddy.validValue(string3)) {
                URLBuddy.throwUnexpectedToken(string2, string, "url encoded value");
            }
            string3 = URLBuddy.decodeUTF8(string3);
            hashMap.put(string2, string3);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static final void throwUnexpectedToken(String string, String string2, String string3) {
        int n = string2.indexOf(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error parsing query string: Expecting ");
        stringBuffer.append(string3).append(", found '");
        stringBuffer.append(string).append("'\n");
        stringBuffer.append("Input: ").append(string2).append('\n');
        stringBuffer.append("       ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('.');
        }
        stringBuffer.append('^');
        throw new IllegalArgumentException(stringBuffer.toString());
    }

    public static String formatQueryString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (!URLBuddy.validName(string)) {
                throw new IllegalArgumentException("'" + string + "' is not a valid query name.");
            }
            string2 = URLBuddy.encodeUTF8(string2);
            stringBuffer.append(string).append('=').append(string2).append('&');
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '&') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static boolean validName(String string) {
        Matcher matcher = VALID_QUERY_NAME.matcher(string);
        return matcher.matches();
    }

    private static boolean validValue(String string) {
        Matcher matcher = VALID_QUERY_VALUE.matcher(string);
        return matcher.matches();
    }
}

