/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class TimeParser {
    static final Logger logger = Logger.getLogger("TimeParser");
    public static final String TIMEFORMAT_Z = "%Y-%m-%dT%H:%M:%S.%{milli}Z";
    TimeUtil.TimeStruct time;
    TimeUtil.TimeStruct timeWidth;
    int ndigits;
    String[] valid_formatCodes = new String[]{"Y", "y", "j", "m", "d", "H", "M", "S", "milli", "micro", "p", "z", "ignore"};
    String[] formatName = new String[]{"Year", "2-digit-year", "day-of-year", "month", "day", "Hour", "Minute", "Second", "millisecond", "microsecond", "am/pm", "RFC-822 numeric time zone", "ignore"};
    int[] formatCode_lengths = new int[]{4, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 5, -1};
    int[] precision = new int[]{0, 0, 2, 1, 2, 3, 4, 5, 6, 7, -1, -1, -1};
    int[] handlers;
    Map fieldHandlers;
    int[] offsets;
    int[] lengths;
    String[] delims;
    String[] fc;
    String regex;
    int lsd;

    private TimeParser(String string, Map map) {
        int n;
        int n2;
        int n3;
        this.time = new TimeUtil.TimeStruct();
        String[] stringArray = string.split("%");
        this.fc = new String[stringArray.length];
        String[] stringArray2 = new String[stringArray.length + 1];
        this.ndigits = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(stringArray[0]);
        this.fieldHandlers = map;
        this.lengths = new int[this.ndigits];
        for (n3 = 0; n3 < this.lengths.length; ++n3) {
            this.lengths[n3] = -1;
        }
        stringArray2[0] = stringArray[0];
        for (n3 = 1; n3 < this.ndigits; ++n3) {
            n2 = 0;
            while (Character.isDigit(stringArray[n3].charAt(n2))) {
                ++n2;
            }
            if (n2 > 0) {
                this.lengths[n3] = Integer.parseInt(stringArray[n3].substring(0, n2));
            }
            if (stringArray[n3].charAt(n2) != '{') {
                this.fc[n3] = stringArray[n3].substring(n2, n2 + 1);
                stringArray2[n3] = stringArray[n3].substring(n2 + 1);
                continue;
            }
            n = stringArray[n3].indexOf(125, n2);
            this.fc[n3] = stringArray[n3].substring(n2 + 1, n);
            stringArray2[n3] = stringArray[n3].substring(n + 1);
        }
        this.handlers = new int[this.ndigits];
        this.offsets = new int[this.ndigits];
        this.offsets[0] = n3 = 0;
        this.lsd = -1;
        for (n2 = 1; n2 < this.ndigits; ++n2) {
            if (n3 != -1) {
                n3 += stringArray2[n2 - 1].length();
            }
            n = 9999;
            for (int i = 0; i < this.valid_formatCodes.length; ++i) {
                if (!this.valid_formatCodes[i].equals(this.fc[n2])) continue;
                n = i;
                break;
            }
            if (n == 9999) {
                if (map == null || !map.containsKey(this.fc[n2])) {
                    throw new IllegalArgumentException("bad format code: \"" + this.fc[n2] + "\"");
                }
                this.lsd = 100;
                n = 100;
                this.handlers[n2] = 100;
                this.offsets[n2] = n3;
                if (this.lengths[n2] < 1 || n3 == -1) {
                    n3 = -1;
                    this.lengths[n2] = -1;
                } else {
                    n3 += this.lengths[n2];
                }
            } else {
                this.handlers[n2] = n;
                if (this.lengths[n2] == -1) {
                    this.lengths[n2] = this.formatCode_lengths[n];
                }
                this.offsets[n2] = n3;
                if (this.lengths[n2] < 1 || n3 == -1) {
                    n3 = -1;
                    this.lengths[n2] = -1;
                } else {
                    n3 += this.lengths[n2];
                }
            }
            if (n < 100 && this.precision[n] > this.lsd) {
                this.lsd = this.precision[n];
            }
            String string2 = ".........";
            if (this.lengths[n2] == -1) {
                stringBuffer.append("(.*)");
            } else {
                stringBuffer.append("(" + string2.substring(0, this.lengths[n2]) + ")");
            }
            stringBuffer.append(stringArray2[n2]);
        }
        this.timeWidth = new TimeUtil.TimeStruct();
        switch (this.lsd) {
            case 0: {
                this.timeWidth.year = 1;
                break;
            }
            case 1: {
                this.timeWidth.month = 1;
                break;
            }
            case 2: {
                this.timeWidth.day = 1;
                break;
            }
            case 3: {
                this.timeWidth.hour = 1;
                break;
            }
            case 4: {
                this.timeWidth.minute = 1;
                break;
            }
            case 5: {
                this.timeWidth.seconds = 1.0;
                break;
            }
            case 6: {
                this.timeWidth.millis = 1;
                break;
            }
            case 7: {
                this.timeWidth.micros = 1;
                break;
            }
        }
        this.delims = stringArray2;
        this.regex = stringBuffer.toString();
    }

    public static TimeParser create(String string) {
        return new TimeParser(string, null);
    }

    public static TimeParser create(String string, String string2, FieldHandler fieldHandler) {
        HashMap<String, FieldHandler> hashMap = new HashMap<String, FieldHandler>();
        hashMap.put(string2, fieldHandler);
        return new TimeParser(string, hashMap);
    }

    private int parsePositiveInt(String string, int n, int n2) throws ParseException {
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = string.charAt(n) - 48;
                break;
            }
            case 2: {
                n3 = (string.charAt(n) - 48) * 10 + (string.charAt(n + 1) - 48);
                break;
            }
            case 3: {
                n3 = (string.charAt(n) - 48) * 100 + (string.charAt(n + 1) - 48) * 10 + (string.charAt(n + 2) - 48);
                break;
            }
            case 4: {
                n3 = (string.charAt(n) - 48) * 1000 + (string.charAt(n + 1) - 48) * 100 + (string.charAt(n + 2) - 48) * 10 + (string.charAt(n + 3) - 48);
                break;
            }
            default: {
                int n4 = 1;
                for (int i = n + n2 - 1; i >= n; --i) {
                    n3 += n4 * (string.charAt(i) - 48);
                    n4 *= 10;
                }
            }
        }
        if (n3 < 0) {
            throw new ParseException(string.substring(n, n + n2), 0);
        }
        return n3;
    }

    private double toUs2000(TimeUtil.TimeStruct timeStruct) {
        int n = timeStruct.year;
        int n2 = timeStruct.month;
        int n3 = timeStruct.day;
        int n4 = 367 * n - 7 * (n + (n2 + 9) / 12) / 4 - 3 * ((n + (n2 - 9) / 7) / 100 + 1) / 4 + 275 * n2 / 9 + n3 + 1721029;
        int n5 = timeStruct.hour;
        int n6 = timeStruct.minute;
        double d = timeStruct.seconds + (double)((float)n5 * 3600.0f) + (double)((float)n6 * 60.0f);
        double d2 = (double)(n4 - 2436205) + d / 86400.0;
        double d3 = (d2 - 15340.0) * 8.64E10 + d + (double)(timeStruct.millis * 1000) + (double)timeStruct.micros;
        return d3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeParser parse(String string) throws ParseException {
        int n = 0;
        int n2 = 0;
        this.time.month = 1;
        this.time.day = 1;
        this.time.hour = 0;
        this.time.minute = 0;
        this.time.seconds = 0.0;
        this.time.micros = 0;
        for (int i = 1; i < this.ndigits; ++i) {
            int n3;
            n = this.offsets[i] != -1 ? this.offsets[i] : (n += n2 + this.delims[i - 1].length());
            if (this.lengths[i] != -1) {
                n2 = this.lengths[i];
            } else if (this.delims[i].equals("")) {
                if (i != this.ndigits - 1) throw new IllegalArgumentException("No delimer specified after unknown length field, \"" + this.formatName[this.handlers[i]] + "\", field number=" + (1 + i) + "");
                n2 = string.length() - n;
            } else {
                n3 = string.indexOf(this.delims[i], n);
                n2 = n3 - n;
            }
            if (this.handlers[i] < 10) {
                n3 = Integer.parseInt(string.substring(n, n + n2));
                switch (this.handlers[i]) {
                    case 0: {
                        this.time.year = n3;
                        break;
                    }
                    case 1: {
                        this.time.year = n3 < 58 ? 2000 + n3 : 1900 + n3;
                        break;
                    }
                    case 2: {
                        this.time.month = 1;
                        this.time.day = n3;
                        break;
                    }
                    case 3: {
                        this.time.month = n3;
                        break;
                    }
                    case 4: {
                        this.time.day = n3;
                        break;
                    }
                    case 5: {
                        this.time.hour = n3;
                        break;
                    }
                    case 6: {
                        this.time.minute = n3;
                        break;
                    }
                    case 7: {
                        this.time.seconds = n3;
                        break;
                    }
                    case 8: {
                        this.time.millis = n3;
                        break;
                    }
                    case 9: {
                        this.time.micros = n3;
                    }
                }
                continue;
            }
            if (this.handlers[i] == 100) {
                FieldHandler fieldHandler = (FieldHandler)this.fieldHandlers.get(this.fc[i]);
                fieldHandler.handleValue(string.substring(n, n + n2), this.time, this.timeWidth);
                continue;
            }
            if (this.handlers[i] == 10) {
                n3 = string.charAt(n);
                if (n3 != 80 && n3 != 112) continue;
                this.time.hour += 12;
                continue;
            }
            if (this.handlers[i] != 11) continue;
            n3 = Integer.parseInt(string.substring(n, n + n2));
            DasMath.modp(0.0, 0.0);
            this.time.hour -= n3 / 100;
            this.time.minute -= n3 % 100;
        }
        return this;
    }

    public double getTime(Units units) {
        return Units.us2000.convertDoubleTo(units, this.toUs2000(this.time));
    }

    public Datum getTimeDatum() {
        return Units.us2000.createDatum(this.toUs2000(this.time));
    }

    public DatumRange getTimeRange() {
        TimeUtil.TimeStruct timeStruct = this.time.add(this.timeWidth);
        double d = this.toUs2000(this.time);
        double d2 = this.toUs2000(timeStruct);
        return new DatumRange(d, d2, Units.us2000);
    }

    public double getEndTime(Units units) {
        throw new IllegalArgumentException("not implemented for DatumRanges as of yet");
    }

    public String getRegex() {
        return this.regex;
    }

    public String format(Datum datum, Datum datum2) {
        throw new IllegalArgumentException("not implemented");
    }

    public static interface FieldHandler {
        public void handleValue(String var1, TimeUtil.TimeStruct var2, TimeUtil.TimeStruct var3);
    }
}

