/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterChannel
implements ReadableByteChannel {
    private boolean closed = false;
    private boolean eof = false;
    private ReadableByteChannel in;
    private Inflater inflater;
    private ByteBuffer buf;
    private byte[] outBuf;

    public InflaterChannel(ReadableByteChannel readableByteChannel) {
        this.in = readableByteChannel;
        byte[] byArray = new byte[4096];
        this.buf = ByteBuffer.wrap(byArray);
        this.inflater = new Inflater();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            this.in = null;
            this.inflater.end();
            this.inflater = null;
            this.buf = null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            byte[] byArray;
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (this.eof && this.inflater.finished()) {
                return -1;
            }
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                n3 = byteBuffer.remaining();
            } else {
                byArray = this.outBuf == null ? (this.outBuf = new byte[4096]) : this.outBuf;
                n4 = 0;
                n3 = Math.min(byArray.length, byteBuffer.remaining());
            }
            for (n = 0; n < n3; n += n2) {
                if (this.inflater.needsInput()) {
                    this.buf.clear();
                    if (this.in.read(this.buf) == -1) {
                        this.eof = true;
                    }
                    this.buf.flip();
                    this.inflater.setInput(this.buf.array(), this.buf.arrayOffset(), this.buf.remaining());
                }
                n2 = this.inflater.inflate(byArray, n4 + n, n3 - n);
                if (!this.inflater.finished()) continue;
            }
            if (byteBuffer.hasArray()) {
                byteBuffer.position(byteBuffer.position() + n);
            } else {
                byteBuffer.put(byArray, 0, n);
            }
            return n;
        }
        catch (DataFormatException dataFormatException) {
            this.eof = true;
            this.close();
            IOException iOException = new IOException(dataFormatException.getMessage());
            iOException.initCause(dataFormatException);
            throw iOException;
        }
    }
}

