/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.IDLValue;
import java.util.StringTokenizer;
import java.util.Vector;

public class IDLParser {
    public static int EXPR = 1;
    public static int EXPR_LIST = 2;
    public static int FACTOR = 3;
    public static int TERM = 4;
    public static int NUMBER = 5;
    public static int NOPARSER = 6;

    public String[] IDLTokenizer(String string) {
        int n;
        String string2 = " \t[,]()^*/+-";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(" ") || stringArray[i].equals("\t")) {
                stringArray[i] = null;
                ++n;
                continue;
            }
            if (!stringArray[i].endsWith("e") && !stringArray[i].endsWith("E") || !stringArray[i + 1].endsWith("-")) continue;
            stringArray[i] = stringArray[i] + stringArray[i + 1] + stringArray[i + 2];
            stringArray[i + 1] = null;
            stringArray[i + 2] = null;
            i += 2;
            n += 2;
        }
        if (n > 0) {
            String[] stringArray2 = new String[stringArray.length - n];
            int n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray2[n3] = stringArray[i];
                ++n3;
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public double parseIDLScalar(String string) {
        String[] stringArray = this.IDLTokenizer(string);
        IDLValue iDLValue = this.parseIDLArrayTokens(stringArray, EXPR);
        if (iDLValue == null) {
            return Double.NaN;
        }
        return iDLValue.toScalar();
    }

    public double[] parseIDLArray(String string) {
        String[] stringArray = this.IDLTokenizer(string);
        IDLValue iDLValue = this.parseIDLArrayTokens(stringArray, EXPR);
        if (iDLValue == null) {
            return null;
        }
        return iDLValue.toArray();
    }

    private IDLValue parseIDLExprList(String[] stringArray) {
        int n;
        Object object;
        String[] stringArray2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector<Object> vector = new Vector<Object>();
        n2 = 1;
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals(",") && n3 == 0 || stringArray[i].equals("]") && n3 == 0) {
                n4 = i - 1;
                stringArray2 = new String[n4 - n2 + 1];
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray2[j] = stringArray[j + n2];
                }
                object = this.parseIDLArrayTokens(stringArray2, EXPR);
                vector.add(object);
                n2 = i + 1;
                continue;
            }
            if (stringArray[i].equals("(")) {
                ++n3;
                continue;
            }
            if (stringArray[i].equals(")")) {
                --n3;
                continue;
            }
            if (stringArray[i].equals("[")) {
                ++n3;
                continue;
            }
            if (!stringArray[i].equals("]")) continue;
            --n3;
        }
        stringArray2 = new IDLValue();
        stringArray2.type = IDLValue.ARRAY;
        object = new Vector<Double>();
        for (n = 0; n < vector.size(); ++n) {
            IDLValue iDLValue = (IDLValue)vector.get(n);
            if (iDLValue.type == IDLValue.SCALAR) {
                ((Vector)object).add(new Double(iDLValue.sValue));
                continue;
            }
            for (int i = 0; i < iDLValue.aValue.length; ++i) {
                ((Vector)object).add(new Double(iDLValue.aValue[i]));
            }
        }
        stringArray2.aValue = new double[((Vector)object).size()];
        for (n = 0; n < ((Vector)object).size(); ++n) {
            stringArray2.aValue[n] = (Double)((Vector)object).get(n);
        }
        return stringArray2;
    }

    public IDLValue parseIDLArrayTokens(String[] stringArray, int n) {
        int n2;
        int n3;
        IDLValue iDLValue = null;
        IDLValue iDLValue2 = null;
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            iDLValue = new IDLValue(Double.parseDouble(stringArray[0]));
            return iDLValue;
        }
        String[] stringArray2 = null;
        if (n == EXPR) {
            stringArray2 = new String[]{"+", "-"};
            n3 = TERM;
        } else if (n == TERM) {
            stringArray2 = new String[]{"*", "/"};
            n3 = FACTOR;
        } else if (n == FACTOR) {
            stringArray2 = new String[]{"^"};
            n3 = NUMBER;
            if (stringArray[0].equals("-")) {
                String[] stringArray3 = new String[stringArray.length - 1];
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray3[i] = stringArray[i + 1];
                }
                iDLValue = this.parseIDLArrayTokens(stringArray3, FACTOR);
                iDLValue2 = iDLValue.IDLmultiply(new IDLValue(-1.0));
                return iDLValue2;
            }
        } else {
            int n4 = NOPARSER;
            if (stringArray[0].equals("(") && stringArray[stringArray.length - 1].equals(")")) {
                int n5 = 1;
                int n6 = stringArray.length - 2;
                String[] stringArray4 = new String[n6 - n5 + 1];
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray4[i] = stringArray[i + n5];
                }
                iDLValue = this.parseIDLArrayTokens(stringArray4, EXPR);
                return iDLValue;
            }
            if (stringArray[0].equals("[") && stringArray[stringArray.length - 1].equals("]")) {
                iDLValue = this.parseIDLExprList(stringArray);
                return iDLValue;
            }
            if (stringArray[0].equalsIgnoreCase("findgen") || stringArray[0].equalsIgnoreCase("dindgen")) {
                String[] stringArray5 = new String[stringArray.length - 3];
                for (int i = 0; i < stringArray5.length; ++i) {
                    stringArray5[i] = stringArray[i + 2];
                }
                iDLValue = this.parseIDLArrayTokens(stringArray5, EXPR);
                if (iDLValue.type != IDLValue.SCALAR) {
                    DasDie.println("Syntax error in findgen argument");
                    System.exit(-1);
                } else {
                    iDLValue = IDLValue.findgen((int)iDLValue.sValue);
                }
            } else if (stringArray[0].equalsIgnoreCase("alog10")) {
                String[] stringArray6 = new String[stringArray.length - 3];
                for (int i = 0; i < stringArray6.length; ++i) {
                    stringArray6[i] = stringArray[i + 2];
                }
                iDLValue = this.parseIDLArrayTokens(stringArray6, EXPR);
                iDLValue = IDLValue.alog10(iDLValue);
            } else if (stringArray[0].equalsIgnoreCase("sin")) {
                String[] stringArray7 = new String[stringArray.length - 3];
                for (int i = 0; i < stringArray7.length; ++i) {
                    stringArray7[i] = stringArray[i + 2];
                }
                iDLValue = this.parseIDLArrayTokens(stringArray7, EXPR);
                iDLValue = IDLValue.sin(iDLValue);
            } else {
                return null;
            }
            return iDLValue;
        }
        int n7 = 9999;
        String string = "";
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].equals("[")) {
                    ++n9;
                }
                if (stringArray[n2].equals("(")) {
                    ++n8;
                }
                if (stringArray[n2].equals("]")) {
                    --n9;
                }
                if (stringArray[n2].equals(")")) {
                    --n8;
                }
                if (!stringArray[n2].equals(stringArray2[i]) || n2 == 0 || i >= n7 || n8 != 0 || n9 != 0) continue;
                n7 = n2;
                string = stringArray2[i];
            }
        }
        if (n7 == 9999) {
            iDLValue2 = this.parseIDLArrayTokens(stringArray, n3);
        } else {
            String[] stringArray8 = new String[n7];
            for (n2 = 0; n2 < n7; ++n2) {
                stringArray8[n2] = stringArray[n2];
            }
            iDLValue = this.parseIDLArrayTokens(stringArray8, n3);
            stringArray8 = new String[stringArray.length - n7 - 1];
            for (n2 = 0; n2 < stringArray8.length; ++n2) {
                stringArray8[n2] = stringArray[n2 + n7 + 1];
            }
            IDLValue iDLValue3 = this.parseIDLArrayTokens(stringArray8, n);
            if (iDLValue == null || iDLValue3 == null) {
                iDLValue2 = n3 == NOPARSER ? null : this.parseIDLArrayTokens(stringArray, n3);
            } else if (string.equals("+")) {
                iDLValue2 = iDLValue.IDLadd(iDLValue3);
            } else if (string.equals("-")) {
                iDLValue2 = iDLValue.IDLsubtract(iDLValue3);
            } else if (string.equals("*")) {
                iDLValue2 = iDLValue.IDLmultiply(iDLValue3);
            } else if (string.equals("/")) {
                iDLValue2 = iDLValue.IDLdivide(iDLValue3);
            } else if (string.equals("^")) {
                iDLValue2 = iDLValue.IDLexponeniate(iDLValue3);
            }
        }
        return iDLValue2;
    }
}

