/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;

public class GrannyTextRenderer {
    public static final int LEFT_ALIGNMENT = 0;
    public static final int CENTER_ALIGNMENT = 1;
    public static final int RIGHT_ALIGNMENT = 2;
    private Rectangle bounds = null;
    private ArrayList lineBounds;
    private String str;
    private String[] tokens;
    private int alignment = 0;
    private Component parent;
    private float fontSize = 12.0f;

    public Rectangle getBounds() {
        this.maybeInitBounds();
        return new Rectangle(this.bounds);
    }

    private void maybeInitBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle((Rectangle)this.lineBounds.get(0));
            for (int i = 1; i < this.lineBounds.size(); ++i) {
                this.bounds.add((Rectangle)this.lineBounds.get(i));
            }
        }
    }

    public double getWidth() {
        this.maybeInitBounds();
        return this.bounds.getWidth();
    }

    public double getLineOneWidth() {
        return this.getLineWidth(1);
    }

    public double getLineWidth(int n) {
        return ((Rectangle)this.lineBounds.get(n - 1)).getWidth();
    }

    public double getHeight() {
        this.maybeInitBounds();
        return this.bounds.getHeight();
    }

    public double getAscent() {
        return -1.0 * ((Rectangle)this.lineBounds.get(0)).getY();
    }

    public double getDescent() {
        this.maybeInitBounds();
        return this.bounds.getHeight() + this.bounds.getY();
    }

    public void setString(Component component, String string) {
        this.parent = component;
        this.bounds = null;
        this.lineBounds = new ArrayList();
        this.str = string;
        this.tokens = GrannyTextRenderer.buildTokenArray(string);
        this.draw(null, 0.0f, 0.0f, component, false);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.alignment = n;
    }

    public void draw(Graphics graphics, float f, float f2) {
        this.draw(graphics, f, f2, null, true);
    }

    private void draw(Graphics graphics, float f, float f2, Component component, boolean bl) {
        Font font;
        Graphics2D graphics2D = null;
        Rectangle rectangle = null;
        if (bl) {
            graphics2D = (Graphics2D)graphics.create();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHints(renderingHints);
        }
        if ((font = bl ? graphics2D.getFont() : component.getFont()) == null) {
            font = Font.decode("sans-10");
        }
        int n = 1;
        class TextPosition {
            public int sub;
            public int ei;
            public float x;
            public float y;

            public TextPosition(int n, int n2, float f, float f2) {
                this.sub = n;
                this.ei = n2;
                this.x = f;
                this.y = f2;
            }

            public TextPosition(TextPosition textPosition) {
                this.copy(textPosition);
            }

            public void copy(TextPosition textPosition) {
                this.sub = textPosition.sub;
                this.ei = textPosition.ei;
                this.x = textPosition.x;
                this.y = textPosition.y;
            }
        }
        TextPosition textPosition = new TextPosition(0, 0, f, f2);
        if (bl) {
            if (this.alignment == 1) {
                textPosition.x = (float)((double)textPosition.x + (this.getWidth() - this.getLineOneWidth()) / 2.0);
            } else if (this.alignment == 2) {
                textPosition.x = (float)((double)textPosition.x + (this.getWidth() - this.getLineOneWidth()));
            }
        }
        if (!bl) {
            rectangle = new Rectangle((int)f, (int)f2, 0, 0);
        }
        Stack<TextPosition> stack = new Stack<TextPosition>();
        block27: for (int i = 0; i < this.tokens.length; ++i) {
            if (this.tokens[i].charAt(0) == '!') {
                switch (this.tokens[i].charAt(1)) {
                    case 'A': 
                    case 'a': {
                        textPosition.sub = 11;
                        textPosition.ei = 0;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        textPosition.sub = 12;
                        textPosition.ei = 0;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        ++n;
                        textPosition.sub = 0;
                        textPosition.ei = 0;
                        textPosition.x = f;
                        textPosition.y += font.getSize2D();
                        if (bl) {
                            graphics2D.setFont(font);
                            if (this.alignment == 1) {
                                textPosition.x = (float)((double)textPosition.x + (this.getWidth() - this.getLineWidth(n)) / 2.0);
                            } else if (this.alignment == 2) {
                                textPosition.x = (float)((double)textPosition.x + (this.getWidth() - this.getLineWidth(n)));
                            }
                        }
                        stack.clear();
                        if (bl) continue block27;
                        this.lineBounds.add(rectangle);
                        rectangle = new Rectangle((int)textPosition.x, (int)textPosition.y, 0, 0);
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        textPosition.sub = 1;
                        textPosition.ei = 0;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        textPosition.sub = 2;
                        textPosition.ei = 0;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        textPosition.sub = 3;
                        textPosition.ei = 0;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        textPosition.ei = 10;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        textPosition.ei = 4;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        textPosition.ei = 5;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        stack.push(new TextPosition(textPosition));
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        if (stack.peek() == null) {
                            return;
                        }
                        textPosition.copy((TextPosition)stack.pop());
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        textPosition.sub = 0;
                        textPosition.ei = 0;
                        break;
                    }
                    case '!': {
                        break;
                    }
                }
                continue;
            }
            Font font2 = font;
            float f3 = font.getSize2D();
            float f4 = textPosition.y;
            switch (textPosition.sub) {
                case 1: {
                    font2 = font.deriveFont(f3 * 0.62f);
                    f4 -= 0.38f * f3;
                    f3 *= 0.62f;
                    break;
                }
                case 2: {
                    font2 = font.deriveFont(f3 * 0.62f);
                    f4 += 0.31f * f3;
                    f3 *= 0.62f;
                    break;
                }
                case 3: {
                    font2 = font.deriveFont(f3 * 0.62f);
                    f4 += 0.62f * f3;
                    f3 *= 0.62f;
                    break;
                }
                case 11: {
                    f4 = textPosition.y - f3 / 2.0f;
                    break;
                }
                case 12: {
                    f4 = textPosition.y + f3 / 2.0f;
                    break;
                }
            }
            switch (textPosition.ei) {
                case 4: {
                    font2 = font2.deriveFont(f3 * 0.44f);
                    f4 -= 0.56f * f3;
                    break;
                }
                case 5: {
                    font2 = font2.deriveFont(f3 * 0.44f);
                    f4 += 0.22f * f3;
                    break;
                }
                case 10: {
                    font2 = font2.deriveFont(f3 * 0.8f);
                    break;
                }
            }
            if (bl) {
                graphics2D.setFont(font2);
                graphics2D.drawString(this.tokens[i], textPosition.x, f4);
                textPosition.x += (float)graphics2D.getFontMetrics(font2).stringWidth(this.tokens[i]);
                continue;
            }
            FontMetrics fontMetrics = component.getFontMetrics(font2);
            rectangle.add(textPosition.x, f4 + (float)fontMetrics.getDescent());
            rectangle.add(textPosition.x + (float)fontMetrics.stringWidth(this.tokens[i]), f4 - (float)fontMetrics.getAscent());
            textPosition.x += (float)component.getFontMetrics(font2).stringWidth(this.tokens[i]);
        }
        if (!bl) {
            this.lineBounds.add(rectangle);
        }
    }

    private static String[] buildTokenArray(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        boolean bl = false;
        while (n < string.length()) {
            int n2 = n;
            if (string.charAt(n2) == '!') {
                n = n2 + 2;
            } else {
                n = string.indexOf(33, n2);
                if (n == -1) {
                    n = string.length();
                }
            }
            vector.add(string.substring(n2, n));
        }
        String[] stringArray = new String[vector.size()];
        vector.copyInto(stringArray);
        return stringArray;
    }

    public String toString() {
        this.maybeInitBounds();
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": ").append(this.str).append(", ");
        stringBuffer.append(this.bounds).append(", ").append(this.lineBounds).append(", ");
        return stringBuffer.toString();
    }

    public void drawBounds(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.BLUE);
        graphics.drawRect(this.bounds.x + n, this.bounds.y + n2, this.bounds.width, this.bounds.height);
        graphics.setColor(Color.GREEN);
        for (Rectangle rectangle : this.lineBounds) {
            graphics.drawRect(rectangle.x + n, rectangle.y + n2, rectangle.width, rectangle.height);
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
        if (this.parent != null) {
            this.setString(this.parent, this.str);
        }
    }
}

