/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.DecimalFormat;

public class DasProgressMonitorInputStream
extends FilterInputStream {
    private DasProgressMonitor monitor;
    private boolean started = false;
    private int bytesRead = 0;
    long birthTimeMilli;
    long deathTimeMilli;
    DecimalFormat transferRateFormat;
    boolean enableProgressPosition;

    public DasProgressMonitorInputStream(InputStream inputStream, DasProgressMonitor dasProgressMonitor) {
        super(inputStream);
        this.monitor = dasProgressMonitor;
        this.birthTimeMilli = System.currentTimeMillis();
        this.deathTimeMilli = -1L;
        this.enableProgressPosition = true;
        if (dasProgressMonitor != null) {
            this.transferRateFormat = new DecimalFormat();
            this.transferRateFormat.setMaximumFractionDigits(2);
            this.transferRateFormat.setMinimumFractionDigits(2);
            if (this.enableProgressPosition) {
                dasProgressMonitor.setTaskSize(1000L);
            }
        }
    }

    private void reportTransmitSpeed() {
        this.monitor.setAdditionalInfo("(" + this.transferRateFormat.format(this.calcTransmitSpeed() / 1024.0) + "kB/s)");
        if (this.enableProgressPosition) {
            this.monitor.setTaskProgress(this.bytesRead / 1000);
        }
    }

    private double calcTransmitSpeed() {
        long l = this.bytesRead;
        long l2 = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        if (l2 == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return 1000L * l / l2;
    }

    public int read() throws IOException {
        this.checkCancelled();
        int n = super.read();
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                ++this.bytesRead;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        this.checkCancelled();
        int n = super.read(byArray);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                this.bytesRead += n;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkCancelled();
        int n3 = super.read(byArray, n, n2);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                this.bytesRead += n3;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return n3;
    }

    private void checkCancelled() throws IOException {
        if (this.monitor != null && this.monitor.isCancelled()) {
            this.close();
            throw new InterruptedIOException("Operation cancelled");
        }
    }

    public void close() throws IOException {
        super.close();
        this.deathTimeMilli = System.currentTimeMillis();
        if (this.monitor != null) {
            this.monitor.finished();
            this.started = false;
        }
    }

    public void setEnableProgressPosition(boolean bl) {
        this.enableProgressPosition = bl;
    }
}

