/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasDie;
import java.util.Arrays;

public class DasMath {
    private static final double log10 = Math.log(10.0);

    public static double log10(double d) {
        return Math.log(d) / log10;
    }

    public static double exp10(double d) {
        double d2 = Math.pow(10.0, d);
        return d2;
    }

    public static double exp10(int n) {
        double d = Math.pow(10.0, n);
        return d;
    }

    public static double roundNFractionalDigits(double d, int n) {
        double d2 = DasMath.exp10(n - 1);
        return (double)Math.round(d * d2) / d2;
    }

    public static double roundNSignificantDigits(double d, int n) {
        double d2 = d < 0.0 ? -1.0 : 1.0;
        double d3 = DasMath.exp10(Math.floor(DasMath.log10(d2 * d)));
        double d4 = d / d3;
        double d5 = DasMath.exp10(n - 1);
        d4 = (double)Math.round(d4 * d5) / d5;
        return d4 * d3;
    }

    public static double tanh(double d) {
        double d2 = (Math.exp(d) - Math.exp(-d)) / 2.0;
        double d3 = (Math.exp(d) + Math.exp(-d)) / 2.0;
        double d4 = d2 / d3;
        return d4;
    }

    public static double interpolate(double[] dArray, double d) {
        int n = (int)d;
        double d2 = d - (double)n;
        if (d < 0.0) {
            return dArray[0];
        }
        if (d > (double)dArray.length - 1.0) {
            return dArray[dArray.length - 1];
        }
        double d3 = d2 == 0.0 ? dArray[n] : dArray[n] * (1.0 - d2) + dArray[n + 1] * d2;
        return d3;
    }

    public static double[] interpolate(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i] = DasMath.interpolate(dArray, dArray2[i]);
        }
        return dArray3;
    }

    public static double[] findex(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        int n = 0;
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = DasMath.findex(dArray, dArray2[i], n);
            n = (int)dArray3[i];
        }
        return dArray3;
    }

    public static final double findex(double[] dArray, double d, int n) {
        int n2;
        for (n2 = Math.max(Math.min(n, dArray.length - 1), 0); n2 < dArray.length - 1 && dArray[n2 + 1] < d; ++n2) {
        }
        while (n2 > 0 && dArray[n2] > d) {
            --n2;
        }
        if (n2 == dArray.length - 1) {
            --n2;
        }
        return (double)n2 + (d - dArray[n2]) / (dArray[n2 + 1] - dArray[n2]);
    }

    public static void main(String[] stringArray) {
        double d = 1.0E-18;
        DasDie.println("x:" + d);
        DasDie.println("roundNDigits:" + DasMath.roundNSignificantDigits(d, 3));
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] dArray2 = new double[]{4.0, 6.0, 7.0, 3.0, 1.0};
        double[] dArray3 = new double[]{1.0, 1.5, 4.5, 5.0, 1.5};
        double[] dArray4 = DasMath.interpolate(dArray2, DasMath.findex(dArray, dArray3));
        for (int i = 0; i < dArray3.length; ++i) {
            System.out.println("" + dArray3[i] + " " + dArray4[i]);
        }
    }

    public static double modp(double d, double d2) {
        double d3 = d % d2;
        return d3 >= 0.0 ? d3 : d2 + d3;
    }

    public static double biggerOf(double d, double d2) {
        return d > d2 ? d : d2;
    }

    private static double gcd(double d, double d2, double d3) {
        double d4;
        if (d3 > 0.0) {
            d = Math.round(d / d3);
            d2 = Math.round(d2 / d3);
        }
        if (d < d2) {
            d4 = d;
            d = d2;
            d2 = d4;
        }
        if (d2 == 0.0) {
            if (d3 > 0.0) {
                return d * d3;
            }
            return d;
        }
        d4 = d % d2;
        for (int i = 0; d4 > 0.0 && i < 15; ++i) {
            d2 = d4;
            d4 = d % d2;
        }
        if (d3 > 0.0) {
            return d2 * d3;
        }
        return d2;
    }

    public static double gcd(double[] dArray, double d) {
        double d2;
        double d3 = d2 = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d3 = DasMath.gcd(d3, dArray[i], d);
        }
        return d3;
    }

    public static double mean(double[] dArray) {
        double d = dArray[0];
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i] - d;
        }
        return d2 / (double)dArray.length + d;
    }

    public static double median(double[] dArray) {
        double[] dArray2 = DasMath.sort(dArray);
        return dArray[dArray.length / 2];
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            d = d > dArray[i] ? d : dArray[i];
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            d = d < dArray[i] ? d : dArray[i];
        }
        return d;
    }

    public static double[] sort(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        Arrays.sort(dArray2);
        return dArray2;
    }
}

