/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public int read() {
        if (this.buffer.hasRemaining()) {
            return 0xFF & this.buffer.get();
        }
        return -1;
    }

    public void close() {
    }

    public long skip(long l) {
        if (l > (long)this.buffer.remaining()) {
            long l2 = this.buffer.remaining();
            this.buffer.position(this.buffer.limit());
            return l2;
        }
        this.buffer.position(this.buffer.position() + (int)l);
        return l;
    }

    public void reset() throws IOException {
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException invalidMarkException) {
            IOException iOException = new IOException(invalidMarkException.getMessage());
            iOException.initCause(invalidMarkException);
            throw iOException;
        }
    }

    public int available() {
        return this.buffer.remaining();
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.buffer.mark();
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.buffer.hasRemaining()) {
            int n3 = Math.min(n2, this.buffer.remaining());
            this.buffer.get(byArray, n, n3);
            return n3;
        }
        return -1;
    }
}

