/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.DasApplication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ArgumentList {
    int nposition;
    String programName;
    String[] positionKeys;
    HashMap values;
    HashMap descriptions;
    HashMap names;
    HashMap reverseNames;
    HashMap formUsed;
    HashMap abbrevs;
    HashMap isBoolean;
    ArrayList requireOneOfList;
    boolean allowUndefinedSwitch = false;
    private String UNSPECIFIED = new String("__unspecified__");
    private String REFERENCEWITHOUTVALUE = new String("__referencewithoutvalue__");
    private String UNDEFINED_SWITCH = new String("__undefinedSwitch__");
    private String FALSE = new String("__false__");
    private String TRUE = new String("__true__");

    public ArgumentList(String string) {
        this.programName = string;
        this.positionKeys = new String[10];
        this.values = new HashMap();
        this.descriptions = new HashMap();
        this.names = new HashMap();
        this.reverseNames = new HashMap();
        this.abbrevs = new HashMap();
        this.formUsed = new HashMap();
        this.requireOneOfList = new ArrayList();
    }

    public String getValue(String string) {
        if (this.values.containsKey(string)) {
            return (String)this.values.get(string);
        }
        throw new IllegalArgumentException("No such key: " + string);
    }

    public Preferences getPreferences() {
        return new AbstractPreferences(null, ""){

            protected void putSpi(String string, String string2) {
                ArgumentList.this.formUsed.put(string, string2);
                ArgumentList.this.values.put(string, string2);
            }

            protected String getSpi(String string) {
                if (ArgumentList.this.formUsed.containsKey(string)) {
                    return (String)ArgumentList.this.values.get(string);
                }
                return null;
            }

            protected void removeSpi(String string) {
            }

            protected void removeNodeSpi() throws BackingStoreException {
            }

            protected String[] keysSpi() throws BackingStoreException {
                return ArgumentList.this.values.keySet().toArray(new String[ArgumentList.this.values.size()]);
            }

            protected String[] childrenNamesSpi() throws BackingStoreException {
                return new String[0];
            }

            protected AbstractPreferences childSpi(String string) {
                return null;
            }

            protected void syncSpi() throws BackingStoreException {
            }

            protected void flushSpi() throws BackingStoreException {
            }
        };
    }

    public boolean getBooleanValue(String string) {
        return this.values.get(string) == this.TRUE;
    }

    public void addPositionArgument(int n, String string, String string2) {
        if (n > this.nposition) {
            throw new IllegalArgumentException("Position arguments must be specified 0,1,2,3: position=" + n);
        }
        if (n > this.positionKeys.length) {
            throw new IllegalArgumentException("Position too big: position=" + n);
        }
        this.nposition = n + 1;
        this.positionKeys[n] = string;
        this.descriptions.put(string, string2);
        this.values.put(string, this.UNSPECIFIED);
    }

    public void requireOneOf(String[] stringArray) {
        this.requireOneOfList.add(stringArray);
    }

    public void addOptionalPositionArgument(int n, String string, String string2, String string3) {
        this.addPositionArgument(n, string, string3);
        this.values.put(string, string2);
    }

    public void addSwitchArgument(String string, String string2, String string3, String string4) {
        if (string2 == null && string == null) {
            throw new IllegalArgumentException("both abbrev and name are null, one must be specified");
        }
        this.descriptions.put(string3, string4);
        if (string2 != null) {
            if (this.abbrevs.containsKey(string2)) {
                throw new IllegalArgumentException("abbrev already used: " + string2);
            }
            this.abbrevs.put(string2, string3);
        }
        if (string != null) {
            this.names.put(string, string3);
            this.reverseNames.put(string3, string);
        }
        this.values.put(string3, this.UNSPECIFIED);
    }

    public void addOptionalSwitchArgument(String string, String string2, String string3, String string4, String string5) {
        this.addSwitchArgument(string, string2, string3, string5);
        this.values.put(string3, string4);
    }

    public void addBooleanSwitchArgument(String string, String string2, String string3, String string4) {
        if (string3.equals("commandLinePrefs")) {
            this.allowUndefinedSwitch = true;
        }
        this.addOptionalSwitchArgument(string, string2, string3, this.FALSE, string4);
    }

    public void printUsage() {
        Object v;
        Object v2;
        String string = "Usage: " + this.programName + " ";
        for (int i = 0; i < this.nposition; ++i) {
            String string2 = this.positionKeys[i];
            string = this.values.get(string2) != this.UNSPECIFIED ? string + "[" + this.descriptions.get(string2) + "] " : string + "<" + this.descriptions.get(string2) + "> ";
        }
        System.err.println(string);
        Set set = this.names.keySet();
        for (Object object : set) {
            v2 = this.names.get(object);
            string = "  ";
            v = this.descriptions.get(v2);
            string = this.values.get(v2) != this.UNSPECIFIED ? (this.values.get(v2) == this.FALSE || this.values.get(v2) == this.TRUE ? string + "--" + object + "   " + v : string + "--" + object + "=" + v + " ") : string + "--" + object + "=" + v + " (required)";
            System.err.println(string);
        }
        set = this.abbrevs.keySet();
        for (Object object : set) {
            v2 = this.abbrevs.get(object);
            string = "  ";
            v = this.descriptions.get(v2);
            string = this.values.get(v2) != this.UNSPECIFIED ? (this.values.get(v2) == this.FALSE || this.values.get(v2) == this.TRUE ? string + "-" + object + "   \t" + v : string + "-" + object + "=" + v + " ") : string + "-" + object + "=" + v + " (required)";
            System.err.println(string);
        }
    }

    private void checkArgs() {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (!bl & n < this.nposition) {
            if (this.values.get(this.positionKeys[n]) == this.UNSPECIFIED) {
                arrayList.add("Expected more positional arguments, only got " + n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            for (Object object : this.values.keySet()) {
                if (object.equals("help") || object.equals("--help")) {
                    this.printUsage();
                    System.exit(-1);
                }
                if (this.values.get(object) == this.UNSPECIFIED) {
                    arrayList.add("Argument needed: --" + this.reverseNames.get(object));
                }
                if (this.values.get(object) == this.REFERENCEWITHOUTVALUE) {
                    arrayList.add("Switch requires argument: " + this.formUsed.get(object));
                }
                if (this.values.get(object) != this.UNDEFINED_SWITCH || this.allowUndefinedSwitch) continue;
                arrayList.add("Not a valid switch: " + this.formUsed.get(object));
            }
        }
        if (!bl) {
            for (n = 0; n < this.requireOneOfList.size(); ++n) {
                Object object;
                object = (String[])this.requireOneOfList.get(n);
                boolean bl2 = false;
                for (n = 0; n < ((K)object).length; ++n) {
                    if (!(!this.values.get(object[n]).equals(this.UNSPECIFIED) & !this.values.get(object[n]).equals(this.UNDEFINED_SWITCH) & !this.values.get(object[n]).equals(this.REFERENCEWITHOUTVALUE))) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                StringBuffer stringBuffer = new StringBuffer((String)this.reverseNames.get(object[0]));
                for (n = 1; n < ((K)object).length; ++n) {
                    stringBuffer.append(", " + (String)this.reverseNames.get(object[0]));
                }
                arrayList.add("One of the following needs to be specified: " + stringBuffer.toString());
            }
        }
        if (arrayList.size() > 0) {
            this.printUsage();
            System.err.println("");
            for (n = 0; n < arrayList.size(); ++n) {
                System.err.println(arrayList.get(n));
            }
            System.exit(-1);
        }
    }

    public Map getMap() {
        return new HashMap(this.values);
    }

    public Map getOptions() {
        HashMap hashMap = new HashMap();
        List<String> list = Arrays.asList(this.positionKeys);
        for (String string : this.values.keySet()) {
            if (list.contains(string) || !this.formUsed.containsKey(string)) continue;
            hashMap.put(string, this.values.get(string));
        }
        return hashMap;
    }

    private int processSwitch(String[] stringArray, int n) {
        String string;
        String string2;
        if (stringArray[n].startsWith("--")) {
            string2 = stringArray[n].substring(2);
            if (string2.indexOf(61) != -1) {
                string2 = string2.substring(0, string2.indexOf(61));
            }
            string = (String)this.names.get(string2);
        } else {
            string2 = stringArray[n].substring(1);
            if (string2.indexOf(61) != -1) {
                string2 = string2.substring(0, string2.indexOf(61));
            }
            string = (String)this.abbrevs.get(string2);
        }
        if (string == null) {
            string = stringArray[n];
            this.values.put(string, this.UNDEFINED_SWITCH);
            this.formUsed.put(string, stringArray[n]);
            DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).finer("undefined switch: " + string);
        } else {
            this.formUsed.put(string, stringArray[n]);
            if (this.values.get(string) == this.FALSE || this.values.get(string) == this.TRUE) {
                this.values.put(string, this.TRUE);
            } else {
                if (stringArray[n].indexOf(61) != -1) {
                    string2 = stringArray[n].substring(stringArray[n].indexOf(61) + 1);
                } else if (n + 1 < stringArray.length && !stringArray[n + 1].startsWith("-")) {
                    string2 = stringArray[n + 1];
                    ++n;
                } else {
                    string2 = this.REFERENCEWITHOUTVALUE;
                }
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 2);
                }
                DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).finer("switch key: " + string + "=" + string2);
                this.values.put(string, string2);
            }
        }
        return n;
    }

    public void process(String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
        }
        DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("args: " + stringBuffer.toString());
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                i = this.processSwitch(stringArray, i);
                continue;
            }
            String string = this.positionKeys[n];
            DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).finer("position key: " + string + "=" + stringArray[i]);
            String string2 = stringArray[i];
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 2);
            }
            this.values.put(string, stringArray[i]);
            ++n;
            this.formUsed.put(string, stringArray[i]);
        }
        this.checkArgs();
    }

    public void printPrefsSettings() {
        String string = "Explicit Settings: \n";
        string = string + this.programName + " ";
        for (int i = 0; i < this.nposition; ++i) {
            String string2 = this.positionKeys[i];
            if (this.formUsed.get(string2) == null) continue;
            string = string + this.formUsed.get(string2);
        }
        Set set = this.names.keySet();
        for (Object e : set) {
            Object v = this.names.get(e);
            String string3 = (String)this.formUsed.get(v);
            if (string3 == null) continue;
            if (string3 == this.TRUE) {
                string = string + "--" + e;
            }
            if (string3 == this.FALSE) continue;
            string = string + "--" + e + "=" + string3 + " ";
        }
        System.err.println(string);
    }
}

