/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;

public class UserMessageCenter {
    private static UserMessageCenter instance;
    List messageRecords;
    HashMap sources = new HashMap();
    int tabCount;
    private JTabbedPane pane;
    private JFrame frame;

    public static UserMessageCenter getDefault() {
        if (instance == null) {
            instance = new UserMessageCenter();
        }
        return instance;
    }

    private UserMessageCenter() {
        this.createComponents();
        this.messageRecords = new ArrayList();
    }

    public void notifyUser(Object object, String string) {
        JTextPane jTextPane = new JTextPane();
        if (string.startsWith("<html>")) {
            jTextPane.setContentType("text/html");
        }
        try {
            jTextPane.getEditorKit().read(new StringReader(string), jTextPane.getDocument(), 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.notifyUser(object, jTextPane);
    }

    private void notifyUser(Object object, JTextPane jTextPane) {
        HashMap hashMap = (HashMap)this.sources.get(object);
        if (hashMap != null && hashMap.containsKey(jTextPane.getText())) {
            return;
        }
        if (hashMap == null) {
            hashMap = new HashMap();
            this.sources.put(object, hashMap);
        }
        hashMap.put(jTextPane.getText(), null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTextPane, "Center");
        JButton jButton = new JButton(this.getNextAction());
        jPanel.add((Component)jButton, "South");
        this.pane.add((Component)jPanel, this.tabCount);
        ++this.tabCount;
        if (this.tabCount > 0) {
            this.frame.setVisible(true);
        }
        MessageRecord messageRecord = new MessageRecord();
        messageRecord.component = jPanel;
        messageRecord.nextButton = jButton;
        this.messageRecords.add(messageRecord);
        this.update();
    }

    private void update() {
        for (int i = 0; i < this.messageRecords.size(); ++i) {
            MessageRecord messageRecord = (MessageRecord)this.messageRecords.get(i);
            messageRecord.nextButton.setEnabled(i < this.messageRecords.size() - 1);
        }
    }

    private Action getNextAction() {
        return new AbstractAction("Next >>"){

            public void actionPerformed(ActionEvent actionEvent) {
                UserMessageCenter.this.next();
            }
        };
    }

    private void next() {
        int n = this.pane.getSelectedIndex();
        if (n < this.tabCount - 1) {
            this.pane.setSelectedIndex(++n);
        }
    }

    private void prev() {
        int n = this.pane.getSelectedIndex();
        if (n > 0) {
            this.pane.setSelectedIndex(--n);
        }
    }

    private void createComponents() {
        this.frame = new JFrame("das2 messages");
        this.frame.setDefaultCloseOperation(1);
        this.pane = new JTabbedPane();
        this.pane.setOpaque(true);
        this.pane.setPreferredSize(new Dimension(400, 300));
        this.pane.setMinimumSize(this.pane.getPreferredSize());
        this.frame.setContentPane(this.pane);
        this.frame.pack();
    }

    public void notifyUser(Object object, Throwable throwable) {
        this.notifyUser(object, throwable.getMessage());
    }

    class MessageRecord {
        JButton nextButton;
        Component component;

        MessageRecord() {
        }
    }
}

