/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.system;

import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public final class RequestProcessor {
    private static final BlockingRequestQueue queue = new BlockingRequestQueue();
    private static final WeakHashMap runnableQueueMap = new WeakHashMap();
    private static final Runner runner = new Runner();
    private static int maxThreadCount = 10;
    private static int threadCount = 0;
    private static final Object THREAD_COUNT_LOCK = new Object();
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    private static int threadOrdinal = 0;

    private RequestProcessor() {
    }

    private static void setJob(Runnable runnable) {
        RequestThread requestThread = (RequestThread)Thread.currentThread();
        requestThread.setJob(runnable);
    }

    private static void newThread() {
        String string = "RequestProcessor[" + threadOrdinal++ + "]";
        RequestThread requestThread = new RequestThread(runner, string);
        requestThread.setPriority(5);
        requestThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable runnable) {
        logger.info("invokeLater " + runnable);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        queue.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable runnable, Object object) {
        logger.info("invokeLater " + runnable + " " + object);
        Object object2 = THREAD_COUNT_LOCK;
        synchronized (object2) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object2 = runnableQueueMap;
        synchronized (object2) {
            RunnableQueue runnableQueue = (RunnableQueue)runnableQueueMap.get(object);
            if (runnableQueue == null) {
                runnableQueue = new RunnableQueue();
                runnableQueueMap.put(object, runnableQueue);
            }
            runnableQueue.add(runnable, false);
            queue.add(runnableQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAfter(Runnable runnable, Object object) {
        logger.info("invokeAfter " + runnable + " " + object);
        Object object2 = THREAD_COUNT_LOCK;
        synchronized (object2) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object2 = runnableQueueMap;
        synchronized (object2) {
            RunnableQueue runnableQueue = (RunnableQueue)runnableQueueMap.get(object);
            if (runnableQueue == null) {
                runnableQueue = new RunnableQueue();
                runnableQueueMap.put(object, runnableQueue);
            }
            runnableQueue.add(runnable, true);
            queue.add(runnableQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object object) throws InterruptedException {
        WaitTask waitTask;
        WaitTask waitTask2 = waitTask = new WaitTask();
        synchronized (waitTask2) {
            RequestProcessor.invokeLater(waitTask, object);
            waitTask.wait();
            return;
        }
    }

    private static class BlockingRequestQueue {
        private LinkedList list = new LinkedList();

        BlockingRequestQueue() {
        }

        synchronized void add(Runnable runnable) {
            this.list.add(runnable);
            this.notify();
        }

        synchronized Runnable remove() {
            while (this.list.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (Runnable)this.list.removeFirst();
        }
    }

    private static class RequestEntry {
        Runnable run;
        boolean async;

        private RequestEntry() {
        }
    }

    private static class RunnableQueue
    implements Runnable {
        private LinkedList list = new LinkedList();
        private int readCount = 0;
        private Object writer;

        private RunnableQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunnableQueue runnableQueue;
            Runnable runnable = null;
            RequestEntry requestEntry = null;
            Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
            while (runnable == null) {
                runnableQueue = this;
                synchronized (runnableQueue) {
                    requestEntry = (RequestEntry)this.list.getFirst();
                    if (requestEntry.async && this.readCount == 0 && this.writer == null) {
                        this.list.removeFirst();
                        this.writer = requestEntry;
                        runnable = requestEntry.run;
                    } else if (!requestEntry.async && this.writer == null) {
                        this.list.removeFirst();
                        ++this.readCount;
                        runnable = requestEntry.run;
                    }
                }
            }
            logger.fine("Starting :" + runnable);
            runnable.run();
            logger.fine("Finished :" + runnable);
            runnableQueue = this;
            synchronized (runnableQueue) {
                if (requestEntry.async) {
                    this.writer = null;
                } else {
                    --this.readCount;
                }
                this.notifyAll();
            }
        }

        synchronized void add(Runnable runnable, boolean bl) {
            RequestEntry requestEntry = new RequestEntry();
            requestEntry.run = runnable;
            requestEntry.async = bl;
            this.list.add(requestEntry);
        }
    }

    private static class WaitTask
    implements Runnable {
        private WaitTask() {
        }

        public synchronized void run() {
            this.notifyAll();
        }
    }

    private static class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object = THREAD_COUNT_LOCK;
            synchronized (object) {
                threadCount++;
            }
            try {
                while (true) {
                    try {
                        while (true) {
                            object = queue.remove();
                            logger.fine("running " + object);
                            if (object != null) {
                                RequestProcessor.setJob((Runnable)object);
                                object.run();
                                logger.fine("completed " + object);
                            }
                            Object object2 = THREAD_COUNT_LOCK;
                            synchronized (object2) {
                                if (threadCount > maxThreadCount) {
                                    return;
                                }
                            }
                        }
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        logger.info("uncaught exception " + throwable);
                        DasExceptionHandler.handleUncaught(throwable);
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            finally {
                object = THREAD_COUNT_LOCK;
                synchronized (object) {
                    threadCount--;
                }
            }
        }
    }

    private static class RequestThread
    extends Thread {
        private WeakReference job;

        private RequestThread(Runnable runnable, String string) {
            super(runnable, string);
        }

        private void setJob(Runnable runnable) {
            this.job = new WeakReference<Runnable>(runnable);
        }

        private Runnable getJob() {
            return (Runnable)this.job.get();
        }
    }
}

