/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.system;

import edu.uiowa.physics.pw.das.system.LoggerId;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class DasLogger {
    public static final LoggerId APPLICATION_LOG;
    public static final LoggerId SYSTEM_LOG;
    public static final LoggerId GUI_LOG;
    public static final LoggerId GRAPHICS_LOG;
    public static final LoggerId DATA_OPERATIONS_LOG;
    public static final LoggerId DATA_TRANSFER_LOG;
    public static final LoggerId FILESYSTEM_LOG;
    public static final LoggerId DASML_LOG;

    public static void reload() throws IOException {
        try {
            URL uRL;
            File file = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
            File file2 = new File(file, ".das2");
            File file3 = new File(file2, "logging.properties");
            if (file3.exists()) {
                Logger.getLogger("").info("using " + file3);
                uRL = file3.toURL();
            } else {
                uRL = DasLogger.class.getResource("logging.properties");
            }
            if (uRL == null) {
                System.err.println("unable to locate logging properties file logging.properties, using defaults");
            } else {
                LogManager.getLogManager().readConfiguration(uRL.openStream());
                System.err.println("read log configuration from " + uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static void printStatus() {
        String[] stringArray = new String[]{"", "das2.system", "das2.gui", "das2.graphics", "das2.dataOperations", "das2.dataTransfer"};
        for (int i = 0; i < stringArray.length; ++i) {
            Logger logger = Logger.getLogger(stringArray[i]);
            Level level = logger.getLevel();
            while (level == null) {
                logger = logger.getParent();
                level = logger.getLevel();
            }
            System.err.println(stringArray[i] + " logging at " + level);
        }
    }

    public static Logger getLogger() {
        return APPLICATION_LOG.getLogger();
    }

    public static Logger getLogger(LoggerId loggerId) {
        return loggerId.getLogger();
    }

    public static Logger getLogger(LoggerId loggerId, String string) {
        String string2 = loggerId.toString() + "." + string;
        return Logger.getLogger(string2);
    }

    public synchronized Logger getDebugLogger() {
        return Logger.getLogger("debug");
    }

    static {
        try {
            DasLogger.reload();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        APPLICATION_LOG = new LoggerId("");
        SYSTEM_LOG = new LoggerId("das2.system");
        GUI_LOG = new LoggerId("das2.gui");
        GRAPHICS_LOG = new LoggerId("das2.graphics");
        DATA_OPERATIONS_LOG = new LoggerId("das2.dataOperations");
        DATA_TRANSFER_LOG = new LoggerId("das2.dataTransfer");
        FILESYSTEM_LOG = new LoggerId("das2.filesystem");
        DASML_LOG = new LoggerId("das2.dasml");
    }
}

