/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamYScanDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Units yUnits = Units.dimensionless;
    private Units zUnits = Units.dimensionless;
    private double[] yTags;
    private int nitems;
    private String name = "";
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    private double[] values;

    public StreamYScanDescriptor(Element element) {
        if (element.getTagName().equals("yscan")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String string;
        String string2;
        String string3;
        String[] stringArray;
        this.nitems = Integer.parseInt(element.getAttribute("nitems"));
        String string4 = element.getAttribute("yTags");
        if (string4 != null) {
            this.yTags = new double[this.nitems];
            boolean bl = false;
            stringArray = string4.split("\\s*,\\s*");
            for (int i = 0; i < this.nitems; ++i) {
                this.yTags[i] = Double.parseDouble(stringArray[i]);
            }
        }
        if ((stringArray = DataTransferType.getByName(string3 = element.getAttribute("type"))) == null) {
            throw new RuntimeException("Illegal transfer type: " + string3);
        }
        this.transferType = stringArray;
        String string5 = element.getAttribute("yUnits");
        if (string5 != null) {
            this.yUnits = Units.getByName(string5);
        }
        if ((string2 = element.getAttribute("zUnits")) != null) {
            this.zUnits = Units.getByName(string2);
        }
        if ((string = element.getAttribute("name")) != null) {
            this.name = string;
        }
    }

    private void processLegacyElement(Element element) {
        try {
            DataTransferType dataTransferType;
            String string;
            if (!element.getTagName().equals("YScan")) {
                throw new IllegalArgumentException("xml tree root node is not the right type. Node type is: " + element.getTagName());
            }
            this.nitems = Integer.parseInt(element.getAttribute("nitems"));
            if (element.getAttribute("yCoordinate") != null) {
                string = element.getAttribute("yCoordinate");
                this.yTags = new double[this.nitems];
                int n = 0;
                for (int i = 0; i < this.nitems - 1; ++i) {
                    int n2 = string.indexOf(",", n) - 1;
                    this.yTags[i] = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 2;
                }
                this.yTags[this.nitems - 1] = Double.parseDouble(string.substring(n));
            }
            if ((dataTransferType = DataTransferType.getByName(string = element.getAttribute("type"))) == null) {
                throw new RuntimeException("Illegal transfer type: " + string);
            }
            this.transferType = dataTransferType;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Error in das2stream at yCoordinate");
        }
        this.name = element.getAttribute("name") != null ? element.getAttribute("name") : "";
    }

    public StreamYScanDescriptor() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double[] getYTags() {
        return (double[])this.yTags.clone();
    }

    public void setYCoordinates(double[] dArray) {
        this.yTags = (double[])dArray.clone();
        this.nitems = dArray.length;
    }

    public int getNItems() {
        return this.nitems;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public void setZUnits(Units units) {
        this.zUnits = units;
    }

    public void setYCoordinates(DatumVector datumVector) {
        this.yUnits = datumVector.getUnits();
        this.yTags = datumVector.toDoubleArray(this.yUnits);
        this.nitems = this.yTags.length;
    }

    public void setDataTransferType(DataTransferType dataTransferType) {
        this.transferType = dataTransferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public int getSizeBytes() {
        return this.nitems * this.transferType.getSizeBytes();
    }

    public DatumVector read(ByteBuffer byteBuffer) {
        if (this.values == null) {
            this.values = new double[this.nitems];
        }
        for (int i = 0; i < this.nitems; ++i) {
            this.values[i] = this.transferType.read(byteBuffer);
        }
        return DatumVector.newDatumVector(this.values, this.zUnits);
    }

    public void write(DatumVector datumVector, ByteBuffer byteBuffer) {
        this.values = datumVector.toDoubleArray(this.values, this.zUnits);
        for (int i = 0; i < this.nitems; ++i) {
            this.transferType.write(this.values[i], byteBuffer);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("yscan");
        element.setAttribute("nitems", String.valueOf(this.nitems));
        element.setAttribute("yTags", StreamYScanDescriptor.toString(this.yTags));
        element.setAttribute("yUnits", this.yUnits.toString());
        element.setAttribute("zUnits", this.zUnits.toString());
        element.setAttribute("type", this.transferType.toString());
        if (this.name != null && !this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    private static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            stringBuffer.append(", ").append(dArray[i]);
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)super.clone();
            streamYScanDescriptor.yTags = (double[])this.yTags.clone();
            return streamYScanDescriptor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        return "<yScan nitems=" + this.nitems + ">";
    }
}

