/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamXDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Datum base;
    private Units baseUnits = Units.us2000;
    private Units units = null;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;

    public StreamXDescriptor() {
    }

    public StreamXDescriptor(Element element) {
        if (element.getTagName().equals("x")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String string;
        String string2 = element.getAttribute("type");
        DataTransferType dataTransferType = DataTransferType.getByName(string2);
        if (dataTransferType == null) {
            throw new RuntimeException("Illegal transfer type: " + string2);
        }
        this.transferType = dataTransferType;
        if (dataTransferType instanceof DataTransferType.Time) {
            this.units = ((DataTransferType.Time)dataTransferType).getUnits();
        } else {
            string = element.getAttribute("units");
            this.units = Units.getByName(string);
        }
        string = element.getAttribute("base");
        if (string != null && !string.equals("") && this.baseUnits instanceof TimeLocationUnits) {
            this.base = TimeUtil.createValid(string);
        }
    }

    private void processLegacyElement(Element element) {
        String string = element.getAttribute("type");
        DataTransferType dataTransferType = DataTransferType.getByName(string);
        if (dataTransferType == null) {
            throw new RuntimeException("Illegal transfer type: " + string);
        }
        this.transferType = dataTransferType;
    }

    public Datum getBase() {
        return this.base;
    }

    public void setBase(Datum datum) {
        this.base = datum;
    }

    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setDataTransferType(DataTransferType dataTransferType) {
        this.transferType = dataTransferType;
        if (dataTransferType instanceof DataTransferType.Time) {
            if (this.units == null) {
                throw new IllegalArgumentException("please set the units first!!!");
            }
            ((DataTransferType.Time)dataTransferType).units = this.units;
        }
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public Datum readDatum(ByteBuffer byteBuffer) {
        return Datum.create(this.transferType.read(byteBuffer), this.units);
    }

    public DatumVector read(ByteBuffer byteBuffer) {
        return DatumVector.newDatumVector(new double[]{this.transferType.read(byteBuffer)}, this.units);
    }

    public void writeDatum(Datum datum, ByteBuffer byteBuffer) {
        this.transferType.write(datum.doubleValue(this.units), byteBuffer);
    }

    public void write(DatumVector datumVector, ByteBuffer byteBuffer) {
        this.transferType.write(datumVector.doubleValue(0, this.units), byteBuffer);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("x");
        if (this.base != null) {
            element.setAttribute("base", this.base.toString());
        }
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        return element;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

