/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamMultiYDescriptor
implements SkeletonDescriptor,
Cloneable {
    private String name = "";
    private Units units = Units.dimensionless;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;

    public StreamMultiYDescriptor(Element element) {
        if (element.getTagName().equals("y")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String string = element.getAttribute("name");
        if (string != null) {
            this.name = string;
        }
        String string2 = element.getAttribute("type");
        DataTransferType dataTransferType = DataTransferType.getByName(string2);
        String string3 = element.getAttribute("units");
        if (string3 != null) {
            this.units = Units.getByName(string3);
        }
        if (dataTransferType == null) {
            throw new RuntimeException("Illegal transfer type: " + string2);
        }
        this.transferType = dataTransferType;
    }

    private void processLegacyElement(Element element) {
        this.name = element.getAttribute("name") != null ? element.getAttribute("name") : "";
        String string = element.getAttribute("type");
        DataTransferType dataTransferType = DataTransferType.getByName(string);
        if (dataTransferType == null) {
            throw new RuntimeException("Illegal transfer type: " + string);
        }
        this.transferType = dataTransferType;
    }

    public StreamMultiYDescriptor() {
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public void setDataTransferType(DataTransferType dataTransferType) {
        this.transferType = dataTransferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public DatumVector read(ByteBuffer byteBuffer) {
        return DatumVector.newDatumVector(new double[]{this.transferType.read(byteBuffer)}, this.units);
    }

    public void write(DatumVector datumVector, ByteBuffer byteBuffer) {
        this.transferType.write(datumVector.doubleValue(0, this.units), byteBuffer);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("y");
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        if (!this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

