/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.DasStreamFormatException;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.IDLParser;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Map properties = new HashMap();
    private StreamXDescriptor xDescriptor;
    private ArrayList yDescriptors = new ArrayList();
    private String compression;

    public StreamDescriptor(Element element) throws StreamException {
        if (element.getTagName().equals("stream")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) throws StreamException {
        this.compression = element.getAttribute("compression");
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            Map map = StreamTool.processPropertiesElement(element2);
            this.properties.putAll(map);
        }
    }

    private void processLegacyElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SkeletonDescriptor skeletonDescriptor;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals("X")) {
                this.xDescriptor = new StreamXDescriptor(element2);
                continue;
            }
            if (string.equals("YScan")) {
                skeletonDescriptor = new StreamYScanDescriptor(element2);
                this.yDescriptors.add(skeletonDescriptor);
                continue;
            }
            if (!string.equals("MultiY")) continue;
            skeletonDescriptor = new StreamMultiYDescriptor(element2);
            this.yDescriptors.add(skeletonDescriptor);
        }
    }

    public StreamDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor streamXDescriptor) {
        this.xDescriptor = streamXDescriptor;
    }

    public void addYScan(StreamYScanDescriptor streamYScanDescriptor) {
        this.yDescriptors.add(streamYScanDescriptor);
    }

    public void addYMulti(StreamMultiYDescriptor streamMultiYDescriptor) {
        this.yDescriptors.add(streamMultiYDescriptor);
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(this.yDescriptors);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public static Document parseHeader(Reader reader) throws DasIOException, DasStreamFormatException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(reader);
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new DasIOException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    public int getSizeBytes() {
        return -1;
    }

    public DatumVector read(ByteBuffer byteBuffer) {
        return null;
    }

    public void write(DatumVector datumVector, ByteBuffer byteBuffer) {
    }

    public static StreamDescriptor createLegacyDescriptor(BufferedReader bufferedReader) throws IOException {
        IDLParser iDLParser = new IDLParser();
        int n = 1;
        Pattern pattern = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");
        StreamDescriptor streamDescriptor = new StreamDescriptor();
        streamDescriptor.properties.put("legacy", "true");
        Object object = bufferedReader.readLine();
        while (object != null) {
            int n2 = ((String)object).trim().indexOf(59);
            if (n2 == 0) {
                ++n;
            } else {
                if (n2 != -1) {
                    object = ((String)object).substring(0, n2);
                }
                n2 = ((String)object).indexOf(61);
                String string = ((String)object).substring(0, n2).trim();
                String string2 = ((String)object).substring(n2 + 1).trim();
                if (string.equals("description")) {
                    String string3 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string3);
                } else if (string.equals("groupAccess")) {
                    streamDescriptor.properties.put(string, string2.substring(1, string2.length() - 1));
                } else if (string.equals("form")) {
                    streamDescriptor.properties.put(string, string2);
                } else if (string.equals("reader")) {
                    String string4 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string4);
                } else if (string.equals("x_parameter")) {
                    String string5 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string5);
                } else if (string.equals("x_unit")) {
                    String string6 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string6);
                } else if (string.equals("y_parameter")) {
                    String string7 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string7);
                } else if (string.equals("y_unit")) {
                    String string8 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string8);
                } else if (string.equals("z_parameter")) {
                    String string9 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string9);
                } else if (string.equals("z_unit")) {
                    String string10 = string2.substring(1, string2.length() - 1);
                    streamDescriptor.properties.put(string, string10);
                } else if (string.equals("x_sample_width")) {
                    double d = iDLParser.parseIDLScalar(string2);
                    if (d == Double.NaN) {
                        throw new IOException("Could not parse \"" + string2 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string, new Double(d));
                } else if (string.equals("y_fill")) {
                    double d = iDLParser.parseIDLScalar(string2);
                    if (d == Double.NaN) {
                        throw new IOException("Could not parse \"" + string2 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string, new Double(d));
                } else if (string.equals("z_fill")) {
                    double d = (float)iDLParser.parseIDLScalar(string2);
                    if (d == Double.NaN) {
                        throw new IOException("Could not parse \"" + string2 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string, new Float(d));
                } else if (string.equals("y_coordinate")) {
                    double[] dArray = iDLParser.parseIDLArray(string2);
                    if (dArray == null) {
                        throw new IOException("Could not parse \"" + string2 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string, dArray);
                } else if (string.equals("ny")) {
                    int n3;
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Could not parse \"" + string2 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string, new Integer(n3));
                } else if (string.equals("items")) {
                    int n4;
                    try {
                        n4 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Could not parse \"" + string2 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string, new Integer(n4));
                } else {
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.matches()) {
                        int n5 = Integer.parseInt(matcher.group(1));
                        string2 = string2.substring(1, string2.length() - 1);
                        if (n5 == 0) {
                            streamDescriptor.properties.put("label", string2);
                        } else {
                            String[] stringArray = StreamDescriptor.ensureCapacity((String[])streamDescriptor.properties.get("plane-list"), n5);
                            stringArray[n5 - 1] = string2;
                            streamDescriptor.properties.put("plane-list", stringArray);
                            streamDescriptor.properties.put(string2 + ".label", string2);
                        }
                    } else if (string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
                        streamDescriptor.properties.put(string, string2.substring(1, string2.length() - 1));
                    } else if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                        streamDescriptor.properties.put(string, string2.substring(1, string2.length() - 1));
                    } else {
                        streamDescriptor.properties.put(string, string2);
                    }
                }
                ++n;
            }
            object = bufferedReader.readLine();
        }
        object = (String[])streamDescriptor.properties.get("plane-list");
        if (object != null) {
            streamDescriptor.properties.put("plane-list", Collections.unmodifiableList(Arrays.asList(object)));
        }
        streamDescriptor.properties.put("legacy", "true");
        return streamDescriptor;
    }

    public static String createHeader(Document document) throws DasIOException {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setEncoding("UTF-8");
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        String string = stringWriter.toString();
        return string;
    }

    private static String[] ensureCapacity(String[] stringArray, int n) {
        if (stringArray == null) {
            return new String[n];
        }
        if (stringArray.length >= n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String string) {
        this.compression = string;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("stream");
        if (this.compression != null && !this.compression.equals("")) {
            element.setAttribute("compression", this.compression);
        }
        if (!this.properties.isEmpty()) {
            Element element2 = StreamTool.processPropertiesMap(document, this.properties);
            element.appendChild(element2);
        }
        return element;
    }

    public Object clone() {
        try {
            StreamDescriptor streamDescriptor = (StreamDescriptor)super.clone();
            streamDescriptor.properties = new HashMap(this.properties);
            return streamDescriptor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

