/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Units;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public final class PropertyType {
    private static final Map map = new HashMap();
    public static final PropertyType DOUBLE = new PropertyType("double");
    public static final PropertyType DOUBLE_ARRAY = new PropertyType("doubleArray");
    public static final PropertyType DATUM = new PropertyType("Datum");
    public static final PropertyType INTEGER = new PropertyType("int");
    private final String name;

    public static PropertyType getByName(String string) {
        PropertyType propertyType = (PropertyType)map.get(string);
        if (propertyType == null) {
            throw new IllegalArgumentException("Unrecognized property type: " + string);
        }
        return propertyType;
    }

    private PropertyType(String string) {
        this.name = string;
        map.put(string, this);
    }

    public Object parse(String string) throws ParseException {
        if (this.name.equals("double")) {
            try {
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        }
        if (this.name.equals("int")) {
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        }
        if (this.name.equals("doubleArray")) {
            try {
                String[] stringArray = string.split(",");
                double[] dArray = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                }
                return dArray;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        }
        if (this.name.equals("Datum")) {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length == 1) {
                return Units.dimensionless.parse(stringArray[0]);
            }
            if (stringArray.length == 2) {
                Units units = Units.getByName(stringArray[1]);
                return units.parse(stringArray[0]);
            }
            throw new IllegalArgumentException("Too many tokens: '" + string + "'");
        }
        throw new IllegalStateException("unrecognized name: " + this.name);
    }

    public String toString() {
        return this.name;
    }
}

