/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PacketDescriptor
implements Cloneable {
    private StreamXDescriptor xDescriptor;
    private SkeletonDescriptor[] yDescriptors = new SkeletonDescriptor[6];
    private int yCount = 0;
    private Map properties;
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");

    public PacketDescriptor(Element element) {
        this.properties = new HashMap();
        if (element.getTagName().equals("packet")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals("x")) {
                this.xDescriptor = new StreamXDescriptor(element2);
                continue;
            }
            if (string.equals("y")) {
                object = new StreamMultiYDescriptor(element2);
                this.addYDescriptor((SkeletonDescriptor)object);
                continue;
            }
            if (string.equals("yscan")) {
                object = new StreamYScanDescriptor(element2);
                this.addYDescriptor((SkeletonDescriptor)object);
                continue;
            }
            if (!string.equals("properties")) continue;
            try {
                object = element.getElementsByTagName("properties");
                if (object.getLength() == 0) continue;
                Element element3 = (Element)object.item(0);
                Map map = StreamTool.processPropertiesElement(element3);
                this.properties.putAll(map);
                continue;
            }
            catch (StreamException streamException) {
                throw new RuntimeException(streamException);
            }
        }
    }

    private void processLegacyElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SkeletonDescriptor skeletonDescriptor;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals("X")) {
                this.xDescriptor = new StreamXDescriptor(element2);
                continue;
            }
            if (string.equals("YScan")) {
                skeletonDescriptor = new StreamYScanDescriptor(element2);
                this.addYDescriptor(skeletonDescriptor);
                continue;
            }
            if (!string.equals("MultiY")) continue;
            skeletonDescriptor = new StreamMultiYDescriptor(element2);
            this.addYDescriptor(skeletonDescriptor);
        }
    }

    public PacketDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor streamXDescriptor) {
        this.xDescriptor = streamXDescriptor;
    }

    public void addYDescriptor(SkeletonDescriptor skeletonDescriptor) {
        if (this.yCount == this.yDescriptors.length) {
            SkeletonDescriptor[] skeletonDescriptorArray = new SkeletonDescriptor[this.yCount * 2];
            System.arraycopy(this.yDescriptors, 0, skeletonDescriptorArray, 0, this.yCount);
            this.yDescriptors = skeletonDescriptorArray;
        }
        this.yDescriptors[this.yCount] = skeletonDescriptor;
        ++this.yCount;
    }

    public int getYCount() {
        return this.yCount;
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(this.yDescriptors).subList(0, this.yCount));
    }

    public SkeletonDescriptor getYDescriptor(int n) {
        if (n < 0 || n >= this.yCount) {
            throw new IndexOutOfBoundsException("index = " + n + ", yCount = " + this.yCount);
        }
        return this.yDescriptors[n];
    }

    public int getSizeBytes() {
        int n = this.xDescriptor.getSizeBytes();
        for (int i = 0; i < this.yCount; ++i) {
            n += this.yDescriptors[i].getSizeBytes();
        }
        return n;
    }

    public DatumVector[] read(ByteBuffer byteBuffer) {
        DatumVector[] datumVectorArray = new DatumVector[this.yCount + 1];
        datumVectorArray[0] = this.xDescriptor.read(byteBuffer);
        for (int i = 0; i < this.yCount; ++i) {
            datumVectorArray[i + 1] = this.yDescriptors[i].read(byteBuffer);
        }
        return datumVectorArray;
    }

    public void write(Datum datum, DatumVector[] datumVectorArray, ByteBuffer byteBuffer) {
        this.xDescriptor.writeDatum(datum, byteBuffer);
        for (int i = 0; i < this.yCount; ++i) {
            this.yDescriptors[i].write(datumVectorArray[i], byteBuffer);
        }
        if (this.yDescriptors[this.yCount - 1] instanceof StreamYScanDescriptor && ((StreamYScanDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)byteBuffer.get(byteBuffer.position() - 1))) {
            byteBuffer.put(byteBuffer.position() - 1, (byte)10);
        } else if (this.yDescriptors[this.yCount - 1] instanceof StreamMultiYDescriptor && ((StreamMultiYDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)byteBuffer.get(byteBuffer.position() - 1))) {
            byteBuffer.put(byteBuffer.position() - 1, (byte)10);
        }
    }

    private static String trimComment(String string) {
        int n = string.indexOf(59);
        if (n == 0) {
            return "";
        }
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static PacketDescriptor createLegacyPacketDescriptor(Map map) {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setXDescriptor(new StreamXDescriptor());
        if (map.get("form").equals("x_tagged_y_scan")) {
            StreamYScanDescriptor streamYScanDescriptor = new StreamYScanDescriptor();
            streamYScanDescriptor.setYCoordinates((double[])map.get("y_coordinate"));
            packetDescriptor.addYDescriptor(streamYScanDescriptor);
        } else if (map.get("form").equals("x_multi_y") && map.get("ny") != null) {
            StreamMultiYDescriptor streamMultiYDescriptor = new StreamMultiYDescriptor();
            packetDescriptor.addYDescriptor(streamMultiYDescriptor);
        } else if (map.get("form").equals("x_multi_y") && map.get("items") != null) {
            List list = (List)map.get("plane-list");
            packetDescriptor.addYDescriptor(new StreamMultiYDescriptor());
            for (int i = 0; i < list.size(); ++i) {
                StreamMultiYDescriptor streamMultiYDescriptor = new StreamMultiYDescriptor();
                streamMultiYDescriptor.setName((String)list.get(i));
                packetDescriptor.addYDescriptor(streamMultiYDescriptor);
            }
        }
        return packetDescriptor;
    }

    private static String[] ensureCapacity(String[] stringArray, int n) {
        if (stringArray == null) {
            return new String[n];
        }
        if (stringArray.length >= n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("packet");
        element.appendChild(this.xDescriptor.getDOMElement(document));
        for (int i = 0; i < this.yCount; ++i) {
            element.appendChild(this.yDescriptors[i].getDOMElement(document));
        }
        return element;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object clone() {
        try {
            PacketDescriptor packetDescriptor = (PacketDescriptor)super.clone();
            packetDescriptor.xDescriptor = (StreamXDescriptor)this.xDescriptor.clone();
            packetDescriptor.yDescriptors = new SkeletonDescriptor[this.yCount];
            for (int i = 0; i < this.yCount; ++i) {
                packetDescriptor.yDescriptors[i] = (SkeletonDescriptor)this.yDescriptors[i].clone();
            }
            return packetDescriptor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        String string = "<packet>\n";
        for (int i = 0; i < this.yCount; ++i) {
            string = string + this.yDescriptors[i].toString() + "\n";
        }
        string = string + "</packet>\n";
        return string;
    }
}

