/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTransferType {
    private static final int I_SUN_REAL4 = 0;
    private static final int I_SUN_REAL8 = 1;
    private static final int I_ASCII = 2;
    private static final int I_TIME = 3;
    private static final Map map = new HashMap();
    public static final DataTransferType SUN_REAL4 = new DataTransferType("sun_real4", 0, 4, false);
    public static final DataTransferType SUN_REAL8 = new DataTransferType("sun_real8", 1, 8, false);
    private static final Pattern ASCII_PATTERN = Pattern.compile("ascii([1-9][0-9]?)");
    private static final Pattern TIME_PATTERN = Pattern.compile("time([1-9][0-9]?)");
    private final String name;
    private final int sizeBytes;
    private final boolean ascii;
    private final int id;
    private DecimalFormat doubleFormatter;
    private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;

    private DataTransferType(String string, int n, int n2, boolean bl) {
        this.name = string;
        this.id = n;
        this.sizeBytes = n2;
        this.ascii = bl;
        map.put(string, this);
        if (bl) {
            this.doubleFormatter = new DecimalFormat(DataTransferType.getFormat(n2 - 1));
        }
    }

    public String toString() {
        return this.name;
    }

    public int getSizeBytes() {
        return this.sizeBytes;
    }

    public static DataTransferType getByName(String string) {
        DataTransferType dataTransferType = (DataTransferType)map.get(string);
        if (dataTransferType == null) {
            Matcher matcher = ASCII_PATTERN.matcher(string);
            if (matcher.matches()) {
                int n = Integer.parseInt(matcher.group(1));
                dataTransferType = new DataTransferType(string, 2, n, true);
                map.put(string, dataTransferType);
            } else {
                matcher = TIME_PATTERN.matcher(string);
                if (matcher.matches()) {
                    int n = Integer.parseInt(matcher.group(1));
                    dataTransferType = new Time(n);
                    map.put(string, dataTransferType);
                } else {
                    throw new RuntimeException("Unsupported type: " + string);
                }
            }
        }
        return dataTransferType;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public double read(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        try {
            double d;
            switch (this.id) {
                case 0: {
                    byteBuffer.order(BIG_ENDIAN);
                    d = byteBuffer.getFloat();
                    break;
                }
                case 1: {
                    byteBuffer.order(BIG_ENDIAN);
                    d = byteBuffer.getDouble();
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[this.sizeBytes];
                    byteBuffer.get(byArray);
                    String string = new String(byArray, "ASCII").trim();
                    d = Double.parseDouble(string);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid id: " + this.id);
                }
            }
            double d2 = d;
            return d2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(double d, ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        try {
            switch (this.id) {
                case 0: {
                    byteBuffer.order(BIG_ENDIAN);
                    byteBuffer.putFloat((float)d);
                    return;
                }
                case 1: {
                    byteBuffer.order(BIG_ENDIAN);
                    byteBuffer.putDouble(d);
                    return;
                }
                case 2: {
                    String string = this.doubleFormatter.format(d) + " ";
                    if (this.sizeBytes < 10) {
                        string = FixedWidthFormatter.format(string, this.sizeBytes - 1);
                    }
                    byte[] byArray = string.getBytes("US-ASCII");
                    byteBuffer.put(byArray);
                    return;
                }
                default: {
                    throw new IllegalStateException("Invalid id: " + this.id);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    private static String getFormat(int n) {
        if (n < 9) {
            return "0.#";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("+0.");
        for (int i = 0; i < n - 7; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append("E00;-#");
        return stringBuffer.toString();
    }

    static class Time
    extends DataTransferType {
        Units units;
        TimeDatumFormatter formatter;
        int sizeBytes;

        Time(int n) {
            super("time" + n, 3, n, true);
            this.sizeBytes = n;
            this.units = Units.us2000;
            this.formatter = TimeDatumFormatter.DEFAULT;
        }

        public Units getUnits() {
            return this.units;
        }

        public double read(ByteBuffer byteBuffer) {
            try {
                byte[] byArray = new byte[this.sizeBytes];
                byteBuffer.get(byArray);
                String string = new String(byArray, "ASCII").trim();
                double d = TimeUtil.create(string).doubleValue(this.units);
                return d;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }

        public void write(double d, ByteBuffer byteBuffer) {
            try {
                String string = this.formatter.format(this.units.createDatum(d));
                string = string.substring(0, this.sizeBytes);
                byte[] byArray = string.getBytes("US-ASCII");
                byArray[this.sizeBytes - 1] = 32;
                byteBuffer.put(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }
}

