/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph.dnd;

import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TransferableCanvasComponent
implements Transferable {
    public static final DataFlavor CANVAS_COMPONENT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasCanvasComponent");
    public static final DataFlavor AXIS_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasAxis");
    public static final DataFlavor PLOT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasPlot");
    public static final DataFlavor COLORBAR_FLAVOR = TransferableCanvasComponent.localJVMFlavor("edu.uiowa.physics.pw.das.graph.DasColorBar");
    private List flavorList;
    private DasCanvasComponent component;

    private static DataFlavor localJVMFlavor(String string) {
        try {
            String string2 = "application/x-java-jvm-local-objectref";
            return new DataFlavor(string2 + ";class=" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public TransferableCanvasComponent(DasAxis dasAxis) {
        this.flavorList = Arrays.asList(AXIS_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = dasAxis;
    }

    public TransferableCanvasComponent(DasPlot dasPlot) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = dasPlot;
    }

    public TransferableCanvasComponent(DasColorBar dasColorBar) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = dasColorBar;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.component;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavorList.toArray(new DataFlavor[this.flavorList.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavorList.contains(dataFlavor);
    }
}

