/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph.dnd;

import edu.uiowa.physics.pw.das.graph.DasCanvas;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class TransferableCanvas
implements Transferable {
    public static final DataFlavor CANVAS_FLAVOR;
    private DasCanvas canvas;

    public TransferableCanvas(DasCanvas dasCanvas) {
        this.canvas = dasCanvas;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(CANVAS_FLAVOR)) {
            return this.canvas;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                document.appendChild(this.canvas.getDOMElement(document));
                StringWriter stringWriter = new StringWriter();
                OutputFormat outputFormat = new OutputFormat("xml", "UTF-8", true);
                outputFormat.setOmitXMLDeclaration(true);
                outputFormat.setOmitDocumentType(true);
                XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
                xMLSerializer.serialize(document);
                return stringWriter.toString();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CANVAS_FLAVOR, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(CANVAS_FLAVOR) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    static {
        try {
            String string = "application/x-java-jvm-local-objectref;class=edu.uiowa.physics.pw.das.graph.DasCanvas";
            CANVAS_FLAVOR = new DataFlavor(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

