/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.CancelledOperationException;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DataLoader;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class XAxisDataLoader
extends DataLoader
implements DataSetUpdateListener {
    DasAxis xaxis;
    DataSetDescriptor dsd;
    DasProgressMonitor progressMonitor;
    Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG, "XAxisDataLoader");
    DataLoader.Request currentRequest;
    List unsolicitedRequests;
    Object lockObject = new Object();
    private boolean fullResolution = false;

    public XAxisDataLoader(Renderer renderer, DataSetDescriptor dataSetDescriptor) {
        super(renderer);
        this.dsd = dataSetDescriptor;
        this.logger = this.logger;
        if (dataSetDescriptor != null) {
            dataSetDescriptor.addDataSetUpdateListener(this);
        }
        this.unsolicitedRequests = new ArrayList();
    }

    public void update() {
        if (this.isActive()) {
            this.logger.finer("enter XAxisDataLoader.update");
            DasPlot dasPlot = this.getRenderer().getParent();
            if (dasPlot == null) {
                this.logger.fine("plot is null, no need to load");
            } else {
                DasAxis dasAxis = dasPlot.getXAxis();
                DasAxis dasAxis2 = dasPlot.getYAxis();
                this.loadDataSet(dasAxis, dasAxis2);
            }
        } else {
            this.logger.finer("enter XAxisDataLoader.update, ignored not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSet(DasAxis dasAxis, DasAxis dasAxis2) {
        this.logger.fine("render requests dataset for x:" + dasAxis.getMemento() + " y:" + dasAxis2.getMemento());
        if (this.xaxis == null) {
            this.xaxis = dasAxis;
        }
        if (this.xaxis.getColumn() == DasColumn.NULL) {
            this.logger.fine("column not set yet");
            return;
        }
        if (this.dsd == null) {
            this.logger.fine("dsd is null, nothing to do");
            return;
        }
        Object object = this.lockObject;
        synchronized (object) {
            Object object2;
            Object object3;
            if (this.currentRequest != null) {
                object3 = this.currentRequest;
                synchronized (object3) {
                    if (dasAxis.getMemento().equals(this.currentRequest.xmem)) {
                        this.logger.fine("ignore repeat request");
                        return;
                    }
                    this.logger.fine("cancel old request: " + this.currentRequest);
                    object2 = this.currentRequest.monitor;
                    this.currentRequest = null;
                    object2.cancel();
                }
            }
            object2 = dasAxis.getDataMaximum().subtract(dasAxis.getDataMinimum());
            double d = Math.floor((double)dasAxis.getColumn().getDMaximum() + 0.5) - Math.floor((double)dasAxis.getColumn().getDMinimum() + 0.5);
            object3 = this.isFullResolution() ? null : ((Datum)object2).divide(d);
            if (d == 0.0) {
                return;
            }
            DasPlot dasPlot = this.renderer.getParent();
            DatumRange datumRange = dasAxis.getDatumRange();
            CacheTag cacheTag = new CacheTag(datumRange, (Datum)object3);
            if (this.dsd.getDataSetCache().haveStored(this.dsd, cacheTag)) {
                this.renderer.setDataSet(this.dsd.getDataSetCache().retrieve(this.dsd, cacheTag));
                this.currentRequest = null;
            } else {
                this.progressMonitor = this.getMonitor("dsd.requestDataSet " + this.dsd + ":" + datumRange + " @ " + (object3 == null ? "intrinsic" : "" + DatumUtil.asOrderOneUnits((Datum)object3)));
                dasPlot.repaint(0, 0, dasPlot.getWidth(), dasPlot.getHeight());
                this.logger.info("request data from dsd: " + datumRange + " @ " + object3);
                this.currentRequest = new DataLoader.Request(this.progressMonitor, dasAxis.getMemento(), dasAxis2.getMemento());
                this.dsd.requestDataSet(datumRange.min(), datumRange.max(), (Datum)object3, this.progressMonitor, dasPlot.getCanvas());
            }
        }
    }

    private boolean rendererHandlesException(Exception exception) {
        boolean bl;
        boolean bl2 = bl = exception instanceof InterruptedIOException || exception instanceof NoDataInIntervalException || exception instanceof StreamException || exception instanceof CancelledOperationException;
        if (!bl) {
            bl = exception.getCause() instanceof InterruptedIOException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.renderer.getDataLoader() != this) {
                return;
            }
            this.logger.fine("got dataset update:" + dataSetUpdateEvent);
            if (dataSetUpdateEvent.getException() != null && dataSetUpdateEvent.getDataSet() != null) {
                throw new IllegalStateException("both exception and data set");
            }
            if (dataSetUpdateEvent.getException() != null) {
                this.logger.fine("got dataset update exception: " + dataSetUpdateEvent.getException());
                Exception exception = dataSetUpdateEvent.getException();
                if (!this.rendererHandlesException(exception)) {
                    DasExceptionHandler.handle(exception);
                }
                DasProgressMonitor dasProgressMonitor = dataSetUpdateEvent.getMonitor();
                if (this.currentRequest != null) {
                    if (dasProgressMonitor == null || dasProgressMonitor == this.currentRequest.monitor) {
                        this.renderer.setException(exception);
                        this.renderer.setDataSet(null);
                        this.logger.fine("current request completed w/exception: " + this.currentRequest);
                        this.currentRequest = null;
                    } else {
                        this.logger.fine("got exception but not for currentRequest ");
                    }
                } else {
                    this.logger.fine("got exception but currentRequest ");
                }
                if (!this.rendererHandlesException(exception)) {
                    DasExceptionHandler.handle(exception);
                }
            } else {
                if (dataSetUpdateEvent.getDataSet() == null) {
                    this.logger.fine("got dataset update notification (no dataset).");
                    this.loadDataSet(this.renderer.getParent().getXAxis(), this.renderer.getParent().getYAxis());
                    return;
                }
                if (this.currentRequest == null) {
                    this.logger.fine("ignore update w/dataset, currentRequest=null");
                } else {
                    DataSet dataSet = dataSetUpdateEvent.getDataSet();
                    DasProgressMonitor dasProgressMonitor = dataSetUpdateEvent.getMonitor();
                    if (dasProgressMonitor == null || this.currentRequest.monitor == dasProgressMonitor) {
                        this.logger.fine("got dataset update w/dataset: " + dataSet);
                        if (dataSet != null) {
                            if (dataSet.getXLength() > 0) {
                                this.logger.fine("  ds range: " + DataSetUtil.xRange(dataSet));
                            } else {
                                this.logger.fine("  ds range: (empty)");
                            }
                        }
                        this.renderer.setDataSet(dataSet);
                        this.logger.fine("current request completed w/dataset: " + this.currentRequest.xmem);
                        this.currentRequest = null;
                    } else {
                        this.logger.fine("got dataset update w/dataset but not my monitor: " + dataSet);
                    }
                }
            }
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.logger.fine("set dsd: " + dataSetDescriptor);
        if (this.dsd != null) {
            this.dsd.removeDataSetUpdateListener(this);
        }
        this.dsd = dataSetDescriptor;
        if (dataSetDescriptor != null) {
            dataSetDescriptor.addDataSetUpdateListener(this);
        }
        this.update();
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dsd;
    }

    public void setReloadDataSet(boolean bl) {
        super.setReloadDataSet(bl);
        this.dsd.reset();
    }

    public boolean isFullResolution() {
        return this.fullResolution;
    }

    public void setFullResolution(boolean bl) {
        if (this.fullResolution == bl) {
            return;
        }
        this.fullResolution = bl;
    }

    public DataLoader.Request getCurrentRequest() {
        return this.currentRequest;
    }

    public DataLoader.Request[] getUnsolicitedRequests() {
        return this.unsolicitedRequests.toArray(new DataLoader.Request[this.unsolicitedRequests.size()]);
    }

    public DataLoader.Request getUnsolicitedRequests(int n) {
        return (DataLoader.Request)this.unsolicitedRequests.get(n);
    }
}

