/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.ArrayList;

public class TickVDescriptor {
    DatumVector tickV;
    DatumVector minorTickV;
    Units units = null;
    DatumFormatter datumFormatter;
    private static final DatumFormatter DEFAULT_LOG_FORMATTER;

    protected TickVDescriptor() {
    }

    public TickVDescriptor(double[] dArray, double[] dArray2, Units units) {
        this.tickV = DatumVector.newDatumVector(dArray2, units);
        this.minorTickV = DatumVector.newDatumVector(dArray, units);
        this.units = units;
        this.datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    }

    public static TickVDescriptor newTickVDescriptor(DatumVector datumVector, DatumVector datumVector2) {
        Units units = datumVector.getUnits();
        double[] dArray = datumVector2.toDoubleArray(units);
        double[] dArray2 = datumVector.toDoubleArray(units);
        return new TickVDescriptor(dArray, dArray2, units);
    }

    public DatumVector getMajorTicks() {
        return this.tickV;
    }

    public DatumVector getMinorTicks() {
        return this.minorTickV;
    }

    public DatumFormatter getFormatter() {
        return this.datumFormatter;
    }

    public Datum findTick(Datum datum, double d, boolean bl) {
        int n;
        if (this.tickV == null) {
            return datum;
        }
        int n2 = this.tickV.getLength();
        int n3 = this.minorTickV.getLength();
        double[] dArray = new double[n2 + n3];
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.tickV.doubleValue(n, this.units);
        }
        for (n = 0; n < n3; ++n) {
            dArray[n + n2] = this.minorTickV.doubleValue(n, this.units);
        }
        n = 0;
        double d2 = Double.MAX_VALUE;
        double d3 = datum.doubleValue(this.units);
        for (int i = 0; i < dArray.length; ++i) {
            if (d < 0.0 && dArray[i] < d3 && d3 - dArray[i] < d2) {
                n = i;
                d2 = d3 - dArray[i];
            } else if (d > 0.0 && d3 < dArray[i] && dArray[i] - d3 < d2) {
                n = i;
                d2 = dArray[i] - d3;
            }
            if (d != 0.0 || !(Math.abs(dArray[i] - d3) < d2)) continue;
            n = i;
            d2 = Math.abs(dArray[i] - d3);
        }
        return Datum.create(dArray[n], this.units);
    }

    public DatumRange enclosingRange(DatumRange datumRange, boolean bl) {
        Datum datum;
        Datum datum2 = this.findTick(datumRange.min(), 0.0, bl);
        if (datum2.equals(datum = this.findTick(datumRange.max(), 0.0, bl))) {
            datum2 = this.findTick(datumRange.min(), -1.0, true);
            datum = this.findTick(datumRange.max(), 1.0, true);
        }
        return new DatumRange(datum2, datum);
    }

    public void setFormatter(DatumFormatter datumFormatter) {
        this.datumFormatter = datumFormatter;
    }

    public String toString() {
        String string = "tickV=" + this.getMajorTicks();
        string = string + ",minor=" + this.getMinorTicks();
        return string;
    }

    public static TickVDescriptor bestTickVLinear(Datum datum, Datum datum2, int n, int n2) {
        int n3;
        double d;
        int n4;
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        tickVDescriptor.units = datum.getUnits();
        double d2 = datum.doubleValue(tickVDescriptor.units);
        double d3 = datum2.doubleValue(tickVDescriptor.units);
        double d4 = (d3 - d2) / (double)(n4 = Math.max(Math.min(6, n2), n));
        double d5 = d4 / (d = DasMath.exp10(Math.floor(DasMath.log10(d4))));
        d5 = d5 < 1.666 ? 1.0 : (d5 < 3.333 ? 2.0 : 5.0);
        double d6 = d3 - d2;
        int n5 = d5 == 5.0 ? 5 : (d5 == 2.0 ? 2 : 4);
        double d7 = d5 * d / (double)n5;
        double d8 = d7 * (double)n5;
        double d9 = d8 * Math.ceil((d2 - d6) / d8 - 0.01);
        double d10 = d8 * Math.floor((d3 + d6) / d8 + 0.01);
        int n6 = 1 + (int)Math.round((d10 - d9) / d8);
        double[] dArray = new double[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            dArray[n3] = d9 + (double)(n3 * n5) * d7;
        }
        tickVDescriptor.tickV = DatumVector.newDatumVector(dArray, tickVDescriptor.units);
        n3 = n6 / 3;
        int n7 = 2 * n6 / 3;
        tickVDescriptor.datumFormatter = DatumUtil.bestFormatter(tickVDescriptor.units.createDatum(dArray[n3]), tickVDescriptor.units.createDatum(dArray[n7]), n7 - n3);
        double d11 = d9;
        double d12 = d10;
        int n8 = (int)((d12 - d11) / d7 + 0.5);
        double[] dArray2 = new double[n8];
        for (int i = 0; i < n8; ++i) {
            dArray2[i] = d11 + (double)i * d7;
        }
        tickVDescriptor.minorTickV = DatumVector.newDatumVector(dArray2, tickVDescriptor.units);
        return tickVDescriptor;
    }

    public static TickVDescriptor bestTickVLogNew(Datum datum, Datum datum2, int n, int n2) {
        int n3;
        int n4;
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        tickVDescriptor.units = datum.getUnits();
        double d = datum.doubleValue(tickVDescriptor.units);
        double d2 = datum2.doubleValue(tickVDescriptor.units);
        if (d2 <= 0.0) {
            d2 = 100.0;
        }
        if (d <= 0.0) {
            d = d2 / 1000.0;
        }
        double d3 = DasMath.log10(d);
        double d4 = DasMath.log10(d2);
        int n5 = (int)(Math.floor(d4 * 0.999) - Math.ceil(d3 * 1.001) + 1.0);
        if (n5 < 2) {
            return TickVDescriptor.bestTickVLinear(datum, datum2, n, n2);
        }
        if (n5 > n2) {
            double[] dArray;
            int n6;
            Units units = datum.getUnits();
            Datum datum3 = units.createDatum(DasMath.log10(d));
            Datum datum4 = units.createDatum(DasMath.log10(d2));
            TickVDescriptor tickVDescriptor2 = TickVDescriptor.bestTickVLinear(datum3, datum4, n, n2);
            double[] dArray2 = tickVDescriptor2.tickV.toDoubleArray(tickVDescriptor2.units);
            int n7 = 0;
            for (int i = 0; i < dArray2.length; ++i) {
                if (dArray2[i] % 1.0 != 0.0) continue;
                dArray2[n7++] = DasMath.exp10(dArray2[i]);
            }
            double[] dArray3 = dArray2;
            dArray2 = new double[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                dArray2[n6] = dArray3[n6];
            }
            n6 = 0;
            if (dArray2[1] / dArray2[0] <= 10.00001) {
                int n8;
                dArray = new double[(dArray2.length + 1) * 9];
                for (n8 = 2; n8 < 10; ++n8) {
                    dArray[n6++] = (double)n8 * (dArray2[0] / 10.0);
                }
                for (n8 = 0; n8 < dArray2.length; ++n8) {
                    for (int i = 2; i < 10; ++i) {
                        dArray[n6++] = (double)i * dArray2[n8];
                    }
                }
            } else {
                dArray = tickVDescriptor2.minorTickV.toDoubleArray(tickVDescriptor2.units);
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = DasMath.exp10(dArray[i]);
                }
            }
            tickVDescriptor2.tickV = DatumVector.newDatumVector(dArray2, tickVDescriptor2.units);
            tickVDescriptor2.minorTickV = DatumVector.newDatumVector(dArray, tickVDescriptor2.units);
            tickVDescriptor2.datumFormatter = DEFAULT_LOG_FORMATTER;
            return tickVDescriptor2;
        }
        double d5 = d / (d2 / d);
        double d6 = d2 * (d2 / d);
        double d7 = DasMath.roundNFractionalDigits(DasMath.log10(d5), 4);
        int n9 = (int)Math.ceil(d7);
        double d8 = DasMath.roundNFractionalDigits(DasMath.log10(d6), 4);
        int n10 = (int)Math.floor(d8);
        int n11 = n10 - n9 + 1;
        double[] dArray = new double[n11];
        for (n4 = 0; n4 < n11; ++n4) {
            dArray[n4] = n4 + n9;
        }
        double[] dArray4 = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        tickVDescriptor.datumFormatter = DEFAULT_LOG_FORMATTER;
        n4 = (int)Math.floor(DasMath.log10(d5));
        int n12 = (int)Math.floor(DasMath.log10(d6));
        double[] dArray5 = null;
        int n13 = 0;
        dArray5 = new double[(n12 - n4 + 1) * dArray4.length];
        for (n3 = n4; n3 <= n12; ++n3) {
            for (int i = 0; i < dArray4.length; ++i) {
                dArray5[n13++] = DasMath.exp10(n3) * dArray4[i];
            }
        }
        tickVDescriptor.minorTickV = DatumVector.newDatumVector(dArray5, tickVDescriptor.units);
        for (n3 = 0; n3 < dArray.length; ++n3) {
            dArray[n3] = DasMath.exp10(dArray[n3]);
        }
        tickVDescriptor.tickV = DatumVector.newDatumVector(dArray, tickVDescriptor.units);
        return tickVDescriptor;
    }

    public static TickVDescriptor bestTickVTime(Datum datum, Datum datum2, int n, int n2) {
        int n3;
        DatumFormatter datumFormatter;
        double[] dArray;
        int n4;
        double[] dArray2;
        int n5;
        double d;
        double d2;
        double d3;
        Datum datum3 = datum2.subtract(datum);
        Datum datum4 = Datum.create(60.0, Units.seconds);
        if (datum2.subtract(datum).lt(datum4)) {
            Datum datum5 = TimeUtil.prevMidnight(datum);
            Units units = Units.seconds;
            Datum datum6 = datum.subtract(datum5).convertTo(units);
            Datum datum7 = datum2.subtract(datum5).convertTo(units);
            TickVDescriptor tickVDescriptor = TickVDescriptor.bestTickVLinear(datum6, datum7, n, n2);
            DatumVector datumVector = tickVDescriptor.getMinorTicks().add(datum5);
            DatumVector datumVector2 = tickVDescriptor.getMajorTicks().add(datum5);
            TickVDescriptor tickVDescriptor2 = TickVDescriptor.newTickVDescriptor(datumVector2, datumVector);
            tickVDescriptor2.datumFormatter = DatumUtil.bestFormatter(datumVector2);
            return tickVDescriptor2;
        }
        if (datum2.subtract(datum).gt(Datum.create(3650, Units.days))) {
            int n6;
            int n7;
            int n8 = TimeUtil.toTimeStruct((Datum)datum).year;
            int n9 = TimeUtil.toTimeStruct((Datum)datum2).year;
            TickVDescriptor tickVDescriptor = TickVDescriptor.bestTickVLinear(Units.dimensionless.createDatum(n8), Units.dimensionless.createDatum(n9), n, n2);
            tickVDescriptor.units = datum.getUnits();
            double[] dArray3 = tickVDescriptor.tickV.toDoubleArray(Units.dimensionless);
            for (int i = 0; i < dArray3.length; ++i) {
                n7 = (int)dArray3[i];
                dArray3[i] = TimeUtil.convert(n7, 1, 1, 0, 0, 0.0, (TimeLocationUnits)tickVDescriptor.units);
            }
            tickVDescriptor.tickV = DatumVector.newDatumVector(dArray3, tickVDescriptor.units);
            double[] dArray4 = tickVDescriptor.minorTickV.toDoubleArray(Units.dimensionless);
            for (n7 = 0; n7 < dArray4.length; ++n7) {
                n6 = (int)dArray4[n7];
                dArray4[n7] = TimeUtil.convert(n6, 1, 1, 0, 0, 0.0, (TimeLocationUnits)tickVDescriptor.units);
            }
            tickVDescriptor.minorTickV = DatumVector.newDatumVector(dArray4, tickVDescriptor.units);
            Datum datum8 = tickVDescriptor.getMajorTicks().get(0);
            n6 = tickVDescriptor.getMajorTicks().getLength();
            Datum datum9 = tickVDescriptor.getMajorTicks().get(n6 - 1);
            tickVDescriptor.datumFormatter = DatumUtil.bestTimeFormatter(datum8, datum9, n6);
            return tickVDescriptor;
        }
        double d4 = datum.doubleValue(Units.t2000);
        double d5 = datum2.doubleValue(Units.t2000);
        double[] dArray5 = new double[]{0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 30.0, 60.0, 120.0, 300.0, 600.0, 1200.0, 3600.0, 7200.0, 10800.0, 14400.0, 21600.0, 28800.0, 43200.0, 86400.0, 172800.0, 432000.0, 864000.0};
        int[] nArray = new int[]{4, 4, 5, 4, 4, 5, 4, 4, 5, 4, 4, 5, 5, 3, 6, 4, 5, 5, 4, 4, 4, 3, 4, 3, 4, 6, 4, 2, 5, 10};
        double d6 = -1.0;
        int n10 = 0;
        int n11 = -1;
        if (d5 - d4 > 86400.0) {
            n10 = 4;
        }
        while (n10 < dArray5.length && n11 == -1) {
            double d7;
            d3 = d7 = dArray5[n10];
            d2 = d3 * Math.ceil(d4 / d3);
            d = d3 * Math.floor(d5 / d3);
            n5 = (d - d2) / d3 > 1000.0 ? 1000 : 1 + (int)((d - d2) / d3);
            if (n5 < n2) {
                n11 = n10;
            }
            ++n10;
        }
        if (n11 != -1) {
            Datum datum10;
            double d8;
            d6 = dArray5[n11];
            double d9 = 1.0;
            d3 = d9 * d6;
            double d10 = d5 - d4;
            d2 = d3 * Math.ceil((d4 - d10) / d3);
            d = d3 * Math.floor((d5 + d10) / d3);
            if (d3 > 86400.0) {
                d8 = 86400.0;
                d2 = d8 * Math.ceil(d4 / d8);
                d2 -= d3 * 6.0;
                d = d8 * Math.floor((d5 + d10) / d8);
            }
            if ((n5 = 1 + (int)Math.round((d - d2) / d3)) < 2) {
                DasDie.println("Only able to find one major tick--sorry! ");
                DasDie.println("please let us know how you entered this condition");
                n5 = 2;
            }
            dArray2 = new double[n5];
            for (n10 = 0; n10 < n5; ++n10) {
                dArray2[n10] = d2 + (double)n10 * d3;
            }
            double d11 = d3 / (double)nArray[n11];
            d8 = d11 * Math.ceil((d4 - d10) / d11);
            double d12 = d11 * Math.floor((d5 + d10) / d11);
            n4 = (int)((d12 - d8) / d11 + 0.5);
            double[] dArray6 = new double[n4];
            for (int i = 0; i < n4; ++i) {
                dArray6[i] = d8 + (double)i * d11;
            }
            dArray = dArray6;
            Datum datum11 = Units.t2000.createDatum(d2);
            datumFormatter = DatumUtil.bestFormatter(datum11, datum10 = Units.t2000.createDatum(d), n5 - 1);
            if (datumFormatter == TimeDatumFormatter.HOURS) {
                datumFormatter = TimeDatumFormatter.MINUTES;
            }
        } else {
            int n12;
            int n13;
            double[] dArray7 = new double[30];
            ArrayList<Datum> arrayList = new ArrayList<Datum>();
            int n14 = 0;
            Datum datum12 = Datum.create(d4, (Units)Units.t2000);
            Datum datum13 = Datum.create(d5, (Units)Units.t2000);
            int n15 = 1;
            int n16 = 1;
            if (d5 - d4 < 1.5552E7) {
                n4 = 2;
                n13 = 3;
                n16 = 1;
            } else if (d5 - d4 < 6.48E7) {
                n4 = 98;
                n13 = 2;
            } else if (d5 - d4 < 1.89216E8) {
                n4 = 1;
                n13 = 2;
            } else {
                n4 = 1;
                n13 = 1;
                n15 = 2;
            }
            Datum datum14 = TimeUtil.prev(n4, TimeUtil.prev(n4, datum12));
            Datum datum15 = TimeUtil.next(n4, TimeUtil.next(n4, datum13));
            Datum datum16 = datum14;
            while (datum15.ge(datum16)) {
                dArray7[n14++] = datum16.doubleValue(Units.t2000);
                datum16 = TimeUtil.next(n4, datum16);
                for (n12 = n15; n12 > 1; --n12) {
                    datum16 = TimeUtil.next(n4, datum16);
                }
            }
            dArray2 = new double[n14];
            for (n14 = 0; n14 < dArray2.length; ++n14) {
                dArray2[n14] = dArray7[n14];
            }
            datum16 = datum14;
            while (datum15.ge(datum16)) {
                arrayList.add(datum16);
                datum16 = TimeUtil.next(n13, datum16);
                for (n12 = n16; n12 > 1; --n12) {
                    datum16 = TimeUtil.next(n13, datum16);
                }
            }
            dArray = new double[arrayList.size()];
            for (n12 = 0; n12 < arrayList.size(); ++n12) {
                dArray[n12] = ((Datum)arrayList.get(n12)).doubleValue(Units.t2000);
            }
            datumFormatter = DatumUtil.bestFormatter(datum14, datum15, 6);
        }
        Units units = datum.getUnits();
        UnitsConverter unitsConverter = Units.getConverter(Units.t2000, units);
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = unitsConverter.convert(dArray2[n3]);
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            dArray[n3] = unitsConverter.convert(dArray[n3]);
        }
        TickVDescriptor tickVDescriptor = new TickVDescriptor(dArray, dArray2, units);
        tickVDescriptor.setFormatter(datumFormatter);
        return tickVDescriptor;
    }

    static {
        try {
            DatumFormatterFactory datumFormatterFactory = DefaultDatumFormatterFactory.getInstance();
            DEFAULT_LOG_FORMATTER = datumFormatterFactory.newFormatter("0E0");
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }
}

