/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.GrannyTickLabeller;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.TickLabeller;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TickCurveRenderer
extends Renderer {
    private Stroke stroke;
    TickVDescriptor tickv;
    private String xplane;
    private String yplane;
    private VectorDataSet xds;
    private VectorDataSet yds;
    private Units xunits;
    private Units yunits;
    private double[][] idata;
    TickLabeller tickLabeller;
    private TickStyle tickStyle;
    private double lineWidth;
    private float tickLength;

    public TickCurveRenderer(DataSet dataSet, String string, String string2, TickVDescriptor tickVDescriptor) {
        super(dataSet);
        this.setTickStyle(TickStyle.outer);
        this.setLineWidth(1.0);
        this.setTickLength(8.0f);
        this.xplane = string;
        this.yplane = string2;
        this.tickv = tickVDescriptor;
    }

    protected void uninstallRenderer() {
    }

    protected void installRenderer() {
    }

    private static double length(Line2D line2D) {
        double d = line2D.getX2() - line2D.getX1();
        double d2 = line2D.getY2() - line2D.getY1();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }

    private static Line2D normalize(Line2D line2D, double d) {
        Point2D point2D = line2D.getP1();
        double d2 = line2D.getX2() - line2D.getX1();
        double d3 = line2D.getY2() - line2D.getY1();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        Line2D line2D2 = (Line2D)line2D.clone();
        line2D2.setLine(point2D.getX(), point2D.getY(), point2D.getX() + d2 / d4 * d, point2D.getY() + d3 / d4 * d);
        return line2D2;
    }

    private double turnDir(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d5 - d3;
        double d9 = d4 - d2;
        double d10 = d6 - d4;
        return d7 * d10 - d8 * d9;
    }

    private double turnDirAt(double d) {
        int n = this.xds.getXLength();
        int n2 = d < 1.0 ? 0 : (d > (double)(n - 2) ? n - 3 : (int)Math.floor(d) - 1);
        int n3 = n2 + 1;
        int n4 = n3 + 1;
        return this.turnDir(this.xds.getDouble(n2, this.xunits), this.yds.getDouble(n2, this.yunits), this.xds.getDouble(n3, this.xunits), this.yds.getDouble(n3, this.yunits), this.xds.getDouble(n4, this.xunits), this.yds.getDouble(n4, this.yunits));
    }

    private Line2D outsideNormalAt(double d) {
        double d2;
        double d3;
        double d4;
        int n = this.xds.getXLength();
        int n2 = (int)Math.floor(d);
        if (n2 == n - 1) {
            --n2;
        }
        double d5 = this.idata[0][n2];
        double d6 = this.idata[0][n2 + 1];
        double d7 = this.idata[1][n2];
        double d8 = this.idata[1][n2 + 1];
        double d9 = DasMath.interpolate(this.idata[0], d);
        double d10 = DasMath.interpolate(this.idata[1], d);
        double d11 = d6 - d5;
        double d12 = d8 - d7;
        double d13 = this.turnDirAt(d);
        if (d13 * (d4 = -1.0 * (d11 * (d3 = -d11) - (d2 = d12) * d12)) > 0.0) {
            d2 = -d12;
            d3 = d11;
        }
        return TickCurveRenderer.normalize(new Line2D.Double(d9, d10, d9 + d2, d10 + d3), 1.0);
    }

    private void drawTick(Graphics2D graphics2D, double d) {
        float f = this.getTickLength() * 2.0f / 3.0f;
        Line2D line2D = TickCurveRenderer.normalize(this.outsideNormalAt(d), f);
        if (this.tickStyle == TickStyle.both) {
            Line2D line2D2 = TickCurveRenderer.normalize(line2D, -f);
            Line2D.Double double_ = new Line2D.Double(line2D2.getP2(), line2D.getP2());
            graphics2D.draw(double_);
        } else {
            graphics2D.draw(line2D);
        }
    }

    private double slope(Line2D line2D) {
        return (line2D.getY2() - line2D.getY1()) / (line2D.getX2() - line2D.getX1());
    }

    private void drawLabelTick(Graphics2D graphics2D, double d, int n) {
        float f = this.getTickLength();
        Line2D line2D = TickCurveRenderer.normalize(this.outsideNormalAt(d), f);
        if (this.tickStyle == TickStyle.both) {
            Line2D line2D2 = TickCurveRenderer.normalize(line2D, -f);
            Line2D.Double double_ = new Line2D.Double(line2D2.getP2(), line2D.getP2());
            graphics2D.draw(double_);
        } else {
            graphics2D.draw(line2D);
        }
        this.tickLabeller.labelMajorTick(graphics2D, n, line2D);
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        int n;
        int n2;
        if (this.ds == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(Color.black);
        DataSet dataSet = this.getDataSet();
        this.xds = (VectorDataSet)dataSet.getPlanarView(this.xplane);
        this.yds = (VectorDataSet)dataSet.getPlanarView(this.yplane);
        this.xunits = this.xds.getYUnits();
        this.yunits = this.yds.getYUnits();
        this.idata = new double[2][this.xds.getXLength()];
        for (n2 = 0; n2 < this.xds.getXLength(); ++n2) {
            this.idata[0][n2] = dasAxis.transform(this.xds.getDouble(n2, this.xunits), this.xunits);
            this.idata[1][n2] = dasAxis2.transform(this.yds.getDouble(n2, this.yunits), this.yunits);
        }
        for (n2 = 1; n2 < this.xds.getXLength(); ++n2) {
            graphics2D.drawLine((int)this.idata[0][n2 - 1], (int)this.idata[1][n2 - 1], (int)this.idata[0][n2], (int)this.idata[1][n2]);
        }
        double[] dArray = VectorUtil.getXTagArrayDouble(this.xds, this.xds.getXUnits());
        double[] dArray2 = this.tickv.minorTickV.toDoubleArray(this.xds.getXUnits());
        double[] dArray3 = DasMath.findex(dArray, dArray2);
        this.tickLabeller = new GrannyTickLabeller(this.parent);
        this.tickLabeller.init(this.tickv);
        for (n = 0; n < this.tickv.minorTickV.getLength(); ++n) {
            if (!(dArray3[n] >= 0.0) || !(dArray3[n] < (double)dArray.length)) continue;
            this.drawTick(graphics2D, dArray3[n]);
        }
        dArray3 = DasMath.findex(VectorUtil.getXTagArrayDouble(this.xds, this.xds.getXUnits()), this.tickv.tickV.toDoubleArray(this.xds.getXUnits()));
        for (n = 0; n < this.tickv.tickV.getLength(); ++n) {
            if (!(dArray3[n] >= 0.0) || !(dArray3[n] < (double)dArray.length)) continue;
            this.drawLabelTick(graphics2D, dArray3[n], n);
        }
        this.tickLabeller.finished();
    }

    private static String lineToString(Line2D line2D) {
        return "" + line2D.getX1() + " " + line2D.getY1() + " " + line2D.getX2() + " " + line2D.getY2();
    }

    public TickStyle getTickStyle() {
        return this.tickStyle;
    }

    public void setTickStyle(TickStyle tickStyle) {
        this.tickStyle = tickStyle;
        this.invalidateParentCacheImage();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        this.stroke = new BasicStroke((float)d);
        this.invalidateParentCacheImage();
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(float f) {
        this.tickLength = f;
        this.invalidateParentCacheImage();
    }

    protected Element getDOMElement(Document document) {
        throw new UnsupportedOperationException();
    }

    public void setTickVDescriptor(TickVDescriptor tickVDescriptor) {
        this.tickv = tickVDescriptor;
        this.invalidateParentCacheImage();
    }

    public static class TickStyle
    implements Enumeration {
        private String name;
        public static TickStyle outer = new TickStyle("Outer");
        public static TickStyle both = new TickStyle("Both");

        private TickStyle(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

