/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.LengthDragRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SymColor;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolLineRenderer
extends Renderer
implements Displayable {
    private Psym psym = Psym.NONE;
    private double symSize = 1.0;
    private float lineWidth = 1.5f;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    int renderCount = 0;
    int updateImageCount = 0;
    private Color color = Color.BLACK;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private GeneralPath path;
    private Logger log = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);

    public SymbolLineRenderer() {
    }

    public SymbolLineRenderer(DataSet dataSet) {
        super(dataSet);
    }

    public SymbolLineRenderer(DataSetDescriptor dataSetDescriptor) {
        super(dataSetDescriptor);
    }

    private void reportCount() {
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        ++this.renderCount;
        this.reportCount();
        long l = System.currentTimeMillis();
        VectorDataSet vectorDataSet = (VectorDataSet)this.getDataSet();
        if (this.ds == null && this.lastException != null) {
            this.renderException(graphics, dasAxis, dasAxis2, this.lastException);
            return;
        }
        if (vectorDataSet == null || vectorDataSet.getXLength() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("render data set " + vectorDataSet);
        graphics.setColor(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (this.antiAliased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.log.finest("drawing pym in " + this.color);
        if (this.path != null) {
            this.psymConnector.draw(graphics2D, this.path, this.lineWidth);
        }
        Units units = dasAxis.getUnits();
        Units units2 = dasAxis2.getUnits();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            d5 = dasAxis.getDataMaximum().doubleValue(units);
            d4 = dasAxis.getDataMinimum().doubleValue(units);
            d3 = dasAxis2.getDataMaximum().doubleValue(units2);
            d2 = dasAxis2.getDataMinimum().doubleValue(units2);
        } else {
            d4 = dasAxis.invTransform((int)rectangle.getX()).doubleValue(units);
            d5 = dasAxis.invTransform((int)(rectangle.getX() + rectangle.getWidth())).doubleValue(units);
            d2 = dasAxis2.invTransform((int)rectangle.getY()).doubleValue(units2);
            d3 = dasAxis2.invTransform((int)(rectangle.getY() + rectangle.getHeight())).doubleValue(units2);
        }
        if (d5 < d4) {
            d = d5;
            d5 = d4;
            d4 = d;
        }
        if (d3 < d2) {
            d = d3;
            d3 = d2;
            d2 = d;
        }
        if (this.psym != Psym.NONE) {
            int n;
            int n2 = VectorUtil.closestXTag(vectorDataSet, d4, units);
            if (n2 > 0) {
                --n2;
            }
            if ((n = VectorUtil.closestXTag(vectorDataSet, d5, units)) < vectorDataSet.getXLength() - 1) {
                ++n;
            }
            for (int i = n2; i <= n; ++i) {
                if (vectorDataSet.getDatum(i).isFill()) continue;
                double d6 = dasAxis.transform(vectorDataSet.getXTagDouble(i, units), units);
                double d7 = dasAxis2.transform(vectorDataSet.getDouble(i, units2), units2);
                if (Double.isNaN(d7)) continue;
                ((Graphics2D)graphics).setStroke(new BasicStroke(this.lineWidth));
                this.psym.draw(graphics, d6, d7, (float)this.symSize);
            }
        }
        long l2 = System.currentTimeMillis();
        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).finer("render: " + (l2 - l) + " total:" + (l2 - this.lastUpdateMillis) + " fps:" + 1000.0 / (double)(l2 - this.lastUpdateMillis));
        this.lastUpdateMillis = l2;
    }

    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) {
        ++this.updateImageCount;
        this.reportCount();
        try {
            super.updatePlotImage(dasAxis, dasAxis2, dasProgressMonitor);
        }
        catch (DasException dasException) {
            throw new RuntimeException(dasException);
        }
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("entering updatePlotImage");
        boolean bl = this.histogram;
        VectorDataSet vectorDataSet = (VectorDataSet)this.getDataSet();
        if (vectorDataSet == null || vectorDataSet.getXLength() == 0) {
            return;
        }
        Units units = dasAxis.getUnits();
        Units units2 = dasAxis2.getUnits();
        DatumRange datumRange = dasAxis.getDatumRange();
        double d = datumRange.min().doubleValue(units);
        double d2 = datumRange.max().doubleValue(units);
        double d3 = dasAxis2.getDataMaximum().doubleValue(units2);
        double d4 = dasAxis2.getDataMinimum().doubleValue(units2);
        if (this.psymConnector != PsymConnector.NONE) {
            double d5;
            Object object;
            int n = DataSetUtil.getPreviousColumn(vectorDataSet, datumRange.min());
            int n2 = DataSetUtil.getNextColumn(vectorDataSet, datumRange.max());
            GeneralPath generalPath = new GeneralPath(1, 110 * (n2 - n) / 100);
            if (vectorDataSet.getProperty("xTagWidth") != null) {
                object = (Datum)vectorDataSet.getProperty("xTagWidth");
                d5 = ((Datum)object).doubleValue(units.getOffsetUnits());
            } else {
                object = (String)vectorDataSet.getProperty("x_sample_width");
                if (object != null) {
                    double d6 = Double.parseDouble((String)object);
                    d5 = Units.seconds.convertDoubleTo(units.getOffsetUnits(), d6);
                } else {
                    d5 = 1.0E31;
                }
            }
            d5 *= 1.5;
            double d7 = Double.NaN;
            double d8 = Double.NaN;
            double d9 = Double.NaN;
            double d10 = Double.NaN;
            boolean bl2 = true;
            for (int i = n; i <= n2; ++i) {
                double d11 = vectorDataSet.getXTagDouble(i, units);
                double d12 = vectorDataSet.getDouble(i, units2);
                double d13 = dasAxis.transform(d11, units);
                double d14 = dasAxis2.transform(d12, units2);
                if (vectorDataSet.getDatum(i).isFill() || Double.isNaN(d12)) {
                    bl2 = true;
                } else if (bl2) {
                    generalPath.moveTo((float)d13, (float)d14);
                    bl2 = false;
                } else if (Math.abs(d11 - d7) > d5) {
                    generalPath.lineTo((float)d9, (float)d10);
                    generalPath.moveTo((float)d13, (float)d14);
                    bl2 = false;
                } else {
                    if (bl) {
                        double d15 = (d9 + d13) / 2.0;
                        generalPath.lineTo((float)d15, (float)d10);
                        generalPath.lineTo((float)d15, (float)d14);
                        generalPath.lineTo((float)d13, (float)d14);
                    } else {
                        generalPath.lineTo((float)d13, (float)d14);
                    }
                    bl2 = false;
                }
                d7 = d11;
                d8 = d12;
                d9 = d13;
                d10 = d14;
            }
            this.path = generalPath;
        } else {
            this.path = null;
        }
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("done updatePlotImage");
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector psymConnector) {
        this.psymConnector = psymConnector;
        this.refreshImage();
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym psym2 = this.psym;
        this.psym = psym;
        this.refreshImage();
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double d) {
        this.symSize = d;
        this.setPsym(this.psym);
        this.refreshImage();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.refreshImage();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.refreshImage();
    }

    protected void installRenderer() {
        DasMouseInputAdapter dasMouseInputAdapter = this.parent.mouseAdapter;
        DasPlot dasPlot = this.parent;
        dasMouseInputAdapter.addMouseModule(new MouseModule(dasPlot, new LengthDragRenderer(dasPlot, dasPlot.getXAxis(), dasPlot.getYAxis()), "Length"));
    }

    protected void uninstallRenderer() {
    }

    public static SymbolLineRenderer processLinePlotElement(Element element, DasPlot dasPlot, FormBase formBase) {
        String string = element.getAttribute("dataSetID");
        Psym psym = Psym.parsePsym(element.getAttribute("psym"));
        SymColor symColor = SymColor.parseSymColor(element.getAttribute("color"));
        SymbolLineRenderer symbolLineRenderer = new SymbolLineRenderer((DataSet)null);
        dasPlot.addRenderer(symbolLineRenderer);
        float f = Float.parseFloat(element.getAttribute("lineWidth"));
        try {
            symbolLineRenderer.setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        symbolLineRenderer.setPsym(psym);
        symbolLineRenderer.setColor(symColor);
        symbolLineRenderer.setLineWidth(f);
        return symbolLineRenderer;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("lineplot");
        element.setAttribute("dataSetID", this.getDataSetID());
        element.setAttribute("psym", this.getPsym().toString());
        element.setAttribute("color", this.getColor().toString());
        return element;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        this.antiAliased = bl;
        this.refreshImage();
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean bl) {
        if (bl != this.histogram) {
            this.histogram = bl;
            if (this.getParent() != null && this.getParent().getCanvas() != null) {
                new Runnable(){
                    {
                        RequestProcessor.invokeLater(this, SymbolLineRenderer.this.getParent().getCanvas());
                    }

                    public void run() {
                        SymbolLineRenderer.this.updatePlotImage(SymbolLineRenderer.this.getParent().getXAxis(), SymbolLineRenderer.this.getParent().getYAxis(), null);
                    }
                };
            }
        }
    }

    public String getListLabel() {
        return String.valueOf(this.getDataSetDescriptor());
    }

    public Icon getListIcon() {
        BufferedImage bufferedImage = new BufferedImage(15, 10, 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        if (this.color.equals(Color.white)) {
            graphics2D.setColor(Color.GRAY);
        } else {
            graphics2D.setColor(new Color(0, 0, 0, 0));
        }
        graphics2D.fillRect(0, 0, 15, 10);
        graphics2D.setColor(this.color);
        Stroke stroke = graphics2D.getStroke();
        this.getPsymConnector().drawLine(graphics2D, 2.0, 3.0, 13.0, 7.0, 1.5f);
        graphics2D.setStroke(stroke);
        this.psym.draw(graphics2D, 7.0, 5.0, 3.0f);
        return new ImageIcon(bufferedImage);
    }
}

