/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class SymColor
extends Color
implements Enumeration,
Displayable {
    private String name;
    private ImageIcon imageIcon;
    public static final SymColor black = new SymColor("black", Color.black);
    public static final SymColor blue = new SymColor("blue", Color.blue);
    public static final SymColor lightRed = new SymColor("lightRed", new Color(255, 128, 128));
    public static final SymColor red = new SymColor("red", Color.red);
    public static final SymColor darkRed = new SymColor("darkRed", Color.red.darker());
    public static final SymColor green = new SymColor("green", Color.green);
    public static final SymColor darkGreen = new SymColor("darkGreen", Color.green.darker());
    public static final SymColor white = new SymColor("white", Color.white);
    public static final SymColor gray = new SymColor("gray", Color.gray);
    public static final SymColor magenta = new SymColor("magenta", Color.magenta);

    private SymColor(String string, Color color) {
        this(string, color.getRGB());
    }

    private SymColor(String string, int n) {
        super(n);
        this.name = string;
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(this);
        graphics.fillRect(0, 0, 10, 10);
        this.imageIcon = new ImageIcon(bufferedImage);
    }

    public Icon getListIcon() {
        return this.imageIcon;
    }

    public String getListLabel() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Color toColor() {
        return this;
    }

    public static SymColor parseSymColor(String string) {
        if (string.equals("black")) {
            return black;
        }
        if (string.equals("blue")) {
            return blue;
        }
        if (string.equals("red")) {
            return red;
        }
        if (string.equals("green")) {
            return green;
        }
        if (string.equals("white")) {
            return white;
        }
        if (string.equals("gray")) {
            return gray;
        }
        throw new IllegalArgumentException(string);
    }
}

