/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.components.HorizontalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.AveragePeakTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.NearestNeighborTableRebinner;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.HorizontalSlicerMouseModule;
import edu.uiowa.physics.pw.das.event.LengthDragRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.VerticalSlicerMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasLabelAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.RowRowConnector;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StackedHistogramRenderer
extends Renderer
implements TableDataSetConsumer,
PropertyChangeListener,
Displayable {
    private DasLabelAxis yAxis = null;
    private DasAxis zAxis = null;
    private RowRowConnector zAxisConnector = null;
    private DasRow littleRow = null;
    private RebinDescriptor xBins = null;
    private PeaksIndicator peaksIndicator;
    private boolean sliceRebinnedData;
    Image plotImage;
    DatumRange imageXRange;
    DatumRange imageYRange;
    RebinListener rebinListener = new RebinListener();

    public StackedHistogramRenderer(DasPlot dasPlot, DataSetDescriptor dataSetDescriptor, DasAxis dasAxis, DasLabelAxis dasLabelAxis) {
        this.yAxis = dasLabelAxis;
        this.zAxis = dasAxis;
        dasAxis.addPropertyChangeListener(this.rebinListener);
        this.setDataSetDescriptor(dataSetDescriptor);
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(graphics2D, dasAxis, dasAxis2, this.lastException);
        } else if (this.plotImage != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            Point2D.Float float_ = new Point2D.Float(dasAxis.getColumn().getDMinimum(), dasAxis2.getRow().getDMinimum());
            graphics2D.drawImage(this.plotImage, (int)(((Point2D)float_).getX() + 0.5), (int)(((Point2D)float_).getY() + 0.5), this.getParent());
        }
        graphics2D.dispose();
    }

    protected void installRenderer() {
        DasCanvas dasCanvas = this.parent.getCanvas();
        this.littleRow = new DasRow(dasCanvas, 0.5, 0.6);
        this.zAxisConnector = new RowRowConnector(dasCanvas, this.littleRow, this.zAxis.getRow(), this.parent.getColumn(), this.zAxis.getColumn());
        this.zAxisConnector.setVisible(false);
        dasCanvas.add(this.zAxisConnector);
        this.yAxis.setFloppyItemSpacing(true);
        this.yAxis.setOutsidePadding(1);
        this.peaksIndicator = PeaksIndicator.MaxLines;
        DasMouseInputAdapter dasMouseInputAdapter = this.parent.getMouseAdapter();
        VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
        VerticalSlicerMouseModule verticalSlicerMouseModule = VerticalSlicerMouseModule.create(this);
        verticalSlicerMouseModule.addDataPointSelectionListener(verticalSpectrogramSlicer);
        dasMouseInputAdapter.addMouseModule(verticalSlicerMouseModule);
        HorizontalSpectrogramSlicer horizontalSpectrogramSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
        HorizontalSlicerMouseModule horizontalSlicerMouseModule = HorizontalSlicerMouseModule.create(this);
        horizontalSlicerMouseModule.addDataPointSelectionListener(horizontalSpectrogramSlicer);
        dasMouseInputAdapter.addMouseModule(horizontalSlicerMouseModule);
        CrossHairMouseModule crossHairMouseModule = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
        dasMouseInputAdapter.addMouseModule(crossHairMouseModule);
        DasPlot dasPlot = this.parent;
        dasMouseInputAdapter.addMouseModule(new MouseModule(dasPlot, new LengthDragRenderer(dasPlot, dasPlot.getXAxis(), dasPlot.getYAxis()), "Length"));
    }

    protected void uninstallRenderer() {
    }

    public void setZAxis(DasAxis dasAxis) {
        this.zAxis = dasAxis;
        throw new IllegalStateException("not supported");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void setYAxis(DasAxis dasAxis) {
        if (dasAxis instanceof DasLabelAxis) {
            this.yAxis = (DasLabelAxis)dasAxis;
            dasAxis.addPropertyChangeListener(this);
        } else {
            DasDie.die("You can't call setYAxis for stackedHistogramPlot");
        }
    }

    public synchronized void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) throws DasException {
        super.updatePlotImage(dasAxis, dasAxis2, dasProgressMonitor);
        Color color = Color.BLACK;
        DasPlot dasPlot = this.getParent();
        Cursor cursor = dasPlot.getCursor();
        dasPlot.setCursor(new Cursor(3));
        DasColumn dasColumn = dasAxis.getColumn();
        DasRow dasRow = this.yAxis.getRow();
        int n = dasColumn.getWidth();
        int n2 = dasRow.getHeight();
        if (n == 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.translate(-dasColumn.getDMinimum(), -dasRow.getDMinimum());
        double d = dasColumn.getDMinimum();
        double d2 = dasRow.getDMinimum();
        RebinDescriptor rebinDescriptor = new RebinDescriptor(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), Math.abs(dasColumn.getWidth()) / 1 + 1, dasAxis.isLog());
        this.imageXRange = dasAxis.getDatumRange();
        this.imageYRange = this.yAxis.getDatumRange();
        int n3 = dasColumn.getDMaximum();
        int n4 = dasColumn.getDMinimum();
        TableDataSet tableDataSet = (TableDataSet)this.getDataSet();
        if (tableDataSet == null) {
            this.plotImage = null;
            if (this.lastException == null) {
                this.setLastException(new DasException("null data set"));
            }
            return;
        }
        if (tableDataSet.tableCount() == 0) {
            this.setLastException(new DasException("empty data set"));
            this.ds = null;
            return;
        }
        Rebinner rebinner = new Rebinner();
        TableDataSet tableDataSet2 = (TableDataSet)rebinner.rebin(tableDataSet, rebinDescriptor, null);
        TableDataSet tableDataSet3 = (TableDataSet)tableDataSet2.getPlanarView("peaks");
        TableDataSet tableDataSet4 = (TableDataSet)tableDataSet2.getPlanarView("weights");
        DasLabelAxis dasLabelAxis = (DasLabelAxis)dasAxis2;
        int n5 = this.zAxis.getRow().getDMiddle();
        boolean bl = false;
        for (int i = 0; i < tableDataSet2.getYLength(0); ++i) {
            int n6;
            if (i == tableDataSet2.getYLength(0) - 1) {
                n6 = dasLabelAxis.getItemMin(tableDataSet2.getYTagDatum(0, i));
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawLine(n4, n6, n3, n6);
                graphics2D.setColor(color);
            }
            n6 = dasLabelAxis.getItemMax(tableDataSet2.getYTagDatum(0, i));
            graphics2D.setColor(Color.lightGray);
            graphics2D.drawLine(n4, n6, n3, n6);
            graphics2D.setColor(color);
            int n7 = dasLabelAxis.getItemMin(tableDataSet2.getYTagDatum(0, i));
            double d3 = ((Component)dasPlot).getHeight();
            if (!bl && n7 <= n5) {
                this.littleRow.setDPosition(n7, n6);
                bl = true;
                this.zAxisConnector.setVisible(true);
                this.zAxisConnector.repaint();
            }
            double[] dArray = rebinDescriptor.binStarts();
            double[] dArray2 = rebinDescriptor.binStops();
            int n8 = n6;
            int n9 = n6 - n7;
            double d4 = this.zAxis.getDataMaximum().doubleValue(tableDataSet.getZUnits());
            double d5 = this.zAxis.getDataMinimum().doubleValue(tableDataSet.getZUnits());
            if (n7 < dasRow.getDMinimum() || n6 > dasRow.getDMaximum()) continue;
            for (int j = 0; j < tableDataSet2.getXLength(); ++j) {
                double d6;
                int n10;
                int n11 = (int)dasAxis.transform(dArray[j], rebinDescriptor.getUnits());
                int n12 = n11 + 1;
                double d7 = tableDataSet2.getDouble(j, i, tableDataSet2.getZUnits());
                if (tableDataSet2.getZUnits().isFill(d7) || Double.isNaN(d7)) continue;
                int n13 = (int)this.zAxis.transform(d7, tableDataSet2.getZUnits(), n6, n7);
                n13 = n13 > n8 - n9 ? n13 : n8 - n9;
                int n14 = n10 = n8 - n13 > 0 ? n8 - n13 : 0;
                if (tableDataSet3 != null && (d6 = tableDataSet3.getDouble(j, i, tableDataSet3.getZUnits())) <= d4) {
                    int n15 = (int)this.zAxis.transform(d6, tableDataSet2.getZUnits(), n6, n7);
                    int n16 = n15 = n8 - n15 > 0 ? n15 : n8;
                    if (this.peaksIndicator == PeaksIndicator.MaxLines) {
                        graphics2D.drawLine(n11, n15, n11, n15);
                    } else if (this.peaksIndicator == PeaksIndicator.GrayPeaks) {
                        graphics2D.setColor(Color.lightGray);
                        graphics2D.drawLine(n11, n15, n11, n8);
                        graphics2D.setColor(color);
                    } else if (this.peaksIndicator == PeaksIndicator.BlackPeaks) {
                        graphics2D.setColor(color);
                        graphics2D.drawLine(n11, n15, n11, n8);
                    }
                }
                if (!(d7 >= d5)) continue;
                graphics2D.drawLine(n11, n13, n11, n13 + n10);
            }
        }
        graphics2D.dispose();
        this.plotImage = bufferedImage;
        dasPlot.setCursor(cursor);
        this.getParent().repaint();
        if (this.sliceRebinnedData) {
            this.ds = tableDataSet2;
        }
    }

    public DasAxis getZAxis() {
        return this.zAxis;
    }

    public void setZTitle(String string) {
        this.getZAxis().setLabel(string);
    }

    public PeaksIndicator getPeaksIndicator() {
        return this.peaksIndicator;
    }

    public void setPeaksIndicator(PeaksIndicator peaksIndicator) {
        this.peaksIndicator = peaksIndicator;
        this.refreshImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean bl) {
        this.sliceRebinnedData = bl;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("stackedHistogram");
        element.setAttribute("zAxis", this.zAxis.getDasName());
        element.setAttribute("dataSetID", this.getDataSetID());
        return element;
    }

    public static Renderer processStackedHistogramElement(Element element, DasPlot dasPlot, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        String string = element.getAttribute("dataSetID");
        StackedHistogramRenderer stackedHistogramRenderer = new StackedHistogramRenderer(dasPlot, null, null, (DasLabelAxis)dasPlot.getYAxis());
        try {
            stackedHistogramRenderer.setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        return stackedHistogramRenderer;
    }

    public String getListLabel() {
        return "stacked histogram";
    }

    public Icon getListIcon() {
        return null;
    }

    public class Rebinner
    implements DataSetRebinner {
        DataSetRebinner highResRebinner = new NearestNeighborTableRebinner();
        DataSetRebinner lowResRebinner = new AveragePeakTableRebinner();

        Rebinner() {
        }

        public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException, DasException {
            Units units;
            Datum datum = (Datum)dataSet.getProperty("xTagWidth");
            if (datum == null) {
                datum = DataSetUtil.guessXTagWidth((TableDataSet)dataSet);
            }
            if ((units = rebinDescriptor.getUnits()) instanceof LocationUnits) {
                units = ((LocationUnits)units).getOffsetUnits();
            }
            try {
                DataSet dataSet2;
                if (rebinDescriptor.binWidth() < datum.doubleValue(units)) {
                    DasApplication.getDefaultApplication().getLogger().fine("using rebinner " + this.highResRebinner);
                    dataSet2 = this.highResRebinner.rebin(dataSet, rebinDescriptor, rebinDescriptor2);
                } else {
                    DasApplication.getDefaultApplication().getLogger().fine("using rebinner " + this.lowResRebinner);
                    dataSet2 = this.lowResRebinner.rebin(dataSet, rebinDescriptor, rebinDescriptor2);
                }
                return dataSet2;
            }
            catch (Exception exception) {
                DasExceptionHandler.handle(exception);
                return null;
            }
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            StackedHistogramRenderer.this.update();
        }
    }

    public static class PeaksIndicator
    implements Enumeration,
    Displayable {
        String id;
        public static final PeaksIndicator NoPeaks = new PeaksIndicator("None");
        public static final PeaksIndicator GrayPeaks = new PeaksIndicator("Gray Peaks");
        public static final PeaksIndicator BlackPeaks = new PeaksIndicator("Black Peaks");
        public static final PeaksIndicator MaxLines = new PeaksIndicator("Lines");

        PeaksIndicator(String string) {
            this.id = string;
        }

        public String toString() {
            return this.id;
        }

        public String getListLabel() {
            return this.id;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

