/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.components.HorizontalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramAverager;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.NearestNeighborTableRebinner;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.BoxZoomMouseModule;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.DumpToFileMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalDragRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalSlicerMouseModule;
import edu.uiowa.physics.pw.das.event.LengthDragRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.VerticalSlicerMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpectrogramRenderer
extends Renderer
implements TableDataSetConsumer,
Displayable {
    private Object lockObject = new Object();
    private DasColorBar colorBar;
    private Image plotImage;
    private byte[] raster;
    DatumRange imageXRange;
    DatumRange imageYRange;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    DasAxis.Memento cmemento;
    int updateImageCount = 0;
    int renderCount = 0;
    private TableDataSet rebinDataSet;
    RebinListener rebinListener = new RebinListener();
    private static Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private RebinnerEnum rebinnerEnum;
    int count = 0;
    private boolean sliceRebinnedData = true;

    public SpectrogramRenderer(DataSetDescriptor dataSetDescriptor, DasColorBar dasColorBar) {
        super(dataSetDescriptor);
        this.colorBar = dasColorBar;
        if (this.colorBar != null) {
            dasColorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasColorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasColorBar.addPropertyChangeListener("log", this.rebinListener);
            dasColorBar.addPropertyChangeListener("type", this.rebinListener);
        }
        this.setRebinner(RebinnerEnum.binAverage);
    }

    public SpectrogramRenderer(DasPlot dasPlot, DataSetDescriptor dataSetDescriptor, DasColorBar dasColorBar) {
        this(dataSetDescriptor, dasColorBar);
        this.parent = dasPlot;
    }

    public DasAxis getZAxis() {
        return this.colorBar;
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar dasColorBar) {
        if (this.colorBar == dasColorBar) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = dasColorBar;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        logger.finer("entering SpectrogramRenderer.render");
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        ++this.renderCount;
        this.reportCount();
        Object object = this.lockObject;
        synchronized (object) {
            if (this.plotImage == null && this.lastException != null) {
                this.renderException(graphics2D, dasAxis, dasAxis2, this.lastException);
            } else if (this.plotImage != null) {
                Point2D.Float float_ = new Point2D.Float(dasAxis.getColumn().getDMinimum(), dasAxis2.getRow().getDMinimum());
                graphics2D.drawImage(this.plotImage, (int)(((Point2D)float_).getX() + 0.5), (int)(((Point2D)float_).getY() + 0.5), this.getParent());
            }
        }
        graphics2D.dispose();
    }

    private static byte[] transformSimpleTableDataSet(TableDataSet tableDataSet, DasColorBar dasColorBar) {
        int n;
        int n2;
        if (tableDataSet.tableCount() > 1) {
            throw new IllegalArgumentException("TableDataSet contains more than one table");
        }
        logger.fine("converting to pixel map");
        int n3 = 0;
        int n4 = n2 = tableDataSet.getYLength(n3);
        int n5 = n = tableDataSet.tableEnd(n3) - tableDataSet.tableStart(n3);
        Units units = dasColorBar.getUnits();
        int n6 = dasColorBar.getType().getColorCount();
        TableDataSet tableDataSet2 = (TableDataSet)tableDataSet.getPlanarView("weights");
        byte[] byArray = new byte[n * n2];
        Arrays.fill(byArray, (byte)dasColorBar.getFillColorIndex());
        for (int i = tableDataSet.tableStart(n3); i < tableDataSet.tableEnd(n3); ++i) {
            for (int j = 0; j < n2; ++j) {
                if (tableDataSet2 != null && !(tableDataSet2.getDouble(i, j, Units.dimensionless) > 0.0)) continue;
                int n7 = i - 0 + (n2 - j - 1) * n;
                int n8 = dasColorBar.indexColorTransform(tableDataSet.getDouble(i, j, units), units);
                byArray[n7] = (byte)n8;
            }
        }
        return byArray;
    }

    private void reportCount() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) throws DasException {
        logger.finer("entering SpectrogramRenderer.updatePlotImage");
        ++this.updateImageCount;
        this.reportCount();
        try {
            Object object;
            Object object2;
            Object object3;
            int n = dasAxis.getColumn().getDMaximum() - dasAxis.getColumn().getDMinimum();
            int n2 = dasAxis2.getRow().getDMaximum() - dasAxis2.getRow().getDMinimum();
            if (this.raster != null && this.xmemento != null && this.ymemento != null && dasAxis.getMemento().equals(this.xmemento) && dasAxis2.getMemento().equals(this.ymemento) && this.colorBar.getMemento().equals(this.cmemento)) {
                logger.fine("same xaxis, yaxis, reusing raster");
            } else {
                if (this.getParent() == null || n <= 1 || n2 <= 1) {
                    logger.finest("canvas not useable!!!");
                    return;
                }
                if (this.ds == null) {
                    logger.fine("got null dataset, setting image to null");
                    this.plotImage = null;
                    this.rebinDataSet = null;
                    this.imageXRange = null;
                    this.imageYRange = null;
                    this.getParent().repaint();
                    return;
                }
                object3 = new RebinDescriptor(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), n, dasAxis.isLog());
                object2 = new RebinDescriptor(dasAxis2.getDataMinimum(), dasAxis2.getDataMaximum(), n2, dasAxis2.isLog());
                this.imageXRange = dasAxis.getDatumRange();
                this.imageYRange = dasAxis2.getDatumRange();
                logger.fine("rebinning to pixel resolution");
                object = this.rebinnerEnum.getRebinner();
                long l = System.currentTimeMillis();
                this.rebinDataSet = (TableDataSet)object.rebin(this.ds, (RebinDescriptor)object3, (RebinDescriptor)object2);
                this.xmemento = dasAxis.getMemento();
                this.ymemento = dasAxis2.getMemento();
                this.cmemento = this.colorBar.getMemento();
                this.raster = SpectrogramRenderer.transformSimpleTableDataSet(this.rebinDataSet, this.colorBar);
            }
            object2 = this.colorBar.getIndexColorModel();
            object3 = new BufferedImage(n, n2, 13, (IndexColorModel)object2);
            object = ((BufferedImage)object3).getRaster();
            ((WritableRaster)object).setDataElements(0, 0, n, n2, this.raster);
            Object object4 = this.lockObject;
            synchronized (object4) {
                this.plotImage = object3;
            }
        }
        catch (NoDataInIntervalException noDataInIntervalException) {
            this.lastException = noDataInIntervalException;
            this.plotImage = null;
        }
        finally {
            this.getParent().repaint();
        }
    }

    protected void installRenderer() {
        if (this.parent != null && this.parent.getCanvas() != null && this.colorBar != null) {
            Editable editable;
            if (this.colorBar.getColumn() == DasColumn.NULL) {
                editable = this.parent.getColumn();
                this.colorBar.setColumn(((DasColumn)editable).createAttachedColumn(1.05, 1.1));
            }
            this.parent.getCanvas().add(this.colorBar, this.parent.getRow(), this.colorBar.getColumn());
            if (!"true".equals(System.getProperty("java.awt.headless"))) {
                editable = this.parent.mouseAdapter;
                VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
                VerticalSlicerMouseModule verticalSlicerMouseModule = VerticalSlicerMouseModule.create(this);
                verticalSlicerMouseModule.addDataPointSelectionListener(verticalSpectrogramSlicer);
                ((DasMouseInputAdapter)editable).addMouseModule(verticalSlicerMouseModule);
                HorizontalSpectrogramSlicer horizontalSpectrogramSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
                HorizontalSlicerMouseModule horizontalSlicerMouseModule = HorizontalSlicerMouseModule.create(this);
                horizontalSlicerMouseModule.addDataPointSelectionListener(horizontalSpectrogramSlicer);
                ((DasMouseInputAdapter)editable).addMouseModule(horizontalSlicerMouseModule);
                VerticalSpectrogramAverager verticalSpectrogramAverager = VerticalSpectrogramAverager.createAverager(this.parent, this);
                HorizontalDragRangeSelectorMouseModule horizontalDragRangeSelectorMouseModule = new HorizontalDragRangeSelectorMouseModule(this.parent, this, this.parent.getXAxis());
                horizontalDragRangeSelectorMouseModule.addDataRangeSelectionListener(verticalSpectrogramAverager);
                ((DasMouseInputAdapter)editable).addMouseModule(horizontalDragRangeSelectorMouseModule);
                MouseModule mouseModule = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                ((DasMouseInputAdapter)editable).addMouseModule(mouseModule);
                mouseModule = new DumpToFileMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                ((DasMouseInputAdapter)editable).addMouseModule(mouseModule);
                DasPlot dasPlot = this.parent;
                ((DasMouseInputAdapter)editable).addMouseModule(new MouseModule(dasPlot, new LengthDragRenderer(dasPlot, dasPlot.getXAxis(), dasPlot.getYAxis()), "Length"));
                ((DasMouseInputAdapter)editable).addMouseModule(new BoxZoomMouseModule(dasPlot, this, dasPlot.getXAxis(), dasPlot.getYAxis()));
            }
        }
    }

    protected void uninstallRenderer() {
        if (this.colorBar != null && this.colorBar.getCanvas() != null) {
            this.colorBar.getCanvas().remove(this.colorBar);
        }
    }

    public static SpectrogramRenderer processSpectrogramElement(Element element, DasPlot dasPlot, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        String string = element.getAttribute("dataSetID");
        DasColorBar dasColorBar = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("zAxis")) continue;
            dasColorBar = SpectrogramRenderer.processZAxisElement((Element)node, formBase);
        }
        if (dasColorBar == null) {
            try {
                dasColorBar = (DasColorBar)formBase.checkValue(element.getAttribute("colorbar"), DasColorBar.class, "<colorbar>");
            }
            catch (DasPropertyException dasPropertyException) {
                dasPropertyException.setPropertyName("colorbar");
                throw dasPropertyException;
            }
        }
        SpectrogramRenderer spectrogramRenderer = new SpectrogramRenderer(dasPlot, null, dasColorBar);
        try {
            spectrogramRenderer.setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        return spectrogramRenderer;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return DasColorBar.processColorbarElement((Element)node, formBase);
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("dataSetID", this.getDataSetID());
        Element element2 = document.createElement("zAxis");
        Element element3 = this.getColorBar().getDOMElement(document);
        if (element3.getAttribute("row").equals(this.getParent().getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getParent().getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    public RebinnerEnum getRebinner() {
        return this.rebinnerEnum;
    }

    public void setRebinner(RebinnerEnum rebinnerEnum) {
        this.rebinnerEnum = rebinnerEnum;
        this.raster = null;
        this.plotImage = null;
        this.refreshImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean bl) {
        this.sliceRebinnedData = bl;
    }

    public String getListLabel() {
        return "spectrogram";
    }

    public Icon getListIcon() {
        return null;
    }

    public DataSet getDataSet() {
        if (this.sliceRebinnedData) {
            return this.rebinDataSet;
        }
        return this.ds;
    }

    public void setDataSet(DataSet dataSet) {
        this.raster = null;
        this.plotImage = null;
        super.setDataSet(dataSet);
    }

    public static class RebinnerEnum
    implements Enumeration {
        DataSetRebinner rebinner;
        String label;
        public static final RebinnerEnum binAverage = new RebinnerEnum(new AverageTableRebinner(), "binAverage");
        public static final RebinnerEnum nearestNeighbor = new RebinnerEnum(new NearestNeighborTableRebinner(), "nearestNeighbor");
        public static final RebinnerEnum binAverageNoInterpolate;
        public static final RebinnerEnum binAverageNoInterpolateNoEnlarge;

        public RebinnerEnum(DataSetRebinner dataSetRebinner, String string) {
            this.rebinner = dataSetRebinner;
            this.label = string;
        }

        public Icon getListIcon() {
            return null;
        }

        public String toString() {
            return this.label;
        }

        DataSetRebinner getRebinner() {
            return this.rebinner;
        }

        static {
            AverageTableRebinner averageTableRebinner = new AverageTableRebinner();
            averageTableRebinner.setInterpolate(false);
            binAverageNoInterpolate = new RebinnerEnum(averageTableRebinner, "noInterpolate");
            averageTableRebinner = new AverageTableRebinner();
            averageTableRebinner.setInterpolate(false);
            averageTableRebinner.setEnlargePixels(false);
            binAverageNoInterpolateNoEnlarge = new RebinnerEnum(averageTableRebinner, "noInterpolateNoEnlarge");
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SpectrogramRenderer.this.update();
        }
    }
}

