/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RowRowConnector
extends DasCanvasComponent
implements PropertyChangeListener {
    private DasCanvas parent;
    private DasRow leftRow;
    private DasRow rightRow;
    private DasColumn leftColumn;
    private DasColumn rightColumn;
    private boolean centerRightRow = false;

    public RowRowConnector(DasCanvas dasCanvas, DasRow dasRow, DasRow dasRow2, DasColumn dasColumn, DasColumn dasColumn2) {
        this.leftRow = dasRow;
        this.rightRow = dasRow2;
        this.leftColumn = dasColumn;
        this.rightColumn = dasColumn2;
        this.parent = dasCanvas;
        dasRow.addPropertyChangeListener(this);
        dasRow2.addPropertyChangeListener(this);
        dasColumn2.addPropertyChangeListener(this);
        dasColumn.addPropertyChangeListener(this);
    }

    private Rectangle getMyBounds() {
        int n;
        int n2;
        if (this.centerRightRow) {
            n2 = this.rightRow.getHeight();
            n = this.leftRow.getDMiddle();
            if (n - n2 / 2 < 0) {
                n = n2 / 2;
            }
            if (n + n2 / 2 > this.parent.getHeight()) {
                n = this.parent.getHeight() - n2 / 2;
            }
            this.rightRow.setDPosition(n - n2 / 2, n + n2 / 2);
        }
        n2 = this.leftColumn.getDMaximum();
        n = this.rightColumn.getDMaximum();
        int n3 = Math.max(this.leftRow.getDMaximum(), this.rightRow.getDMaximum());
        int n4 = Math.min(this.leftRow.getDMinimum(), this.rightRow.getDMinimum());
        Rectangle rectangle = new Rectangle(n2, n4, n - n2, n3 - n4 + 2);
        return rectangle;
    }

    public void setLeftRow(DasRow dasRow) {
        this.leftRow = dasRow;
        this.update();
    }

    public void resize() {
        this.setBounds(this.getMyBounds());
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-this.getX(), -this.getY());
        int n = 3;
        int n2 = this.leftColumn.getDMaximum() + n;
        int n3 = this.rightColumn.getDMaximum() - n;
        int n4 = this.leftRow.getDMaximum();
        int n5 = this.rightRow.getDMaximum();
        int n6 = this.leftRow.getDMinimum();
        int n7 = this.rightRow.getDMinimum();
        graphics2D.setColor(Color.lightGray);
        graphics2D.draw(new Line2D.Double(n2 - n, n4, n2, n4));
        graphics2D.draw(new Line2D.Double(n3, n5, n3 + n, n5));
        graphics2D.draw(new Line2D.Double(n2, n4, n3, n5));
        graphics2D.draw(new Line2D.Double(n2 - n, n6, n2, n6));
        graphics2D.draw(new Line2D.Double(n3, n7, n3 + n, n7));
        graphics2D.draw(new Line2D.Double(n2, n6, n3, n7));
        graphics2D.dispose();
        this.getMouseAdapter().paint(graphics);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.markDirty();
        this.update();
    }
}

