/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRendererUpdateEvent;
import edu.uiowa.physics.pw.das.graph.DataLoader;
import edu.uiowa.physics.pw.das.graph.XAxisDataLoader;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Renderer
implements DataSetConsumer,
Editable {
    String dataSetId;
    protected DataSet ds;
    private DasAxis.Memento xmemento;
    private DasAxis.Memento ymemento;
    DasPlot parent;
    DataLoader loader;
    protected Exception lastException;
    protected Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private boolean dumpDataSet;
    private boolean overloading = false;
    private boolean active = true;

    protected Renderer(DataSetDescriptor dataSetDescriptor) {
        this.loader = new XAxisDataLoader(this, dataSetDescriptor);
    }

    protected Renderer(DataSet dataSet) {
        this.ds = dataSet;
        this.loader = null;
    }

    protected Renderer() {
        this((DataSetDescriptor)null);
    }

    public DasPlot getParent() {
        return this.parent;
    }

    protected void invalidateParentCacheImage() {
        if (this.parent != null) {
            this.parent.invalidateCacheImage();
        }
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean bl) {
        this.dumpDataSet = bl;
        if (bl) {
            try {
                if (this.ds == null) {
                    this.setDumpDataSet(false);
                    throw new DasException("data set is null");
                }
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(this.getParent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (this.ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)this.ds, new FileOutputStream(file));
                    } else if (this.ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)this.ds, new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set: " + this.ds);
                    }
                }
                this.setDumpDataSet(false);
            }
            catch (Exception exception) {
                DasExceptionHandler.handle(exception);
            }
            this.dumpDataSet = bl;
        }
    }

    public void setLastException(Exception exception) {
        this.lastException = exception;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setDataSet(DataSet dataSet) {
        this.logger.finer("Renderer.setDataSet: " + dataSet);
        this.ds = dataSet;
        this.refresh();
        this.invalidateParentCacheImage();
    }

    public void setException(Exception exception) {
        this.logger.finer("Renderer.setException: " + exception);
        this.lastException = exception;
        this.refresh();
    }

    public void setDataSetID(String string) throws DasException {
        if (string == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (string.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(string);
        this.setDataSetDescriptor(dataSetDescriptor);
    }

    public String getDataSetID() {
        if (this.getDataSetDescriptor() == null) {
            return "";
        }
        return this.getDataSetDescriptor().getDataSetID();
    }

    protected AffineTransform getAffineTransform(DasAxis dasAxis, DasAxis dasAxis2) {
        if (this.xmemento == null) {
            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform = dasAxis.getAffineTransform(this.xmemento, affineTransform);
        affineTransform = dasAxis2.getAffineTransform(this.ymemento, affineTransform);
        return affineTransform;
    }

    public abstract void render(Graphics var1, DasAxis var2, DasAxis var3);

    protected void renderException(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2, Exception exception) {
        String string;
        String string2;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = dasAxis.getColumn().getDMiddle();
        int n2 = dasAxis2.getRow().getDMiddle();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (exception instanceof NoDataInIntervalException) {
            string2 = "no data in interval";
            string = exception.getMessage();
        } else {
            string2 = exception.getMessage();
            string = "";
            if (string2 == null || string2.equals("")) {
                string2 = exception.toString();
            }
        }
        if (!string.equals("")) {
            string2 = string2 + ":!c" + string;
        }
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this.parent, string2);
        grannyTextRenderer.setAlignment(1);
        int n3 = (int)grannyTextRenderer.getWidth();
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        grannyTextRenderer.draw(graphics, n - n3 / 2, n2);
        graphics.setColor(color);
    }

    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) throws DasException {
    }

    protected void refreshImage() {
        if (this.getParent() != null) {
            this.refresh();
        }
    }

    public void update() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        this.logger.fine("Renderer.update");
        if (this.parent != null) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            DasRendererUpdateEvent dasRendererUpdateEvent = new DasRendererUpdateEvent(this.parent, this);
            eventQueue.postEvent(dasRendererUpdateEvent);
        } else {
            this.logger.fine("update but parent was null");
        }
    }

    protected void updateImmediately() {
        if (this.parent == null || !this.parent.isDisplayable()) {
            return;
        }
        if (this.loader != null) {
            this.loader.update();
        }
        this.refresh();
    }

    protected void refresh() {
        if (!this.isActive()) {
            return;
        }
        this.logger.fine("entering Renderer.refresh");
        if (this.parent == null) {
            this.logger.fine("null parent in refresh");
            return;
        }
        if (!this.parent.isDisplayable()) {
            this.logger.fine("parent not displayable");
            return;
        }
        final DasProgressMonitor dasProgressMonitor = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(this.parent, "Rebinning data set", "updatePlotImage");
        Runnable runnable = new Runnable(){

            public void run() {
                Renderer.this.logger.fine("update plot image");
                try {
                    Renderer.this.updatePlotImage(Renderer.this.parent.getXAxis(), Renderer.this.parent.getYAxis(), dasProgressMonitor);
                    Renderer.this.xmemento = Renderer.this.parent.getXAxis().getMemento();
                    Renderer.this.ymemento = Renderer.this.parent.getYAxis().getMemento();
                    Renderer.this.parent.repaint();
                }
                catch (DasException dasException) {
                    Renderer.this.logger.warning("exception: " + dasException);
                    Renderer.this.ds = null;
                    Renderer.this.lastException = dasException;
                }
                catch (RuntimeException runtimeException) {
                    Renderer.this.ds = null;
                    throw runtimeException;
                }
                finally {
                    if (dasProgressMonitor != null) {
                        Renderer.this.logger.fine("progressPanel.finished()");
                        dasProgressMonitor.finished();
                    }
                }
                Renderer.this.logger.fine("invalidate parent cacheImage and repaint");
                Renderer.this.parent.invalidateCacheImage();
                Renderer.this.parent.repaint();
            }
        };
        runnable.run();
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        if (this.loader == null) {
            this.logger.warning("installing loader--danger!");
            this.loader = new XAxisDataLoader(this, dataSetDescriptor);
        }
        if (this.loader instanceof XAxisDataLoader) {
            ((XAxisDataLoader)this.loader).setDataSetDescriptor(dataSetDescriptor);
            if (this.parent != null) {
                this.parent.markDirty();
                this.parent.update();
            }
        } else {
            throw new RuntimeException("loader is not based on DataSetDescriptor");
        }
        this.ds = null;
    }

    public DataLoader getDataLoader() {
        return this.loader;
    }

    public void setDataSetLoader(DataLoader dataLoader) {
        this.loader = dataLoader;
        if (dataLoader != null) {
            dataLoader.update();
        }
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.loader == null) {
            return null;
        }
        if (this.loader instanceof XAxisDataLoader) {
            return ((XAxisDataLoader)this.loader).getDataSetDescriptor();
        }
        return null;
    }

    protected abstract void installRenderer();

    protected abstract void uninstallRenderer();

    protected abstract Element getDOMElement(Document var1);

    public boolean isOverloading() {
        return this.overloading;
    }

    public void setOverloading(boolean bl) {
        this.overloading = bl;
        this.update();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        this.update();
    }
}

