/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class PsymConnector
implements Enumeration,
Displayable {
    String name;
    Icon imageIcon;
    BasicStroke stroke;
    BasicStroke cacheStroke;
    float cacheWidth;
    Line2D line = new Line2D.Double();
    public static final PsymConnector NONE = new PsymConnector("None", null);
    public static final PsymConnector SOLID = new PsymConnector("Solid", new BasicStroke(1.0f, 1, 1));
    public static final PsymConnector DOTFINE = new PsymConnector("DotFine", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.5f, 2.0f}, 0.0f));
    public static final PsymConnector DASHFINE = new PsymConnector("DashFine", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 2.0f}, 0.0f));

    private PsymConnector(String string, BasicStroke basicStroke) {
        this.name = string;
        this.stroke = basicStroke;
        this.cacheStroke = basicStroke;
        if (basicStroke != null) {
            this.cacheWidth = this.cacheStroke.getLineWidth();
        }
        BufferedImage bufferedImage = new BufferedImage(15, 10, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, 0, 15, 10);
        graphics2D.setColor(Color.black);
        this.drawLine(graphics2D, 2.0, 3.0, 13.0, 7.0, 2.0f);
        this.imageIcon = new ImageIcon(bufferedImage);
    }

    protected Stroke getStroke(float f) {
        if (f != this.cacheWidth) {
            float[] fArray = this.stroke.getDashArray();
            float[] fArray2 = null;
            if (fArray != null) {
                fArray2 = new float[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray2[i] = fArray[i] * f;
                }
            }
            this.cacheStroke = new BasicStroke(f, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), fArray2, this.stroke.getDashPhase() * f);
            this.cacheWidth = f;
        }
        return this.cacheStroke;
    }

    public void draw(Graphics2D graphics2D, GeneralPath generalPath, float f) {
        if (this.stroke != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.getStroke(f));
            graphics2D.draw(generalPath);
            graphics2D.setStroke(stroke);
        }
    }

    public void drawLine(Graphics2D graphics2D, double d, double d2, double d3, double d4, float f) {
        if (this.stroke == null) {
            return;
        }
        Line2D line2D = !SwingUtilities.isEventDispatchThread() ? new Line2D.Double() : this.line;
        line2D.setLine(d, d2, d3, d4);
        graphics2D.setStroke(this.getStroke(f));
        graphics2D.draw(line2D);
    }

    public Icon getListIcon() {
        return this.imageIcon;
    }

    public String getListLabel() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

