/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Psym
implements Enumeration,
Displayable {
    private static final String[] NAMES = new String[]{"none", "dots", "circles", "triangles", "cross"};
    public static final Psym NONE = new Psym(0);
    public static final Psym DOTS = new Psym(1);
    public static final Psym CIRCLES = new Psym(2);
    public static final Psym TRIANGLES = new Psym(3);
    public static final Psym CROSS = new Psym(4);
    private int nameIndex;
    private Line2D line = new Line2D.Double();
    private Ellipse2D ellipse = new Ellipse2D.Double();
    ImageIcon imageIcon;

    private Psym(int n) {
        this.nameIndex = n;
        this.line = new Line2D.Double();
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillRect(0, 0, 10, 10);
        graphics2D.setColor(Color.black);
        this.draw(graphics2D, 5.0, 5.0, 2.0f);
        this.imageIcon = new ImageIcon(bufferedImage);
    }

    public String toString() {
        return NAMES[this.nameIndex];
    }

    public String getListLabel() {
        return NAMES[this.nameIndex];
    }

    public Icon getListIcon() {
        return this.imageIcon;
    }

    public void draw(Graphics graphics, double d, double d2, float f) {
        Graphics2D graphics2D = (Graphics2D)(graphics instanceof Graphics2D ? graphics : null);
        switch (this.nameIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (f < 1.0f) {
                    if (graphics instanceof Graphics2D) {
                        this.ellipse.setFrame(d, d2, 1.0, 1.0);
                        graphics2D.fill(this.ellipse);
                        break;
                    }
                    graphics.fillOval((int)d, (int)d2, 1, 1);
                    break;
                }
                if (graphics instanceof Graphics2D) {
                    this.ellipse.setFrame(d - (double)f, d2 - (double)f, f * 2.0f, f * 2.0f);
                    graphics2D.fill(this.ellipse);
                    break;
                }
                graphics.fillOval((int)(d - (double)f), (int)(d - (double)f), (int)(f * 2.0f), (int)(f * 2.0f));
                break;
            }
            case 2: {
                Color color = graphics.getColor();
                this.ellipse.setFrame(d - (double)f, d2 - (double)f, f * 2.0f, f * 2.0f);
                Color color2 = Color.white;
                graphics.setColor(color2);
                if (graphics instanceof Graphics2D) {
                    graphics2D.fill(this.ellipse);
                } else {
                    graphics.fillOval((int)(d - (double)f), (int)(d2 - (double)f), (int)(f * 2.0f), (int)(f * 2.0f));
                }
                graphics.setColor(color);
                if (graphics instanceof Graphics2D) {
                    graphics2D.draw(this.ellipse);
                    break;
                }
                graphics.drawOval((int)(d - (double)f), (int)(d2 - (double)f), (int)(f * 2.0f), (int)(f * 2.0f));
                break;
            }
            case 3: {
                this.drawTriangle(graphics, d, d2, f);
                break;
            }
            case 4: {
                if (graphics instanceof Graphics2D) {
                    this.line.setLine(d - (double)f, d2, d + (double)f, d2);
                    graphics2D.draw(this.line);
                    this.line.setLine(d, d2 - (double)f, d, d2 + (double)f);
                    graphics2D.draw(this.line);
                    break;
                }
                graphics.drawLine((int)(d - (double)f), (int)d2, (int)(d + (double)f), (int)d2);
                graphics.drawLine((int)d, (int)(d2 - (double)f), (int)d, (int)(d2 + (double)f));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid nameIndex for psym");
            }
        }
    }

    public void drawTriangle(Graphics graphics, double d, double d2, float f) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.line.setLine(d, d2 - (double)f, d + (double)f, d2 + (double)f);
            graphics2D.draw(this.line);
            this.line.setLine(d + (double)f, d2 + (double)f, d - (double)f, d2 + (double)f);
            graphics2D.draw(this.line);
            this.line.setLine(d - (double)f, d2 + (double)f, d, d2 - (double)f);
            graphics2D.draw(this.line);
        } else {
            graphics.drawLine((int)d, (int)(d2 - (double)f), (int)(d + (double)f), (int)(d2 + (double)f));
            graphics.drawLine((int)(d + (double)f), (int)(d2 + (double)f), (int)(d - (double)f), (int)(d2 + (double)f));
            graphics.drawLine((int)(d - (double)f), (int)(d2 + (double)f), (int)d, (int)(d2 - (double)f));
        }
    }

    public static Psym parsePsym(String string) {
        if (string.equals("none")) {
            return NONE;
        }
        if (string.equals("dots")) {
            return DOTS;
        }
        if (string.equals("circles")) {
            return CIRCLES;
        }
        if (string.equals("triangles")) {
            return TRIANGLES;
        }
        if (string.equals("cross")) {
            return CROSS;
        }
        throw new IllegalArgumentException(string);
    }
}

