/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.ObjectLocator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class Legend
extends DasCanvasComponent {
    static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    ArrayList elements = new ArrayList();
    ObjectLocator locator;

    public Legend() {
        this.getMouseAdapter().addMenuItem(new JMenuItem(this.getEditAction()));
    }

    private Action getEditAction() {
        return new AbstractAction("Renderer Properties"){

            public void actionPerformed(ActionEvent actionEvent) {
                Point point = Legend.this.getMouseAdapter().getMousePressPosition();
                LegendElement legendElement = (LegendElement)Legend.this.locator.closestObject(point);
                if (legendElement == null) {
                    return;
                }
                Renderer renderer = legendElement.getRenderer();
                PropertyEditor propertyEditor = new PropertyEditor(renderer);
                propertyEditor.showDialog(Legend.this);
            }
        };
    }

    public static Icon getIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(6, 10, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, 6, 10);
        return new ImageIcon(bufferedImage);
    }

    public void add(SymbolLineRenderer symbolLineRenderer, String string) {
        LegendElement legendElement = new LegendElement(symbolLineRenderer, string);
        this.elements.add(legendElement);
    }

    public void remove(SymbolLineRenderer symbolLineRenderer) {
        for (int i = 0; i < this.elements.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.elements.get(i);
            if (legendElement.rend == null || symbolLineRenderer != legendElement.rend) continue;
            this.elements.remove(i);
            this.repaint();
            break;
        }
    }

    public void add(Icon icon, String string) {
        this.elements.add(new LegendElement(icon, string));
    }

    public void resize() {
        this.setBounds(DasRow.toRectangle(this.getRow(), this.getColumn()));
    }

    public void paintComponent(Graphics graphics) {
        int n;
        String string;
        Icon icon;
        LegendElement legendElement;
        int n2;
        if (this.elements.size() == 0) {
            logger.info("no elements in legend, returning.");
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = 5;
        int n4 = 5;
        int n5 = 5;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Color color = graphics2D.getColor();
        this.locator = new ObjectLocator();
        boolean bl = true;
        int n6 = 0;
        for (n2 = 0; n2 < this.elements.size(); ++n2) {
            legendElement = (LegendElement)this.elements.get(n2);
            icon = legendElement.getIcon();
            string = "";
            if (!legendElement.isVisible()) {
                string = "\u00b9";
                bl = false;
            }
            n = fontMetrics.stringWidth(legendElement.getLabel() + string);
            int n7 = fontMetrics.getHeight() > icon.getIconHeight() ? fontMetrics.getHeight() : icon.getIconHeight() + n3;
            int n8 = n + n4 + 20;
            if (n8 > n6) {
                n6 = n8;
            }
            n5 += n7;
        }
        if (!bl) {
            Font font = graphics2D.getFont();
            graphics2D.setFont(font.deriveFont((float)font.getSize() * 0.66f));
            n5 += graphics2D.getFontMetrics().getHeight() / 2;
            graphics2D.setFont(font);
            n5 += graphics2D.getFontMetrics().getHeight() / 2;
        }
        graphics2D.setColor(new Color(255, 255, 255, 240));
        graphics2D.fill(new Rectangle(0, 0, n6 + 10, n5 - 1));
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.draw(new Rectangle(0, 0, n6 + 10, n5 - 1));
        n4 = 5;
        n5 = 5;
        for (n2 = 0; n2 < this.elements.size(); ++n2) {
            legendElement = (LegendElement)this.elements.get(n2);
            icon = legendElement.getIcon();
            icon.paintIcon(this, graphics2D, n4, n5);
            string = "";
            if (!legendElement.isVisible()) {
                string = "\u00b9";
                bl = false;
            }
            graphics2D.drawString(legendElement.getLabel() + string, n4 + 20, n5 + icon.getIconHeight());
            n = fontMetrics.getHeight() > icon.getIconHeight() ? fontMetrics.getHeight() : icon.getIconHeight() + n3;
            this.locator.addObject(new Rectangle(n4, n5 - n3 / 2, n6, n), legendElement);
            n5 += fontMetrics.getHeight() > icon.getIconHeight() ? fontMetrics.getHeight() : icon.getIconHeight() + n3;
        }
        if (!bl) {
            Font font = graphics2D.getFont();
            graphics2D.setFont(font.deriveFont((float)font.getSize() * 0.66f));
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.drawString("\u00b9 not drawn", n4 + 10, n5 += graphics2D.getFontMetrics().getHeight() / 2);
            graphics2D.setFont(font);
            n5 += graphics2D.getFontMetrics().getHeight() / 2;
        }
        graphics2D.setColor(color);
        int n9 = n6 + 10 + 1;
        int n10 = n5;
    }

    class LegendElement {
        Icon icon;
        Psym psym;
        PsymConnector psymConnector;
        SymbolLineRenderer rend;
        Color color;
        String label;
        Legend parent;

        Icon getIcon() {
            if (this.rend != null) {
                return this.rend.getListIcon();
            }
            return this.icon;
        }

        void update() {
            if (this.rend != null) {
                this.icon = this.rend.getListIcon();
            }
        }

        Renderer getRenderer() {
            return this.rend;
        }

        private String getLabel() {
            return this.label;
        }

        private boolean isVisible() {
            return this.rend == null || this.rend.isActive();
        }

        LegendElement(SymbolLineRenderer symbolLineRenderer, String string) {
            this.icon = symbolLineRenderer.getListIcon();
            this.label = string;
            this.rend = symbolLineRenderer;
        }

        LegendElement(Icon icon, String string) {
            this.icon = icon;
            this.label = string;
        }
    }
}

