/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.WritableTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageVectorDataSetRenderer
extends Renderer {
    GeneralPath path;
    Datum xTagWidth;
    BufferedImage plotImage;
    DatumRange imageXRange;
    DatumRange imageYRange;
    int saturationHitCount = 5;

    public ImageVectorDataSetRenderer(DataSetDescriptor dataSetDescriptor) {
        super(dataSetDescriptor);
    }

    protected Element getDOMElement(Document document) {
        return null;
    }

    private void renderGhostly(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(graphics2D, dasAxis, dasAxis2, this.lastException);
        } else if (this.plotImage != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            Point2D.Double double_ = new Point2D.Double(dasAxis.transform(this.imageXRange.min()), dasAxis2.transform(this.imageYRange.max()));
            graphics2D.drawImage((Image)this.plotImage, (int)(((Point2D)double_).getX() + 0.5), (int)(((Point2D)double_).getY() + 0.5), this.getParent());
        }
        graphics2D.dispose();
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        this.renderGhostly(graphics, dasAxis, dasAxis2);
    }

    private void ghostlyImage2(DasAxis dasAxis, DasAxis dasAxis2, VectorDataSet vectorDataSet) {
        int n = dasAxis2.getRow().getHeight();
        int n2 = dasAxis.getColumn().getWidth();
        this.logger.fine("create Image");
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f / (float)this.saturationHitCount));
        graphics2D.translate(-dasAxis.getColumn().getDMinimum(), -dasAxis2.getRow().getDMinimum());
        DatumRange datumRange = dasAxis.getDatumRange();
        int n3 = DataSetUtil.getPreviousColumn(vectorDataSet, datumRange.min());
        int n4 = DataSetUtil.getNextColumn(vectorDataSet, datumRange.max());
        int n5 = -992;
        int n6 = 0;
        int n7 = 0;
        if (vectorDataSet.getXLength() > 0) {
            for (int i = n3; i <= n4; ++i) {
                if (vectorDataSet.getDatum(i).isFill()) {
                    n5 = -992;
                    continue;
                }
                int n8 = (int)dasAxis2.transform(vectorDataSet.getDatum(i));
                int n9 = (int)dasAxis.transform(vectorDataSet.getXTagDatum(i));
                switch (n5) {
                    case -992: {
                        graphics2D.fillRect(n9, n8, 1, 1);
                        n6 = n9;
                        n7 = n8;
                        break;
                    }
                    case -991: {
                        graphics2D.draw(new Line2D.Float(n6, n7, n9, n8));
                        graphics2D.fillRect(n9, n8, 1, 1);
                        n6 = n9;
                        n7 = n8;
                    }
                }
                n5 = -991;
            }
        }
        this.logger.fine("done");
        this.plotImage = bufferedImage;
        this.imageXRange = dasAxis.getDatumRange();
        this.imageYRange = dasAxis2.getDatumRange();
    }

    private TableDataSet histogram(RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2, VectorDataSet vectorDataSet) {
        rebinDescriptor.setOutOfBoundsAction(-3);
        rebinDescriptor2.setOutOfBoundsAction(-3);
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newSimple(rebinDescriptor.numberOfBins(), rebinDescriptor.getUnits(), rebinDescriptor2.numberOfBins(), rebinDescriptor2.getUnits(), Units.dimensionless);
        if (vectorDataSet.getXLength() > 0) {
            Units units = rebinDescriptor.getUnits();
            Units units2 = rebinDescriptor2.getUnits();
            Units units3 = Units.dimensionless;
            int n = DataSetUtil.getNextColumn(vectorDataSet, rebinDescriptor.binStop(rebinDescriptor.numberOfBins() - 1));
            for (int i = DataSetUtil.getPreviousColumn(vectorDataSet, rebinDescriptor.binStart(0)); i <= n; ++i) {
                int n2 = rebinDescriptor.whichBin(vectorDataSet.getXTagDouble(i, units), units);
                int n3 = rebinDescriptor2.whichBin(vectorDataSet.getDouble(i, units2), units2);
                if (n2 == -1 || n3 == -1) continue;
                double d = writableTableDataSet.getDouble(n2, n3, units3);
                writableTableDataSet.setDouble(n2, n3, d + 1.0, units3);
            }
        }
        return writableTableDataSet;
    }

    private void ghostlyImage(DasAxis dasAxis, DasAxis dasAxis2, VectorDataSet vectorDataSet) {
        DatumRange datumRange = dasAxis.getDatumRange();
        RebinDescriptor rebinDescriptor = new RebinDescriptor(datumRange.min(), datumRange.max(), dasAxis.getColumn().getWidth(), dasAxis.isLog());
        DatumRange datumRange2 = dasAxis2.getDatumRange();
        RebinDescriptor rebinDescriptor2 = new RebinDescriptor(datumRange2.min(), datumRange2.max(), dasAxis2.getRow().getHeight(), dasAxis2.isLog());
        TableDataSet tableDataSet = this.histogram(rebinDescriptor, rebinDescriptor2, vectorDataSet);
        int n = rebinDescriptor2.numberOfBins();
        int n2 = rebinDescriptor.numberOfBins();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3;
                int n4 = i - 0 + (n - j - 1) * n2;
                int n5 = 255 - 256 * (int)tableDataSet.getDouble(i, j, Units.dimensionless) / this.saturationHitCount;
                if (n5 < 0) {
                    n5 = 0;
                }
                nArray[n4] = n3 = (n5 << 16) + (n5 << 8) + n5;
            }
        }
        this.plotImage = new BufferedImage(n2, n, 1);
        WritableRaster writableRaster = this.plotImage.getRaster();
        writableRaster.setDataElements(0, 0, n2, n, nArray);
        this.imageXRange = datumRange;
        this.imageYRange = datumRange2;
    }

    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) throws DasException {
        super.updatePlotImage(dasAxis, dasAxis2, dasProgressMonitor);
        long l = System.currentTimeMillis();
        VectorDataSet vectorDataSet = (VectorDataSet)this.getDataSet();
        if (vectorDataSet == null) {
            return;
        }
        DatumRange datumRange = dasAxis.getDatumRange();
        int n = DataSetUtil.getPreviousColumn(vectorDataSet, datumRange.min());
        int n2 = DataSetUtil.getNextColumn(vectorDataSet, datumRange.max());
        if (n2 - n > 20 * dasAxis.getColumn().getWidth()) {
            this.logger.info("rendering with histogram");
            this.ghostlyImage(dasAxis, dasAxis2, vectorDataSet);
        } else {
            this.logger.info("rendinging with lines");
            this.ghostlyImage2(dasAxis, dasAxis2, vectorDataSet);
        }
        this.logger.info("done updatePlotImage");
    }

    public void setSaturationHitCount(int n) {
        if (n > 10) {
            n = 10;
        }
        this.saturationHitCount = n;
        this.update();
    }

    public int getSaturationHitCount() {
        return this.saturationHitCount;
    }

    protected void uninstallRenderer() {
    }

    protected void installRenderer() {
    }
}

